#include <iostream>
#include <qsettings.h>
#include <cstdlib>

#include "SRTPWrapper.h"

using namespace std;

SRTPWrapper* SRTPWrapper::instance = 0;
int SRTPWrapper::countReferences = 0;
const string SRTPWrapper::err_array[] = {
	"err_status_ok", 
	"err_status_fail",
	"err_status_bad_param",
	"err_status_alloc_fail",
	"err_status_dealloc_fail",
	"err_status_init_fail",
	"err_status_terminus",
	"err_status_auth_fail",
	"err_status_cipher_fail",
	"err_status_replay_fail",
	"err_status_replay_old",
	"err_status_algo_fail",
	"err_status_no_such_op",
	"err_status_no_ctx",
	"err_status_cant_check",
	"err_status_key_expired"
};

bool SRTPWrapper::libInit = false;

SRTPWrapper::SRTPWrapper(){
	cout << "SRTP Wrapper Instance created" << endl;
	sessionActive = false;
	outboundStreamActive = false;
	inboundStreamActive = false;
	if(!SRTPWrapper::libInit){
		if(err_status_t error = srtp_init()){
			libError(error);
			cout << "Init from libsrtp failed! Exit!" << endl;
			exit(1);
		}
		SRTPWrapper::libInit = true;
	}
	localSSRC = rand();
}

SRTPWrapper::~SRTPWrapper(){
		cout << "SRTP Wrapper Instance deleted" << endl;
		if(sessionActive)
			delete session;
		SRTPWrapper::instance = 0;
}

SRTPWrapper* SRTPWrapper::getInstance(){
	if(SRTPWrapper::instance == 0) {
		SRTPWrapper::instance = new SRTPWrapper();
	}
	countReferences++;
	return SRTPWrapper::instance;
}

void SRTPWrapper::dispose(void){
	cout << "Calling dispose" << endl;
	if(SRTPWrapper::countReferences == 1)
		delete this;
	SRTPWrapper::countReferences--;
}

err_status_t SRTPWrapper::newSession(ssrc_t ssrc){
	session = new srtp_ctx_t();
	
	//Create session policy
	srtp_policy_t policy;
	crypto_policy_set_rtp_default(&policy.rtp);
	crypto_policy_set_rtcp_default(&policy.rtcp);
	policy.ssrc.value = ssrc.value;
	policy.ssrc.type = ssrc.type;
	policy.key = this->readKey();
	policy.next = NULL;
	
	err_status_t err = srtp_create(&session, &policy);
	return err;
}

void SRTPWrapper::protect(unsigned char* rtp_h, int* length){
	rtp_hdr_t* hdr = (rtp_hdr_t *) rtp_h;
	hdr->ssrc = localSSRC; //Remove this line to disable random ssrc replacement
	
	#ifdef QT_THREAD_SUPPORT
	if(!sessionActive){
		mutex.lock();
	#endif
		if (!sessionActive){
			ssrc_t ssrc;
			ssrc.value = hdr->ssrc;
			ssrc.type = ssrc_any_outbound;
			if (err_status_t err = this->newSession(ssrc)){
			    libError(err);
				cout << "SRTP session creation failed (protect)." << endl;
			}else{
				cout << "SRTP session created!" << endl;
				sessionActive = true;
			}
		}
	#ifdef QT_THREAD_SUPPORT
		mutex.unlock();
	}
	#endif
	else if(!outboundStreamActive){
		session->k_template->direction = dir_srtp_sender;
		outboundStreamActive = true;
	}
	
	if(err_status_t err = srtp_protect(session, rtp_h, length))
		libError(err);
}

void SRTPWrapper::unprotect(unsigned char* rtp_h, int* length){
	rtp_hdr_t* hdr = (rtp_hdr_t *) rtp_h;
	
	#ifdef QT_THREAD_SUPPORT
	if(!sessionActive){
		mutex.lock();
	#endif
		if (!sessionActive){
			ssrc_t ssrc;
			ssrc.value = hdr->ssrc;
			ssrc.type = ssrc_any_inbound;
			if (err_status_t err = this->newSession(ssrc)){
			    libError(err);
				cout << "SRTP session creation failed (unprotect)." << endl;
			}else{
				cout << "SRTP session created!" << endl;
				sessionActive = true;
			}
		}
	#ifdef QT_THREAD_SUPPORT
		mutex.unlock();
	}
	#endif
	else if(!inboundStreamActive){
		session->k_template->direction = dir_srtp_receiver;
		inboundStreamActive = true;
	}
	
	if(err_status_t err = srtp_unprotect(session, rtp_h, length))
		libError(err);
}

octet_t* SRTPWrapper::readKey(){
	QSettings settings;
	QString qkey = settings.readEntry("/kphone/SRTP/KeyValue", "");
	string test = qkey;
	if(test.length() < 30){
		int i = 30 - test.length();
		test.append(i, '0');
		cout << "WARNING: The chosen key is to short (<30) and will be padded!" << endl;
	}
	string* strKey = new string(test);
	unsigned char* tmp = (unsigned char*) strKey->c_str();
	return tmp;
}

string SRTPWrapper::getErrorname(err_status_t err){
	return SRTPWrapper::err_array[err];
}

void SRTPWrapper::libError(err_status_t err){
	cout << "WARNING: libSRTP reported an Error: Code "<< err << " (" << 
		getErrorname(err) << ")!" << endl;
}
