
#include <iostream.h>
#include <kore/kore.h>
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>
#include <kore/pluginloader.h>
#include <kore/plugin.h>

#include "if/koredialog.h"

#include <unistd.h>

using namespace kore;

/**
 * Main Kore application.
 * It loads and starts the Kernel
 */
int main(int argc, char* argv[])
{
    const char* pluginNames[] = {"koredlg_cout", "koredlg_qt", "koredlg_kde", "koredlg_gnome", "koredlg_be", "koredlg_atheos", "koredlg_mfc", 0};
    Plugin* plugins[20];
    // force creating the kernel
    Kernel::instance();

    PluginLoader* loader = dynamic_cast<PluginLoader*> (Kernel::instance()->serviceManager()->registeredProvider("Kore/Kernel/Plugin Loader"));
    int i;
    for(i=0; pluginNames[i]; i++)
    {
        plugins[i] = loader->runPlugin(pluginNames[i]);
        if( plugins[i] )
            cout << "Found: " << plugins[i]->info()->name() << endl;
        else
            cout << "Warning: " << loader->lastError() << endl;
    }
    ServiceProvider** providers = Kernel::instance()->serviceManager()->registeredProviders(KOREDLG_SERVICE);
    KoreDialog* dlg;
    for(i=0; providers[i]; i++)
    {
        dlg = dynamic_cast<KoreDialog*> (providers[i]);
        if( dlg )
            dlg->showMessage("Hello World!");
        else
            cout << "Warning: ServiceProvider '" << providers[i]->info()->name() << "' is not a KoreDialog." << endl;
    }
    delete[] providers;
    for(i=0; pluginNames[i]; i++)
    {
        if( plugins[i] )
            loader->closePlugin(plugins[i]);
    }
    delete Kernel::instance();
//    sleep(10);
    cout <<"exit." << endl;
    return 0;
}
