
#include <kore/version.h>
#include <kore/module.h>
#include <kore/modulemanager.h>
#include <kore/kernel.h>
#include <iostream>

#define MODULE_TYPE "Module"

using namespace kore;

Module::Info::Info()
{
    setInfo();
}
Module::Info::Info(Module* module, const char* name, const char* type, const char* description, const Version* version, const Version* api)
{
    setInfo(module, name, type, description, version, api);
}
Module::Info::~Info()
{
}

Module* Module::Info::module() const
{
    return _module;
}
const char* Module::Info::name() const
{
    return _name;
}
const char* Module::Info::type() const
{
    return _type;
}
const char* Module::Info::description() const
{
    return _description;
}
const Version* Module::Info::version() const
{
    return _version;
}
const Version* Module::Info::APIVersion() const
{
    return _api;
}

void Module::Info::setModule(Module* module)
{
    _module = module;
}
void Module::Info::setName(const char* name)
{
    _name = name;
}
void Module::Info::setType(const char* type)
{
    if( type )
        _type = type;
    else
        setType(MODULE_TYPE);
}
void Module::Info::setDescription(const char* description)
{
    _description = description;
}
void Module::Info::setVersion(const Version* version)
{
    _version = version;
}
void Module::Info::setAPIVersion(const Version* api)
{
    _api = api;
}
void Module::Info::setInfo(Module* module, const char* name, const char* type, const char* description, const Version* version, const Version* api)
{
    setModule(module);
    setName(name);
    setType(type);
    setDescription(description);
    setVersion(version);
    setAPIVersion(version);
}

Module::Module()
{
    setInfo();
}
Module::Module(const Info* info)
{
    setInfo(info);
}

const Module::Info* Module::info() const
{
    return _info;
}
void Module::setInfo(const Module::Info* info)
{
    _info = info;
}

void Module::registeringModule(ModuleManager* mm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registering to " << mm->info()->name() << " " << (const char*)*(mm->info()->version()) << endl;
}
void Module::moduleRegistered(ModuleManager* mm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : registered to " << mm->info()->name() << " " << (const char*)*(mm->info()->version()) << endl;
}
void Module::unregisteringModule(ModuleManager* mm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistering from " << mm->info()->name() << " " << (const char*)*(mm->info()->version()) << endl;
}
void Module::moduleUnregistered(ModuleManager* mm)
{
    //cout << info()->name() << " " << (const char*)*(info()->version()) << " : unregistered from " << mm->info()->name() << " " << (const char*)*(mm->info()->version()) << endl;
}

Module::~Module()
{
}
