/***************************************************************************
                          infoquery.cpp  -  description
                             -------------------
    begin                : Mon Nov 22 1999
    copyright            : (C) 1999 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "infoquery.h"

#include <jabbercore.h>

InfoQuery::InfoQuery( QueryManager *parent )
        : QObject( parent )
{
        XMLNode::setName( "iq" );
	_parent = parent;
}

InfoQuery::InfoQuery( QueryManager *parent, XMLNode *t )
        : QObject( parent )
	, XMLNode( *t )
{
        _parent = parent;
}

void InfoQuery::send()
{
	_parent->sendQuery( this );
}

void InfoQuery::responce(InfoQuery *responce)
{
	emit( responceRecieved(this, responce) );

        delete responce;
        delete this;
}


/*****************************************************************************
                        QueryXMLNS
*****************************************************************************/
QueryXMLNS::QueryXMLNS( QueryManager *parent, QString newNS, QObject *caller, const char *slot )
        : QObject( caller, 0 )
{
        _xmlns = newNS;
	_parent = parent;

        connect( this, SIGNAL( queryRecieved(InfoQuery *)), caller, slot );
}

void QueryXMLNS::recievedIQTag(XMLNode *t)
{
        InfoQuery *iq = new InfoQuery( _parent, t );

        emit( queryRecieved( iq ) );

	delete iq;
}

/************************************************************************
                        Query Manager
************************************************************************/
QueryManager::QueryManager(QWidget *parent, const char *name ) : QObject(parent,name)
{
	nextAvailID = 0;
}

void QueryManager::sendQuery(InfoQuery *iq)
{
	QString queryID;

	_pendingRequests.append( iq );

	if(iq->getID().isEmpty() )
	{
		nextAvailID++;

		queryID.sprintf("ID0x%x", nextAvailID);
		iq->setID(queryID.copy());
	}

	jabber->sendTag( *iq );
}

InfoQuery *QueryManager::createQuery()
{
        return new InfoQuery( this );
}

QueryXMLNS *QueryManager::registerNS( QString xmlns, QObject *reciever, const char *slot )
{
        QueryXMLNS *callback = new QueryXMLNS( this, xmlns, reciever, slot );

        _XMLNSCallbacks.append( callback );

        return callback;
}

void QueryManager::incomingPacket(XMLNode *t)
{
	//printf("QueryManager::incomingPacket: %s\n", (const char *)t->getName());
 	if (strcmp(t->getName(), "iq") == 0)
 	{
 		if (strcmp(t->getAttribute("type"), "result") == 0
 		   || strcmp(t->getAttribute("type"), "error") == 0)
 		{

 			QString queryID;
 			InfoQuery *responce = new InfoQuery( this, t);
	 		InfoQuery *match, *item;

 			queryID = responce->getID();

 			unsigned int num;
 			for( num=0; num<_pendingRequests.count(); num++ )
		 	{
		 		item = _pendingRequests.at( num );

		 		//printf("Checking %s aginst %s\n", (const char *)queryID, (const char *)item->getID());
 			 	if (strcmp(item->getID(), queryID) == 0)
 			 	{
 		 			//printf("Found a match!\n");
 		 	 		match = _pendingRequests.take( num );
			 	 	match->responce(responce);

	 		 	}
 	 		}
 		}
 		else
 		{
 			// Check our XMLCallbacks
 			unsigned int count_i;
 			QueryXMLNS *item;
 			QString ns;
 			ns = t->getChildNode("query")->getAttribute("xmlns");

 			for( count_i=0; count_i<_XMLNSCallbacks.count(); count_i++ )
 			{
 			 	item = _XMLNSCallbacks.at( count_i );
 			 	if (strcmp(item->getNS(), ns) == 0)
 			 	{
 			 	 	item->recievedIQTag( t );
 			 	}
 			}
 		}

 	}
}

