/***************************************************************************
                          group.cpp  -  description
                             -------------------
    begin                : Sun Oct 22 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <group.h>
#include <user.h>

Group::Group( QString name )
 	: QObject( 0, name)
{
	_name = name;
}

void Group::addUser( User *u )
{
	unsigned int i;
        bool found = false;

        for (i=0; i<_users.count(); i++)
        {
        	if (_users.at(i)->u == u)
                	found = true;
        }

        if (!found)
        {
        	UserPtr *ptr = new UserPtr;
                ptr->u = u;
        	_users.append( ptr );

                emit( newUser( this, u ) );
        }
}

void Group::removeUser( User *u )
{
	unsigned int i, at=0;
        bool found = false;

        for (i=0; i<_users.count(); i++)
        {
        	if (_users.at(i)->u == u)
                {
                	found = true;
                 	at = i;
                }
        }

        if (found)
        {
        	_users.remove(at);

                emit( deleteUser( this, u ) );

                if ( _users.count() == 0 )
                {
                	emit( deletedGroup( this ) );
                        delete this;
                }
         }
}



