/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CONFIGDIALOGIMPL_H
#define CONFIGDIALOGIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "configdialog.h"

#include <kkeydialog.h>
#include <ksystemtray.h>
#include <kglobalaccel.h>

#include "kommando.h"

class KService;

/**
 * @short Application Main Window
 * @author Daniel Stöckel <the_docter@gmx.net>
 * @version 0.4.0
 */

class ConfigDialogImpl : public ConfigDialog
{
	Q_OBJECT

	public:
		ConfigDialogImpl(QWidget* parent = 0, const char* name = 0, WFlags fl = Qt::WType_Dialog );
		~ConfigDialogImpl();
		
		/*$PUBLIC_FUNCTIONS$*/
		virtual QListView* listView(){return menuListView;}

	protected:
		KSystemTray sysTray;
		KGlobalAccel Shortcut;
		Kommando kommandoWin;
		void createEntry(QString kind);  //This is a helper function to add a new entry to the Listview
		bool configChanged;
		void readConfig();
		void setChanged(bool state);
		
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/
		virtual void slotButtonUpPressed();
		virtual void slotButtonDownPressed();
		virtual void slotCustomSizeCheckboxToggled(bool);
		virtual void slotSchemeComboboxChanged(const QString&);
		virtual void slotMenuRadiusSpinboxChanged(int);
		virtual void reject();
		virtual void accept();
		virtual void slotShortcutChanged(const KShortcut& cut);
		virtual void slotResetClicked();
		virtual void slotApplyClicked();
		virtual void slotCommandoTyped(const QString& commando);
		virtual void slotMenuViewClicked(QListViewItem* item);
		virtual void slotNewIcon();
		virtual void slotRemoveClicked();
		virtual void slotAddButtonClicked();
		virtual void slotAddMenuClicked();
		virtual void slotListBoxClicked(QListBoxItem* item);
		virtual void slotColorButtonClicked(const QColor& color);
		virtual void slotOpacitySliderChanged(int value);
		virtual void slotNavButtonSizeChanged(const QString&);
		virtual void slotMenuButtonSizeChanged(const QString&);
		virtual void slotAddService(KService* service);
};

#endif

