/***************************************************************************
                          mount.cpp  -  description
                             -------------------
   begin                : Son Apr 16 19:02:07 CEST 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>

#include "mount.h"
#include "myktreelistitem.h"

Mount::Mount (QObject * parent, MyShareItem * sitem, int smbmountversion, const QString & mountpoint, bool expl, bool automount):
QObject (parent)
{
  mountp = mountpoint;
  shareitem = sitem;
  shareitem->setAutomount (automount);
  ver = smbmountversion;
  exploreaftermount = expl;
  proc = 0;
  out = "";
  err = "";
}

Mount::~Mount ()
{
  if (proc)
    {
      kdDebug (7199) << "Process not exited..." << endl;
      proc->kill ();
      delete proc;
    }
}

/** Startet den mount-Process */
void
Mount::start ()
{
  proc = new KProcess ();
  setOptions (ver);
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (mountStdout (KProcess *, char *, int)));
  connect (proc, SIGNAL (receivedStderr (KProcess *, char *, int)), this,
	   SLOT (mountStderr (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::All);
}

/** Fgt die Optionen entsprechend der Version an */
void
Mount::setOptions (int ver)
{
  if (ver == 205)
    setOptionsV205 ();
  else
    setOptionsV206 ();
}



/** Optionen fuer Version 2.05a werden gesetzt */
void
Mount::setOptionsV205 ()
{
  QString service, options, command, ip;
  if (proc)
    {
      (*proc) << "smbmount";
      command = "(ver 2.0.5a): smbmount ";

      service = "//";
      service += shareitem->getHostName ();	//hostname
      service += "/";
      service += shareitem->Name ();	//sharename
      (*proc) << service;
      command += service + " ";

      (*proc) << mountp;
      command += mountp + " ";

      (*proc) << "-d" << "2";
      command += " -d 2";

      (*proc) << "-E";
      command += " -E";

      if (shareitem->getUsername ().length () > 0)
	{
	  (*proc) << "-U" << shareitem->getUsername ();
	  command += " -U ";
	  command += shareitem->getUsername ();
	}
      if (shareitem->getUsername ().length () <= 0)
	{
	  (*proc) << "-N";
	  command += " -N";
	}
      if (((MyHostItem *) shareitem->parent ())->getNetIP ())
	{
	  ((MyHostItem *) shareitem->parent ())->getIP (&ip);
	  (*proc) << "-I" << ip;
	  command += " -I ";
	  command += ip;
	}
      kdDebug (7199) << "Command : " << command << endl;
      emit Command (command);
    }
}

/** Optionen fuer Version 2.06 werden gesetzt */
void
Mount::setOptionsV206 ()
{
  QString service, options, command, ip;

  if (proc)
    {
      (*proc) << "smbmount";
      command = "(ver 2.0.6): smbmount ";

      service = "//";
      service += shareitem->getHostName ();	//hostname
      service += "/";
      service += shareitem->Name ();	//sharename
      (*proc) << service;
      command += service + " ";

      (*proc) << mountp;
      command += mountp + " ";


      (*proc) << "-o";
      options = "debug=2";
      if (((MyHostItem *) shareitem->parent ())->getNetIP ())
	{
	  ((MyHostItem *) shareitem->parent ())->getIP (&ip);
	  options += ",ip=";
	  options += ip;
	}
      if (shareitem->getUsername ().length () > 0)
	{
	  options += ",username=";
	  options += (shareitem->getUsername ());
/*	  if (shareitem->getPassword ().length () > 0)
	    {
	      options += ",password=";
	      options += shareitem->getPassword ();
	    }
*/	}
      else
	options += ",guest";
      options += ",workgroup=";
      options += shareitem->getWorkgroupName ();
      (*proc) << options;
      command += " -o \"";
      command += options + "\"";
      kdDebug (7199) << "Command : " << command << endl;
      emit Command (command);
    }
}

/* Ausgaben werden Abgefangen */
void
Mount::mountStdout (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  out += b;
  emit Output (b);
}


/* Ausgaben werden Abgefangen */
void
Mount::mountStderr (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  char buf[33];
  kdWarning (7199) << "smbmount-error : " << b << endl;
  emit Output (b);
  if (b.contains ("Password:"))
    {
      strcpy (buf, shareitem->getPassword ());
      strcat (buf, "\n");
      proc->writeStdin (buf, strlen (buf));
      kdDebug (7199) << "***password written***" << endl;
      emit Output ((QString) "***password written***");
    }
  else
    err += b;
}


/** Wird aufgerufen wenn der Process sich beendet */
void
Mount::onProcExit (KProcess * killedproc)
{
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdDebug (7199) << "Mmmhhh... not my process" << endl;
  emit isExited (this, err, shareitem);
}
