/***************************************************************************
                          scan.cpp  -  description
                             -------------------
    begin                : Mon Jan 8 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klocale.h>
#include <kdebug.h>


#include <komba2.h>

#include "komba2doc.h"

#include "scan.h"
#include "myktreelistitem.h"

scan::scan (QObject * parent, const char *name):QObject (parent, name)
{
  smbclworkingcount = 0;
  smbcltodolist = new QPtrStack < MyHostItem >;
}

scan::~scan ()
{
}

void
scan::scanHost (MyHostItem * host)
{
  if (host)
    {
      if (!(host->issearched ()))
	{
	  if (smbclworkingcount < 10)
	    {
	      ((Komba2App *) ((Komba2Doc *) (parent ()))->parent ())->
		slotStatusMsg (i18n ("Scanning hosts"));
	      host->issearched (true);
	      smbclworkingcount++;

	      smbclient *smbcl = new smbclient (this, host);
	      connect (smbcl,
		       SIGNAL (newShare
			       (const QString &, const QString &,
				const QString &, const QString &,
				MyShareItem::ShareTypes)),
		       ((Komba2Doc *) (parent ())),
		       SLOT (InsertShare
			     (const QString &, const QString &,
			      const QString &, const QString &,
			      MyShareItem::ShareTypes)));
	      connect (smbcl,
		       SIGNAL (newHost
			       (const QString &, const QString &,
				const QString &, u_long, const QString &,
				const QString &)),
		       ((Komba2Doc *) (parent ())),
		       SLOT (InsertHost
			     (const QString &, const QString &,
			      const QString &, u_long, const QString &,
			      const QString &)));
	      connect (smbcl,
		       SIGNAL (newWorkgroup
			       (const QString &, const QString &, bool)),
		       ((Komba2Doc *) (parent ())),
		       SLOT (InsertWorkgroup
			     (const QString &, const QString &, bool)));
	      connect (smbcl,
		       SIGNAL (isExited
			       (smbclient *, const QString &, MyHostItem *)),
		       this,
		       SLOT (smbclientIsExited
			     (smbclient *, const QString &, MyHostItem *)));
	      smbcl->start ();
	    }
	  else
	    smbcltodolist->push (host);
	}
    }
  else
    kdWarning (7199) << "Nettree::scanHost() -- hostitem is null" << endl;
}

/***************************************************************************
 *                                                                         *
 *   Slot for connecting with signal smbclient::isExited(..)					   	 *
 *   ErrorHandling                                                         *
 ***************************************************************************/
void
scan::smbclientIsExited (smbclient * smbcl, const QString & err,
			 MyHostItem * hostitem)
{
  smbclworkingcount--;
  if ((err.contains ("ERRbadpw") > 0) || (err.contains ("ERRnoaccess") > 0))
    {
      kdDebug (7199) << "host:" << hostitem->Name () << "; " << err << endl;
      if (!((Komba2Doc *) parent ())->options ()->noPasswordDialog ())
	if (((Komba2Doc *) parent ())->
	    setPassword ((QListViewItem *) hostitem))
	  {
	    hostitem->issearched (false);
	    this->scanHost (hostitem);
	  }
    }

  else if ((err.contains ("Connection to ") > 0)
	   && (err.contains ("failed") > 0))
    {
      if (hostitem)
	{
	  hostitem->setDown (true);
	  hostitem->issearched (true);
	  kdDebug (7199) << "smbclientexit :" << "connecton to " << hostitem->
	    Name () << "\tWG:" << hostitem->
	    getWorkgroupName () << "failed" << err << endl;
	}
    }
  else if (hostitem)
    {
      hostitem->setDown (false);
      hostitem->issearched (true);
    }
  if (smbcl)
    delete smbcl;
  while ((smbclworkingcount < 10) && (smbcltodolist->count () > 0))
    scanHost (smbcltodolist->pop ());
  if (smbclworkingcount < 1)
    emit allSmbClientExited ();

}
