h48009
s 00006/00006/00218
d D 1.16 00/08/26 19:52:47 nitehawk 17 16
c convert all logging calls into logmsg
cC
cK38883
e
s 00000/00002/00224
d D 1.15 00/08/10 09:53:21 nitehawk 16 15
c Remove debug message from list creation
cC
cK36040
e
s 00002/00002/00224
d D 1.14 00/07/23 10:03:07 nitehawk 15 14
c Inline next and prev
cC
cHlocalhost.1ststep.net
cK39097
cZ-07:00
e
s 00000/00000/00226
d D 1.13 00/03/07 11:48:12 nitehawk 14 13
c Turn on SCCS flag
cC
cK06855
cX0xa1
e
s 00006/00005/00220
d D 1.12 00/02/24 19:04:51 nitehawk 13 12
c Convert memory calls to use wrapper functions
cC
cK37371
e
s 00000/00000/00225
d D 1.11 00/02/12 10:05:04 nitehawk 12 11
c Rename: lib/llist.c -> lib/koala/llist.c
cC
cK31900
cPlib/koala/llist.c
e
s 00000/00000/00225
d D 1.10 00/02/07 23:56:37 nitehawk 11 10
c Rename: src/llist.c -> lib/llist.c
cC
cK16821
cPlib/llist.c
e
s 00009/00009/00216
d D 1.9 00/01/30 13:32:19 nitehawk 10 9
c Updated to use new list data union
cC
cK30179
e
s 00015/00006/00210
d D 1.8 00/01/29 13:09:51 nitehawk 9 8
c Fix bugs in linked list code
cC
cK22389
e
s 00005/00000/00211
d D 1.7 00/01/12 23:00:09 nitehawk 8 7
c Added debug message for list creation
c listnextnode returns null if the target node is the head
c listaddnode now correct sets head to point to top of list
cC
cK11845
e
s 00002/00002/00209
d D 1.6 00/01/11 12:27:32 nitehawk 7 6
c Converted RCS tags to SCCS tags
cC
cK03298
e
s 00162/00128/00049
d D 1.5 00/01/09 17:59:46 nitehawk 6 5
c Replace previous linked list code with old linked list code from completemud
cC
cK09445
e
s 00009/00000/00168
d D 1.4 00/01/09 15:47:45 nitehawk 5 4
c listfreenode added.
cK07361
e
s 00053/00003/00115
d D 1.3 00/01/04 16:08:55 nitehawk 4 3
c Fixes to listremovenode - Should be complete and working
cK62904
e
s 00100/00000/00018
d D 1.2 00/01/02 20:27:45 nitehawk 3 2
c Addedd listremovenode function - missing remove headnode
c functionality at the moment
cK42646
e
s 00018/00000/00000
d D 1.1 00/01/02 16:06:09 nitehawk 2 1
cF1
cK32920
cO-rw-rw-rw-
e
s 00000/00000/00000
d D 1.0 00/01/02 16:06:09 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/llist.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK27303
cPsrc/llist.c
cRb820bbb59e4ffb96
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 7
/* $Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $ */
E 7
I 7
/* %Z% %M% %I% %Z% */
E 7
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
I 6
*
*	Doubly, Circly linked list driver
E 6
\***************************************************************/

D 7
#define _KOALAMUD_LLIST_C "$Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $"
E 7
I 7
#define _KOALAMUD_LLIST_C "%Z% %K% %Z%"
E 7

#include "autoconf.h"

#include "version.h"
#include "llist.h"
#include "log.h"
I 13
#include "memory.h"
E 13

I 3
D 4
/*
E 4
I 4
D 6
/* Usage:
E 6
I 6
/* listcreate
 * 	Create the head pointer for the linked list and point the data
 * 	appropriatly.
 *
 * 	Return:
 * 		Pointer to the linked list or NULL on failure.
E 6
E 4
 */
I 6
listnodeptr listcreate(void *data)
{
	listnodeptr list;

	/* Allocate memory for the list pointer */
D 13
	if ((list = malloc(sizeof(listnode))) == NULL)
E 13
I 13
	if ((list = kmalloc(sizeof(listnode), ALLOC_LLIST)) == NULL)
E 13
	{
D 17
		logerr("Unable to allocate memory for linked list.");
E 17
I 17
		logmsg(LOGCRIT, "Unable to allocate memory for linked list.");
E 17
		return NULL;
	}
	
	/* Set the pointers to point where things are. */
D 10
	list->data = data;
E 10
I 10
	list->data.generic = data;
E 10
	list->next = list;
	list->prev = list;
	list->head = list;
	
I 8
D 16
	logdbg("New linked list created");

E 16
E 8
	/* Return a pointer to the new list. */
	return list;
}
E 6
E 3

I 3
D 6
/* listremovenode -
 *		Use data->lists to find the list.  List pointer should be either to
 *	the head node or node containing data.  This function only removes the
 *	data from the specified list.  If data is the last node in the list, set
 *	the data pointer to null and leave the head node intact.  
E 6
I 6
/* listaddnode
 * 	Add a node to the linked list without sorting.
E 6
 *
D 6
 *  Removing the head node of a list is more time consuming then removing other
 *  nodes.  This is because the address of the head node must be preserved and
 *  in order to do so, one of the other nodes must have its data moved into it.
 *  This requires searching the datas member lists and locating the list.
E 6
I 6
 * 	Return 0 on success and non-zero on failure.
E 6
 */
D 6
void listremovenode(listnodeptr list, listdataptr data)
E 6
I 6
int listaddnode(listnodeptr list, void *data)
E 6
{
D 6
	listnodeptr listhead, datanode, listsptr;
I 4
	listnodeptr node;
E 6
I 6
	listnodeptr newnode;
E 6

E 4
D 6
	if (list->data == data)
E 6
I 6
	/* Validate the list pointer */
	if ( ! list)
E 6
	{
D 6
		/* list pointer is node containing data */
		datanode = list;
		listsptr = data->lists;
		while(listsptr && (listsptr->data != (listdataptr)list))
		{
			listsptr = listsptr->next;
		}
		if (!listsptr)
		{
			logerr("Corrupt linked list, bailing out");
			return;
		}
		listhead = list->head;
E 6
I 6
D 17
		logerr("llist_addn caught invalid pointer");
E 17
I 17
		logmsg(LOGERR, "llist_addn caught invalid pointer");
E 17
		return 1;
E 6
	}
D 6
	else if (list->head == list)
	{
		/* List pointer is head node */
		/* We have to find two things here, the datanode and the listsptr */
		listhead = list;
E 6

D 6
		listsptr = data->lists;
		while (listsptr && (((listnodeptr)listsptr->data)->head != list))
		{
			listsptr = listsptr->next;
		}
		if (!listsptr)
		{
			logerr("Corrupt linked list, bailing out");
			return;
		}
		datanode = (listnodeptr)listsptr->data;
	}
	else
E 6
I 6
	/* If the list is 'empty', simply use the head node for the new data */
D 10
	if (list->data == NULL)
E 10
I 10
	if (list->data.generic == NULL)
E 10
E 6
	{
D 6
		/* List pointer is not data node or head node, abort */
		logerr("Trying to remove list node with invalid list pointer");
		return;
E 6
I 6
D 10
			list->data = data;
E 10
I 10
			list->data.generic = data;
E 10
			return 0;
E 6
	}

D 6
	/* At this point, we know all the information we need to remove the node
	 */
	if (datanode == listhead)
E 6
I 6
	/* Allocate memory for the node */
D 13
	if ((newnode = malloc(sizeof(listnode))) == NULL)
E 13
I 13
	if ((newnode = kmalloc(sizeof(listnode), ALLOC_LLIST)) == NULL)
E 13
E 6
	{
D 6
		/* This node is at the head of the list, special care to be taken */
E 6
I 6
D 17
		logerr("Unable to allocate memory for new llist node.");
E 17
I 17
		logmsg(LOGCRIT, "Unable to allocate memory for new llist node.");
E 17
		return 1;
	}
E 6
D 4
		
E 4
I 4

D 6
		/* Check to see if there is any other nodes in the list */
		if (!datanode->prev)
		{
			/* Easy case: just set the data pointer to null */
			datanode->data = NULL;
		}
		else
		{
			/* At least one more node in the list, remove it */
			/* Move the new node into position */
			datanode->data = datanode->prev->data;
			node = datanode->data->lists;
			while (node)
			{
				if ((listnodeptr)(node->data) == datanode->prev)
				{
					node->data = (listdataptr)datanode;
				}
				node = node->next;
				if (node == datanode->data->lists)
				{
					node = NULL;
				}
			}
		}
E 6
I 6
	/* Point things in the right direction */
D 9
	newnode->next = list;
	newnode->prev = list->prev;
	list->prev->next = newnode;
	list->prev = newnode;
E 9
I 8
	newnode->head = list;
I 9
	newnode->prev = list;
	newnode->next = list->next;
	list->next->prev = newnode;
	list->next = newnode;
E 9
E 8
	
	/* Hook the data in */
D 10
	newnode->data = data;
E 10
I 10
	newnode->data.generic = data;
E 10
	
	return 0;
}

/* llist_remove
 * 	Remove an entry out of the linked list.  Destroy the llist struct.
 *
 * 	Return 0 on success and non-zero on failure
 *
 * 	Problems:
 * 		Nothing to remove the only node of a list.  What needs to be
 * 		done in this case.
 */
int listremovenode(listnodeptr list, void *data)
{
	listnodeptr tmp= list;
	
	/* Validate the list and data */
	if ((!list) || (!data))
	{
D 17
		logerr("llist_remove caught caught bad list or"
				"data pointer");
E 17
I 17
		logmsg(LOGERR, "llist_remove caught caught bad list or"
				" data pointer");
E 17
		return 1;
E 6
E 4
	}
D 6
	else
E 6
I 6

	/* Is the current node the one with the data? */
D 10
	if (list->data == data)
E 10
I 10
	if (list->data.generic == data)
E 10
E 6
	{
D 6
		/* We just need to free the node and its place in data->lists */
		/* First we will remove the node from the list */
		if (datanode->prev)
		{
			datanode->prev->next = datanode->next;
			datanode->next->prev = datanode->prev;
I 4
			if (datanode->prev == datanode->next)
			{
				/* Now only one node in the list - head node */
				datanode->head->next = datanode->head->prev = NULL;
			}
E 4
			free(datanode);
E 6
I 6
		/* Move the data from the next node and delete the
		 * next node.
		 */
		if ((tmp = list->next))
		{
D 9
			// Move the data.
			list->data = tmp->data;
E 9
I 9
			// If tmp == list, set the data to null because out list is empty
			if (tmp == list)
			{
D 10
				list->data = NULL;
E 10
I 10
				list->data.generic = NULL;
E 10
				return 0;
			}
			else
			{
				// Move the data.
D 10
				list->data = tmp->data;
E 10
I 10
				list->data.generic = tmp->data.generic;
E 10
			}
E 9
			
			// Remove 'tmp' (list->next)
			list->next = tmp->next;
			tmp->next->prev = list;
D 13
			free(tmp);
E 13
I 13
			kmfree(tmp, ALLOC_LLIST);
E 13

			/* Node has been removed */
			return 0;
E 6
		}
		else
		{
D 6
			/* No prev ptr, must be only node in the list */
			datanode->data = NULL;
E 6
I 6
			/* Last Node in list.  How to remove without causing a
			 * destroy?
			 */

D 10
			list->data = NULL;
E 10
I 10
			list->data.generic = NULL;
E 10

			return 0;
E 6
		}
I 4
	}
E 4

I 4
D 6
	/* Remove node in data->lists */
E 6
I 6
	/* Start off one position offset */
	tmp = list->next;

	/* Loop through the list to find the data */
	while (tmp != list)
E 6
	{
E 4
D 6
		/* Now remove the pointer in data->lists */
		if (listsptr->prev)
		{
			listsptr->prev->next = listsptr->next;
			listsptr->next->prev = listsptr->prev;
I 4
			if (listsptr->prev == listsptr->next)
			{
				/* Now only one node in the list - head node */
				listsptr->head->next = listsptr->head->prev = NULL;
			}
E 4
			if (data->lists == listsptr)
			{
				data->lists = listsptr->prev;
I 4
				/* Rebuild the head pointers */
				node = data->lists;
				while(node)
				{
					node->head = data->lists;
					node = node->next;
					if (node == data->lists)
					{
						node = NULL;
					}
				}
E 4
			}
			free(listsptr);
		}
		else
E 6
I 6
		/* We found the node. */
D 10
		if (data == tmp->data)
E 10
I 10
		if (data == tmp->data.generic)
E 10
E 6
		{
D 6
			/* removing node from last list */
			free(data->lists);
			data->lists = NULL;
E 6
I 6
			/* Remove the node from the linkage */
			tmp->prev->next = tmp->next;
			tmp->next->prev = tmp->prev;

			/* Free the memory for the node */
D 13
			free(tmp);
E 13
I 13
			kmfree(tmp, ALLOC_LLIST);
E 13

			/* return that we found the node */
			return 0;
E 6
		}
I 6
		tmp = tmp->next;
E 6
D 4

E 4
	}
I 6

	/* We didn't find the node */
	return 1;
E 6
}
I 5

D 6
void listfreenode(listdataptr data)
E 6
I 6
/* listnextnode
 * 	Return the next node in the linked list.
 * 	Returns NULL if there is no next node.
 */
D 15
listnodeptr listnextnode(listnodeptr list)
E 15
I 15
KPRODINLINE listnodeptr listnextnode(listnodeptr list)
E 15
{
I 8
	if (list->next == list->head)
		return NULL;
E 8
	return ((list) ? (list->next) : (NULL));	
}

/* listprevnode
 * 	Return the previous node in the linked list.
 */
D 15
listnodeptr listprevnode(listnodeptr list)
E 15
I 15
KPRODINLINE listnodeptr listprevnode(listnodeptr list)
E 15
{
	return ((list) ? (list->prev) : (NULL));	
}

/* listdestroy
 * 	Cleanup memory allocated by the linked list functions.
 *
 * 	ASSUMES:
 * 		All data items are either already cleaned up or otherwise
 * 		tracked.  No cleanup is done for the data.
 */
void listdestroy(listnodeptr list)
E 6
{
D 6
	while(data->lists)
E 6
I 6
	listnodeptr tmp = list;
	listnodeptr nxt = tmp->next;
	
	/* Validate the list */
	if (! list)
	{
D 17
		logerr("listdestroy caught invalid list pointer");
E 17
I 17
		logmsg(LOGERR, "listdestroy caught invalid list pointer");
E 17
		return;
	}

	/* Loop through the list and free all the center nodes */
	while (nxt != list)
E 6
	{
D 6
		listremovenode(data->lists, data);
E 6
I 6
		nxt = tmp->next;
D 13
		free(tmp);
E 13
I 13
		kmfree(tmp, ALLOC_LLIST);
E 13
		tmp = nxt;
E 6
	}
D 6
	free(data);
E 6
}
E 5
E 3
E 2
I 1
E 1
