/***************************************************************************
                          knutnewupsdlg.h  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTNEWUPSDLG_H
#define KNUTNEWUPSDLG_H

#include "knutupsdata.h"
#include "knutvardata.h"

#include <kdialogbase.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kpushbutton.h>

class QLabel;
class QGroupBox;
class QButtonGroup;
class QCheckBox;


/**
 * This class is dialog for makeing or correting informations about UPS.
 * It can set address, port and seletcts values its values will be found,
 * Tato trida je dialog pro vytvoreni nebo opravu informaci a UPS.
 * Umoznuje nastavit adresu, port, a vybrat promennou jejiz hodnota se bude zjistovat.
 * @author Daniel Prynych
 * @short Panel for setting parameters of UPS 
 *
 * @version 0.4
 */
class KNutNewUpsDlg : public KDialogBase
{
    Q_OBJECT
public:
/**
 * Constructor - makes configure dialog.
 * Konstruktor - vytvori konfiguracni dialog.
 *
 * @param add Urcuje zda budeme data opravovat nebo pridavat.
 * @param settingData pointer on structure, which includes values which is setted in dialog.
 * @param upsdata pointer on instance of class KNutUpsData.
 * @param upsdata pointer on instance of class KNutVardata
 * @param add Urcuje zda budeme data opravovat nebo pridavat.
 * @param settingData Je odkaz na strukturu ktera obsahuje hodnoty nastavovane v dialogu.
 * @param upsdata Je odkaz na na instanci tridy KNutUpsData.
 * @param upsdata Je odkaz na na instanci tridy KNutVarData.
 *
 * @since  0.6
 **/
  KNutNewUpsDlg (KNutUpsData* const upsData, KNutVarData* const analogData, const bool add = TRUE, QWidget* parent = 0, const char* name = 0, const bool modal = TRUE);

/**
 * @since  0.3
 **/
 ~KNutNewUpsDlg();

/**
 * Reads data from items of form.
 * Precte data z polozek formulare.
 *
 * @param upsInfo Struktura of UpsInfo - contains all items which is included in form.
 * @param upsInfo Struktura UpsInfo - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.2
 **/
 void getData (upsRecord& upsInfo );

/**
 * Puts date into intems of form
 * Vlozi data do polozek formulare.
 *
 * @param upsInfo Struktura of UpsInfo - contains all items which is included in form.
 * @param upsInfo Struktura UpsInfo - obsahuje vsechny polozky ktere jsou ve formulari.
 *
 * @since  0.3
 **/
  void putData (const upsRecord upsInfo );

/********************* PRIVATE **************************/

  private slots:

/**
 * Is activated when button ok is pressed.
 * Provede se pri stisknuti tlacitka ok.
 *
 * @since  0.1
 **/
  virtual void slotOk();


private:
  bool addMember;   // true pokud se pridava polozka, false edit
  KNutUpsData* m_myUpsData; // Ups data object

  KLineEdit* m_lineEdit1;
  KLineEdit* m_lineEdit2;
  KLineEdit* m_lineEdit3;
  KLineEdit* m_lineEdit4;
  KLineEdit* m_lineEdit5;
  KLineEdit* m_lineEdit6;
  KLineEdit* m_lineEdit7;

  KComboBox* m_comboBox1;
  KComboBox* m_comboBox2;
  KComboBox* m_comboBox3;
  KComboBox* m_comboBox4;
  KComboBox* m_comboBox5;
  KComboBox* m_comboBox6;
  KComboBox* m_comboBox7;
  KComboBox* m_comboBox8;
  KComboBox* m_comboBox9;
  KComboBox* m_comboBox10;

  QCheckBox* m_savePassword;
  
};

#endif
