<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-pgsql.php 434 2007-05-25 20:57:44Z lordlamer $
 */

$KNOWLEDGEROOTDB = 'PGSQL';

/**
 * Class for Connect to Postgresql
 */
class db {
	var $CLASS = array();
	var $connection = "";
	var $dbtype = "pgsql";
	var $dbname = "postgresql";
	var $lastquery = "";
	var $querys = 0;
	var $query_cache = array();

	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	/**
	 * Make a Connect to the postgresql Server
	 *
	 * @param string $host
	 * @param string $user
	 * @param string $pass
	 * @param string $db
	 * @param string $schema optional
	 * @param string $enconding optional
	 * @return mixed return connection resource
	 */
	function connect($host,$user,$pass,$db,$schema="",$encoding="") {
		if(isset($this->CLASS['vars']['db']['pconnect']) && $this->CLASS['vars']['db']['pconnect'] == 1) {
			$this->connection = pg_pconnect("host=$host dbname=$db user=$user password=$pass");
		} else {
			$this->connection = pg_connect("host=$host dbname=$db user=$user password=$pass");
		}

		if(!$this->connection) {
			$this->CLASS['error']->log("Cannnot connect to host!",1,"class-pgsql.php::connect");
			exit();
		}

		if(!$this->schema($schema)) {
			$this->CLASS['error']->log("Could not set schema!",1,"class-pgsql.php::connect");
			exit();
		}

		if($this->set_client_encoding($encoding) == -1) {
			$this->CLASS['error']->log("Could not set client encoding!",1,"class-pgsql.php::connect");
			exit();
		}
		
		return $this->connection;
	}

	/**
	 * Close postgresql connection
	 * @return bool
	 */
	function close() {
		return pg_close($this->connection);
	}

	/**
	 * Set schema that should we use for the session
	 * @param string $schema
	 * @return resource
	 */
	function schema($schema = "") {
		if($schema != "") {
			$res = $this->query("SET search_path TO ".$schema);
			return $res;
		}

		return true;
	}

	/**
	 * Set client encoding
	 * @param string $encoding
	 * @return int 0 on success or -1 on error
	 */
	function set_client_encoding($encoding = "") {
		if($encoding != "") {
			return pg_set_client_encoding($this->connection, $encoding);
		}

		return 0;
	}

	/**
	 * Will make a query with the postgresql server
	 * @param string $query
	 * @return mixed return query result
	 */
	function query($query) {
		$this->lastquery = $query;
		$this->query_cache[] = $query;
		$this->querys += 1;

		$res = pg_query($this->connection, $query);

		// if error in query
		if($res === false) {
			$this->CLASS['error']->log("ERROR IN QUERY: \"$query\"",1,pg_last_error($this->connection));
		}

		return $res;
	}

	/**
	 * Will count the rows of a resultset
	 * @param mixed $result
	 * @return int
	 */
	function num_rows($result) {
		return pg_num_rows($result);
	}

	/**
	 * Fetch a Result as Object
	 * @param mixed $result
	 * @return object
	 */
	function fetch_object($result) {
		return pg_fetch_object($result);
	}

	/**
	 * Return Result as Array
	 * @param mixed $result
	 * @return array
	 */
	function fetch_row($result) {
		return pg_fetch_row($result);
	}

	/**
	 * Return Result as hash array
	 * @param mixed result
	 * @return array
	 */
	function fetch_assoc($result) {
		return pg_fetch_assoc($result);
	}

	/**
	 * Return affected rows of a result
	 * @param mixed $result
	 * @return int
	 */
	function affected_rows($result) {
		return pg_affected_rows($this->connection, $result);
	}

	/**
	 * Returns the text of the error message from previous PostgreSQL operation
	 * @return string
	 */
	function error() {
		return pg_last_error($this->connection);
	}

	/**
	 *
	 */
	function lo_open($oid,$mode) {
		return pg_lo_open($this->connection,$oid,$mode);
	}

	/**
	 *
	 */
	function lo_close($handle) {
		return pg_lo_close($handle);
	}

	/**
	 *
	 */
	function lo_read_all($handle) {
		return pg_lo_read_all($handle);
	}

	/**
	 *
	 */
	function lo_create() {
		return pg_lo_create($this->connection);
	}

	/**
	 *
	 */
	function lo_write($handle,$buffer) {
		return pg_lo_write($handle,$buffer);
	}

	/**
	 *
	 */
	function lo_unlink($oid) {
		return pg_lo_unlink($this->connection,$oid);
	}

	/**
	 * Return the last inserted id from a query
	 * @param string $name not required
	 * @return int
	 */
	function last_id($name) {
		$res = $this->query("select last_value FROM $name");
		$row = $this->fetch_assoc($res);

		return $row['last_value'];
	}

	/**
	 * Quote a String with Postgresql Quotes
	 * @param string $name
	 * @return string
	 */
	function quoteIdentifier($string) {
		return "\"" . $string . "\"";
	}

	/**
	 * create database insert with array
	 *
	 * @param string $table
	 * @param array $values
	 * @return mixed will return the result from the query
	 */
	function db_insert($table, $values) {
		if($table != "" && is_array($values)) {
			$sql = "INSERT INTO \"" . $table . "\" ";

			$coloum = "(";
			$coloumval = "(";

			foreach($values as $key => $value) {
				if(isset($values[$key]['value'])) {
					$coloum .= "\"" . $key . "\", ";
					
					if(isset($values[$key]['type'])) {
						switch($values[$key]['type']) {
						case "integer":
						case "INTEGER":
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf($values[$key]['format'].", ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("%d, ",$values[$key]['value']);
							}
							break;
						case "float":
						case "FLOAT":
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf($values[$key]['format'].", ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("%f, ",$values[$key]['value']);
							}
							break;
						default:
							if(isset($values[$key]['format'])) {
								$coloumval .= sprintf("'".$values[$key]['format']."', ",$values[$key]['value']);
							} else {
								$coloumval .= sprintf("'%s', ",$values[$key]['value']);
							}
						}
					} else {
						$coloumval .= sprintf("'%s', ",$values[$key]['value']);
					}
				} elseif(isset($values[$key]) && !is_array($values[$key]) && $values[$key] != "") {
					$coloum .= "\"" . $key . "\", ";
					$coloumval .= sprintf("'%s', ",$values[$key]);
				}
			}

			// remove last comma
			$coloum = substr($coloum,0,strlen($coloum)-2);
			$coloumval = substr($coloumval,0,strlen($coloumval)-2);

			$coloum .= ")";
			$coloumval .= ")";

			$sql .= $coloum . " VALUES " . $coloumval;

			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $values are not a array',2,'class-pgsql.php::db_insert');
			return false;
		}
	}

	/**
	 * create database update with array
	 *
	 * @param string $table
	 * @param array $values
	 * @param string $where
	 * @return mixed will return the result from the query
	 */
	function db_update($table, $values, $where) {
		if($table != "" && is_array($values)) {
			$sql = "UPDATE \"" . $table . "\" SET ";

			$coloum = "";

			foreach($values as $key => $value) {
				if(isset($values[$key]['value'])) {
					if(isset($values[$key]['type'])) {
						switch($values[$key]['type']) {
						case "integer":
						case "INTEGER":
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("\"%s\"=".$values[$key]['format'].", ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("\"%s\"=%d, ",$key,$values[$key]['value']);
							}
							break;
						case "float":
						case "FLOAT":
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("\"%s\"=".$values[$key]['format'].", ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("\"%s\"=%f, ",$key,$values[$key]['value']);
							}
							break;
						default:
							if(isset($values[$key]['format'])) {
								$coloum .= sprintf("\"%s\"=".$values[$key]['format'].", ",$key,$values[$key]['value']);
							} else {
								$coloum .= sprintf("\"%s\"='%s', ",$key,$values[$key]['value']);
							}
						}
					} else {
						$coloum .= sprintf("\"%s\"='%s'",$key,$values[$key]['value']);
					}
				} elseif(isset($values[$key]) && !is_array($values[$key]) && $values[$key] != "") {
					$coloum .= sprintf("\"%s\"='%s'",$key,$values[$key]);
				}
			}

			// remove last comma
			$coloum = substr($coloum,0,strlen($coloum)-2);

			if($where == "") $where = "1";
			
			$sql .= $coloum . " WHERE " . $where;
			
			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $values are not a array',2,'class-pgsql.php::db_update');
			return false;
		}
	}
	
	/**
	 * create a database delete
	 *
	 * @param string $table
	 * @param string $where
	 * @return mixed will return the result from the query
	 */
	function db_delete($table, $where) {
		if($table != "" && $where != "") {
			$sql = "DELETE FROM \"".$table."\"";
			
			if($where != "") {
				$sql .= " WHERE " . $where;
			}
			
			return $this->query($sql);
		} else {
			$this->CLASS['error']->log('$table not set or $where are not a array',2,'class-pgsql.php::db_delete');
			return false;
		}
	}
}

?>