<?php
/**
 * This Class inherits functions for easier work
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-knowledgeroot.php 350 2007-04-17 22:18:03Z lordlamer $
 */
class knowledgeroot {

	var $CLASS;

	//caching vars
	var $tree_right_cache = array();
	var $content_right_cache = array();
	var $user_right_cache = array();
	var $user_group_cache = array();
	var $group_cache = array();
	var $groups_cache = array();
	var $recursiv_page_perm_cache = array();
	var $inerhitpagerights_cache = array();

	/**
	 * init/start class
	 */
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	/**
	 * FROM Typo3
	 * AddSlash array
	 * This function traverses a multidimentional array and adds slashes to the values.
	 * NOTE that the input array is and argument by reference.!!
	 * Twin-function to stripSlashesOnArray
	 * Usage: 8
	 *
	 * @param	array		Multidimensional input array, (REFERENCE!)
	 * @return	array
	 */
	function addSlashesOnArray(&$theArray)	{
		if(get_magic_quotes_gpc() == 0) {
			if (is_array($theArray))	{
				reset($theArray);
				while(list($Akey,$AVal)=each($theArray))	{
					if (is_array($AVal))	{
						$this->addSlashesOnArray($theArray[$Akey]);
					} else {
						$theArray[$Akey] = addslashes($AVal);
					}
				}
				reset($theArray);
			}
		}
	}

	/**
	 *
	 */
	function rightpanel($userid = "") {
		// check if user have rights to set rights
		if(empty($userid)) {
			// user have no rights to see the panel
			return "";
		} else {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$res = $this->CLASS['db']->query(sprintf("SELECT u.id as uid, g.id as gid, u.name as user,g.name as group, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id=%d",$userid));
			} else {
				$res = $this->CLASS['db']->query(sprintf("SELECT u.id as uid, g.id as gid, u.name as user,g.name as `group`, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id=%d",$userid));
			}

			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				if($row['rightedit'] == 0) {
					return "";
				}
			}
		}

		$users = "\n<select name=\"user\">\n";
		$resusers = $this->CLASS['db']->query("SELECT id, name FROM users ORDER BY name ASC");
		while($rowuser = $this->CLASS['db']->fetch_assoc($resusers)) {
			if($row['uid'] == $rowuser['id']) {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\" selected>" . $rowuser['name'] . "</option>\n";
			} else {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\">" . $rowuser['name'] . "</option>\n";
			}
		}
		$users .= "</select>\n";

		$groups = "\n<select name=\"group\">\n";
		$resgroups = $this->CLASS['db']->query("SELECT id, name FROM groups ORDER BY name ASC");
		while($rowgroup = $this->CLASS['db']->fetch_assoc($resgroups)) {
			if($row['gid'] == $rowgroup['id']) {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\" selected>" . $rowgroup['name'] . "</option>\n";
			} else {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\">" . $rowgroup['name'] . "</option>\n";
			}
		}
		$groups .= "</select>\n";

		if(strlen($row['rights']) == 3) {
			$userright = substr($row['rights'],0,1);
			$groupright = substr($row['rights'],1,1);
			$otherright = substr($row['rights'],2,1);

			// Userrechte Dropdown
			$userrights = $this->rightDropDown("userrights",$userright);


			// Gruppenrechte Dropdown
			$grouprights = $this->rightDropDown("grouprights",$groupright);


			// Otherrechte Dropdown
			$otherrights = $this->rightDropDown("otherrights",$otherright);
		}

		$out = "";
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
			</table>
			';
		$out .= "</div>\n";
		return $out;
	}
	
	/**
	 *
	 */
	function rightpanelsubinherit($userid = "") {
		// check if user have rights to set rights
		if(empty($userid)) {
			// user have no rights to see the panel
			return "";
		} else {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$res = $this->CLASS['db']->query(sprintf("SELECT u.id as uid, g.id as gid, u.name as user,g.name as group, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id=%d",$userid));
			} else {
				$res = $this->CLASS['db']->query(sprintf("SELECT u.id as uid, g.id as gid, u.name as user,g.name as `group`, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id=%d",$userid));
			}

			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				if($row['rightedit'] == 0) {
					return "";
				}
			}
		}

		$users = "\n<select name=\"subinherituser\">\n";
		$resusers = $this->CLASS['db']->query("SELECT id, name FROM users ORDER BY name ASC");
		while($rowuser = $this->CLASS['db']->fetch_assoc($resusers)) {
			if($row['uid'] == $rowuser['id']) {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\" selected>" . $rowuser['name'] . "</option>\n";
			} else {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\">" . $rowuser['name'] . "</option>\n";
			}
		}
		$users .= "</select>\n";

		$groups = "\n<select name=\"subinheritgroup\">\n";
		$resgroups = $this->CLASS['db']->query("SELECT id, name FROM groups ORDER BY name ASC");
		while($rowgroup = $this->CLASS['db']->fetch_assoc($resgroups)) {
			if($row['gid'] == $rowgroup['id']) {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\" selected>" . $rowgroup['name'] . "</option>\n";
			} else {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\">" . $rowgroup['name'] . "</option>\n";
			}
		}
		$groups .= "</select>\n";

		if(strlen($row['rights']) == 3) {
			$userright = substr($row['rights'],0,1);
			$groupright = substr($row['rights'],1,1);
			$otherright = substr($row['rights'],2,1);

			// Userrechte Dropdown
			$userrights = $this->rightDropDown("subinherituserrights",$userright);


			// Gruppenrechte Dropdown
			$grouprights = $this->rightDropDown("subinheritgrouprights",$groupright);


			// Otherrechte Dropdown
			$otherrights = $this->rightDropDown("subinheritotherrights",$otherright);
		}

		$out = "";
		
		$out .= "<input type=\"checkbox\" name=\"subinheritrights\" value=\"1\" />".$this->CLASS['language']->get['rightpanel']['enablesubinheritrights']."<br />\n";
		$out .= "<input type=\"checkbox\" name=\"subinheritrightseditable\" value=\"1\" />".$this->CLASS['language']->get['rightpanel']['enablesubinheritrightsenabled']."<br />\n";
		$out .= "<input type=\"checkbox\" name=\"subinheritrightsdisable\" value=\"1\" />".$this->CLASS['language']->get['rightpanel']['disablesubinheritrights']."<br />\n";
		
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
			</table>
			';
		$out .= "</div>\n";
		return $out;
	}

	/**
	 * return panel with dropdowns to set rights
	 */
	function editRightPanel($userid,$groupid,$rights,$recursiv = 0) {
		//if(empty($userid)) {
		if($userid == "") {
			// you have no rights
			return "";
		}

		$res = $this->CLASS['db']->query(sprintf("SELECT rightedit FROM users WHERE id=%d",$userid));
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
		}



		if($_SESSION['rightedit'] != 1 && $_SESSION['admin'] == 0) {
			//you have no rights
			return "";
		}

		//user
		$res = $this->CLASS['db']->query("SELECT id,name FROM users ORDER BY name ASC");

		$users = "\n<select name=\"user\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $userid) {
				$users .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$users .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$users .= "</select>\n";

		//group
		$res = $this->CLASS['db']->query("SELECT id,name FROM groups ORDER BY name ASC");

		$groups = "\n<select name=\"group\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $groupid) {
				$groups .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$groups .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$groups .= "</select>\n";

		//userrights
		$userrights = $this->rightDropDown("userrights",substr($rights,0,1));
		//grouprights
		$grouprights = $this->rightDropDown("grouprights",substr($rights,1,1));
		//otherrights
		$otherrights = $this->rightDropDown("otherrights",substr($rights,2,1));

		$recursivhtml = '';
		if($recursiv == 1) {
			$recursivhtml = "<tr><td colspan=\"4\">".$this->CLASS['language']->get['rightpanel']['recursiv']."?&nbsp;\n";
			$recursivhtml .= "<select name=\"recursiv\">\n";
			$recursivhtml .= "\t<option value=\"\">".$this->CLASS['language']->get['no']."</option>\n";
			$recursivhtml .= "\t<option value=\"1\">".$this->CLASS['language']->get['yes']."</option>\n";
			$recursivhtml .= "</select>\n";
			$recursivhtml .= "</td></tr>\n";
		}

		$out = "";
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
				'.$recursivhtml.'
			</table>
			';
		$out .= "</div>\n";

		return $out;
	}
	
	/**
	 * return panel with dropdowns to set rights
	 */
	function editRightPanelSubInherit($subinheritrights,$subinheritsrightsenable,$subinheritsrightsdisable,$userid,$groupid,$subuserrights,$subgrouprights,$subotherrights) {
		//if(empty($userid)) {
		if((isset($_SESSION['admin']) && $_SESSION['admin'] != 1) || $userid == "") {
			// you have no rights
			return "";
		}

		$res = $this->CLASS['db']->query(sprintf("SELECT rightedit FROM users WHERE id=%d",$userid));
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
		}



		if($_SESSION['rightedit'] != 1 && $_SESSION['admin'] == 0) {
			//you have no rights
			return "";
		}

		//user
		$res = $this->CLASS['db']->query("SELECT id,name FROM users ORDER BY name ASC");

		$users = "\n<select name=\"subinherituser\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $userid) {
				$users .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$users .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$users .= "</select>\n";

		//group
		$res = $this->CLASS['db']->query("SELECT id,name FROM groups ORDER BY name ASC");

		$groups = "\n<select name=\"subinheritgroup\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $groupid) {
				$groups .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$groups .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$groups .= "</select>\n";

		//userrights
		$userrights = $this->rightDropDown("subinherituserrights",$subuserrights);
		//grouprights
		$grouprights = $this->rightDropDown("subinheritgrouprights",$subgrouprights);
		//otherrights
		$otherrights = $this->rightDropDown("subinheritotherrights",$subotherrights);

		if($subinheritrights == 1) $subinheritscheck = "checked=\"checked\" ";
		else $subinheritscheck = "";
		
		if($subinheritsrightsenable == 1) $subinheritsenablecheck = "checked=\"checked\" ";
		else $subinheritsenablecheck = "";
		
		if($subinheritsrightsdisable == 1) $subinheritsdisablecheck = "checked=\"checked\" ";
		else $subinheritsdisablecheck = "";
		
		$out = "";
		
		$out .= "<input type=\"checkbox\" name=\"subinheritrights\" value=\"1\" ".$subinheritscheck."/>".$this->CLASS['language']->get['rightpanel']['enablesubinheritrights']."<br />\n";
		$out .= "<input type=\"checkbox\" name=\"subinheritrightseditable\" value=\"1\" ".$subinheritsenablecheck."/>".$this->CLASS['language']->get['rightpanel']['enablesubinheritrightsenabled']."<br />\n";
		$out .= "<input type=\"checkbox\" name=\"subinheritrightsdisable\" value=\"1\" ".$subinheritsdisablecheck."/>".$this->CLASS['language']->get['rightpanel']['disablesubinheritrights']."<br />\n";
		
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
			</table>
			';
		$out .= "</div>\n";

		return $out;
	}

	/**
	 * return rights on a page by userid
	 */
	function getPageRights($pageid, $userid) {
		if(!isset($pageid) || !isset($userid)) {
			return 0;
		}

		// get userrights
		if(!isset($this->user_cache_rights[$userid])) {
			$res = $this->CLASS['db']->query(sprintf("SELECT * FROM users WHERE id=%d",$userid));
			$anz = $this->CLASS['db']->num_rows($res);

			// check if user exists, if not - no rights
			if($anz == 0 && $userid != 0) {
				return 0;
			}

			// userrow
			$rowuser = $this->CLASS['db']->fetch_assoc($res);
			// set cache
			$this->user_cache_rights[$userid] = $rowuser;
		} else {
			// get from cache
			$rowuser = $this->user_cache_rights[$userid];
		}

		// check if user is admin, if yes then give full rights
		if($rowuser['admin'] == 1) {
			return 2;
		}

		// get pagerights
		if(!isset($this->tree_cache_rights[$pageid])) {
			$res = $this->CLASS['db']->query(sprintf("SELECT * FROM tree WHERE id=%d",$pageid));
			$anz = $this->CLASS['db']->num_rows($res);

			// check if page exists, if not - no rights
			if($anz == 0) {
				return 0;
			}

			// pagerow
			$rowpage = $this->CLASS['db']->fetch_assoc($res);
			// set cache
			$this->tree_cache_rights[$pageid] = $rowpage;
		} else {
			// get from cache
			$rowpage = $this->tree_cache_rights[$pageid];
		}

		if($rowpage['owner'] == $rowuser['id']) {
			return $rowpage['userrights'];
		}

		if($rowpage['group'] == $rowuser['defaultgroup']) {
			return $rowpage['grouprights'];
		}

		// check for caching
		if(!isset($this->user_group_cache[$userid])) {
			$this->user_group_cache[$userid] = array();

			$found = 0;
			
			$res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$userid));
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				if($row['groupid'] == $rowpage['group']) {
					$found = 1;
				}

				// set cache
				$this->user_group_cache[$userid][] = $row;
			}

			if($found == 1) return $rowpage['grouprights'];
		} else {
			if(is_array($this->user_group_cache[$userid])) {
				// get from cache
				foreach($this->user_group_cache[$userid] as $key => $value) {
					if($this->user_group_cache[$userid][$key]['groupid'] == $rowpage['group']) {
						return $rowpage['grouprights'];
					}
				}
			}
		}

		return $rowpage['otherrights'];
	}

	/**
	 * return rights on a content by userid
	 */
	function getContentRights($contentid, $userid) {
		if(!isset($contentid) || !isset($userid)) {
			return 0;
		}

		// get userrights
		if(!isset($this->user_cache_rights[$userid])) {
			$res = $this->CLASS['db']->query(sprintf("SELECT * FROM users WHERE id=%d",$userid));
			$anz = $this->CLASS['db']->num_rows($res);

			// check if user exists, if not - no rights
			if($anz == 0 && $userid != 0) {
				return 0;
			}

			// userrow
			$rowuser = $this->CLASS['db']->fetch_assoc($res);
			// set cache
			$this->user_cache_rights[$userid] = $rowuser;
		} else {
			// get from cache
			$rowuser = $this->user_cache_rights[$userid];
		}

		// check if user is admin, if yes then give full rights
		if($rowuser['admin'] == 1) {
			return 2;
		}

		// get contentrights
		if(!isset($this->content_cache_rights[$contentid])) {
			$res = $this->CLASS['db']->query(sprintf("SELECT * FROM content WHERE id=%d",$contentid));
			$anz = $this->CLASS['db']->num_rows($res);

			// check if content exists, if not - no rights
			if($anz == 0) {
				return 0;
			}

			// pagerow
			$rowcontent = $this->CLASS['db']->fetch_assoc($res);
			// set cache
			$this->content_cache_rights[$contentid] = $rowcontent;
		} else {
			// get from cache
			$rowcontent = $this->content_cache_rights[$contentid];
		}

		if($rowcontent['owner'] == $rowuser['id']) {
			return $rowcontent['userrights'];
		}

		if($rowcontent['group'] == $rowuser['defaultgroup']) {
			return $rowcontent['grouprights'];
		}

		// check for caching
		if(!isset($this->user_group_cache[$userid])) {
			$this->user_group_cache[$userid] = array();

			$found = 0;
			
			$res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$userid));
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				if($row['groupid'] == $rowcontent['group']) {
					$found = 1;
				}

				// set cache
				$this->user_group_cache[$userid][] = $row;
			}
			
			if($found == 1) return $rowcontent['grouprights'];
		} else {
			if(is_array($this->user_group_cache[$userid])) {
				// get from cache
				foreach($this->user_group_cache[$userid] as $key => $value) {
					if($this->user_group_cache[$userid][$key]['groupid'] == $rowcontent['group']) {
						return $rowcontent['grouprights'];
					}
				}
			}
		}

		return $rowcontent['otherrights'];
	}

	/**
	 * return yes or no
	 */
	function yesno($value) {
		if($value == "1") {
			return $this->CLASS['language']->get['yes'];
		}

		return $this->CLASS['language']->get['no'];
	}

	/**
	 * return a yes/no dropdown
	 */
	function yesnodropdown($name, $default = 0) {
		$defaultno = ($default==0) ? " selected" : "";
		$defaultyes = ($default==1) ? " selected" : "";

		$out = "<select name=\"".$name."\">\n";
		$out .= "\t<option value=\"0\"" . $defaultno . ">".$this->CLASS['language']->get['no']."</option>\n";
		$out .= "\t<option value=\"1\"" . $defaultyes . ">".$this->CLASS['language']->get['yes']."</option>\n";
		$out .= "</select>\n";

		return $out;
	}

	/**
	 * return groupname
	 */
	function getGroup($id) {
		if($id == "") {
			return "";
		}

		if(!isset($this->group_cache[$id])) {
			$res = $this->CLASS['db']->query(sprintf("SELECT name FROM groups WHERE id=%d",$id));
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				$this->group_cache[$id] = $row;
			}
		} else {
			$row = $this->group_cache[$id];
		}

		if(!isset($row['name'])) $row['name'] = "";

		return $row['name'];
	}

	/**
	 * return id of groupname
	 */
	function getGroupID($name) {
		if($name == "") {
			return 0;
		}

		if(!isset($this->groups_cache[$name])) {
			$sql = sprintf("SELECT id FROM groups WHERE name='%s'",$name);
			$res = $this->CLASS['db']->query($sql);
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				$this->groups_cache[$name] = $row;
				return $row['id'];
			}
		} else {
			return $this->groups_cache[$name]['id'];
		}

		return 0;
	}

	/**
	 * returns id of username
	 */
	function getOwner($id) {
		if($id == "") {
			return "";
		}

		$res = $this->CLASS['db']->query(sprintf("SELECT name FROM users WHERE id=%d",$id));
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			return $row['name'];
		}

		return "";
	}

	/**
	 * returns a dropdown of grouprights
	 */
	function groupDropDown($name, $default = "", $multiple = "no", $defaultgroups = array()) {
		if($multiple == "yes") {
			$out = "<select name=\"".$name."\" multiple=\"multiple\" size=\"5\">\"";
		} else {
			$out = "<select name=\"".$name."\">\"";
		}

		$res = $this->CLASS['db']->query("SELECT id,name FROM groups");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($default == $row['id'] || $this->foundIDinArray($row['id'],$defaultgroups)) {
				$out .= "<option value=\"".$row['id']."\" selected>".$row['name']."</option>";
			} else {
				$out .= "<option value=\"".$row['id']."\">".$row['name']."</option>";
			}
		}

		$out .= "</select>\n";

		return $out;
	}

	/**
	 * search for id in array
	 */
	function foundIDinArray($id,$arr) {
		if(!is_array($arr)) {
			$arr = array();
		}

		foreach($arr as $key => $value) {
			if($value == $id) {
				return 1;
			}
		}

		return 0;
	}

	/**
	 * returns a dropdown with rights
	 */
	function rightDropDown($name,$default = "") {
		$out = "<select name=\"".$name."\">\n";

		$selected1 = $default == 2 ? "selected" : "";
		$selected2 = $default == 1 ? "selected" : "";
		$selected3 = $default == 0 ? "selected" : "";

		$out .= "\t<option value=\"2\" ".$selected1.">".$this->CLASS['language']->get['readwrite']."</option>\n";
		$out .= "\t<option value=\"1\" ".$selected2.">".$this->CLASS['language']->get['read']."</option>\n";
		$out .= "\t<option value=\"0\" ".$selected3.">".$this->CLASS['language']->get['norights']."</option>\n";

		$out .= "</select>\n";
		return $out;
	}

	/**
	 *
	 */
	function checkRecursivPerm($pageid, $userid) {
		if($userid == "") {
			$userid = 0;
		}

		if(strlen($pageid) > 0 && strlen($userid) > 0) {
			if(!isset($this->recursiv_page_perm_cache[$pageid])) {
				$res = $this->CLASS['db']->query(sprintf("SELECT id,belongs_to FROM tree WHERE id=%d and deleted=0",$pageid));
				$anz = $this->CLASS['db']->num_rows($res);

				if($anz == 1) {
					$row = $this->CLASS['db']->fetch_assoc($res);
					$this->recursiv_page_perm_cache[$pageid] = $row;
				} else {
					return 0;
				}
			} else {
				$row = $this->recursiv_page_perm_cache[$pageid];
			}

			if($row['belongs_to'] == 0) {
				return $this->getPageRights($row['id'],$userid);
			} else {
				$rights = $this->getPageRights($row['id'],$userid);

				if($rights == 0) {
					return 0;
				} else {
					return $this->checkRecursivPerm($row['belongs_to'],$userid);
				}
			}
		}

		return 0;
	}

	/**
	 * set rights recursiv on pages and content
	 */
	function setRightsRecursiv($pageid,$userid,$user,$group,$rights) {
		$userrights = substr($rights,0,1);
		$grouprights = substr($rights,1,1);
		$otherrights = substr($rights,2,1);

		$res = $this->CLASS['db']->query(sprintf("SELECT id FROM content WHERE belongs_to=%d AND deleted=0",$pageid));
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($this->getContentRights($row['id'],$userid) == 2) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$ressub = $this->CLASS['db']->query(sprintf("UPDATE content SET owner=%d, \"group\"=%d, userrights=%d, grouprights=%d, otherrights=%d WHERE id=%d",$user,$group,$userrights,$grouprights,$otherrights,$row['id']));
				} else {
					$ressub = $this->CLASS['db']->query(sprintf("UPDATE content SET owner=%d, `group`=%d, userrights=%d, grouprights=%d, otherrights=%d WHERE id=%d",$user,$group,$userrights,$grouprights,$otherrights,$row['id']));
				}
			}
		}

		$res = $this->CLASS['db']->query(sprintf("SELECT id FROM tree WHERE belongs_to=%d AND deleted=0",$pageid));
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($this->getPageRights($row['id'],$userid) == 2) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$ressub = $this->CLASS['db']->query(sprintf("UPDATE tree SET owner=%d, \"group\"=%d, userrights=%d, grouprights=%d, otherrights=%d WHERE id=%d",$user,$group,$userrights,$grouprights,$otherrights,$row['id']));
				} else {
					$ressub = $this->CLASS['db']->query(sprintf("UPDATE tree SET owner=%d, `group`=%d, userrights=%d, grouprights=%d, otherrights=%d WHERE id=%d",$user,$group,$userrights,$grouprights,$otherrights,$row['id']));
				}

				$this->setRightsRecursiv($row['id'],$userid,$user,$group,$rights);
			}
		}

		return 1;
	}

	/**
	 * replace values from $arr1 with the values in arr2
	 */
	function replace_array($arr1, $arr2) {
		foreach($arr2 as $key => $value) {
			if(is_array($arr2[$key])) {
				if(isset($arr1[$key])) $arr1[$key] = $this->replace_array($arr1[$key],$arr2[$key]);
				else $arr1[$key] = $this->replace_array("",$arr2[$key]);
			} else {
				$arr1[$key] = $value;
			}
		}

		return $arr1;
	}

	/**
	 * IMPORTET FROM TYPO3
	 * Wrapping a string.
	 * Implements the TypoScript "wrap" property.
	 * Example: $content = "HELLO WORLD" and $wrap = "<b> | </b>", result: "<b>HELLO WORLD</b>"
	 *
	 * @param	string		The content to wrap
	 * @param	string		The wrap value, eg. "<b> | </b>"
	 * @param	string		The char used to split the wrapping value, default is "|"
	 * @return	string		Wrapped input string
	 * @see noTrimWrap()
	 */
	function setWrap($content = "",$wrap = "",$char = "|") {
		if ($wrap)	{
			$wrapArr = explode($char, $wrap);
			return $wrapArr[0].$content.$wrapArr[1];
		} else return $content;
	}

	/**
	 * check for alias and returns a good alias
	 */
	function checkAlias($alias) {
		// replace all chars that are not a-z A-Z 0-9
		$alias = preg_replace("/[^a-zA-Z0-9]*/s","",$alias);

		$res = $this->CLASS['db']->query(sprintf("SELECT count(*) AS anz FROM tree WHERE alias='%s' AND deleted=0",$alias));
		$row = $this->CLASS['db']->fetch_assoc($res);

		$x = 0;

		while($row['anz'] >= 1) {
			$x++;
			$alias_new = $alias . $x;

			$res = $this->CLASS['db']->query(sprintf("SELECT count(*) AS anz FROM tree WHERE alias='%s' AND deleted=0",$alias_new));
			$row = $this->CLASS['db']->fetch_assoc($res);
		}

		if($x == 0) {
			return $alias;
		} else {
			return $alias_new;
		}
	}

	/**
	 * create array from path and set value
	 */
	function createArr(&$arr, $path, $value) {
		$p =& $arr;

		$path_arr = explode(".",$path);
		foreach($path_arr as $key) {
			$key = trim($key);

			if(!isset($p[$key])) {
				$p[$key] = array();
			}

			$p =& $p[$key];
		}

		$p = trim($value);
		unset($p);
	}

	/**
	 * save config value with a path
	 */
	function setConfig($path,$value) {
		$path_arr = explode(".", $path);

		if($path_arr[0] == "db") {
			return "";
		}

		$res = $this->CLASS['db']->query(sprintf("SELECT id FROM settings WHERE name='%s'",$path));
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$res = $this->CLASS['db']->query(sprintf("UPDATE settings SET name='%s', value='%s' WHERE name='%s'",$path,$value,$path));
		} else {
			$res = $this->CLASS['db']->query(sprintf("INSERT INTO settings (name, value) VALUES ('%s', '%s')",$path,$value));
		}
	}

	/**
	 * get configvalue from a path
	 */
	function getConfig($path) {
		$res = $this->CLASS['db']->query(sprintf("SELECT value FROM settings WHERE name='%s'",$path));
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			return $row['value'];
		} else {
			return "";
		}
	}

	/**
	 * save array to config
	 */
	function setConfigArr($arr, $path = "") {
		$path = $path == "" ? "" : $path . ".";

		foreach($arr as $key => $value) {
			// db should not be converted
			if($key == "db" && $path == "") {
				continue;
			}

			if(is_array($arr[$key])) {
				$this->setConfigArr($arr[$key], $path.$key);
			} else {
				$name = $path . $key;
				$this->setConfig($name, $value);
			}
		}
	}

	/**
	 * get config as array with path
	 */
	function getConfigArr($path = "") {
		$CONFIG = array();

		$res = $this->CLASS['db']->query("SELECT * FROM settings");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			$this->createArr($CONFIG, $row['name'], $row['value']);
		}

		if($path == "") {
			return $CONFIG;
		}

		$p =& $CONFIG;
		$path_arr = explode(".", $path);

		foreach($path_arr as $key) {
			$key = trim($key);

			if(!isset($p[$key])) {
				$p[$key] = array();
			}

			$p =& $p[$key];
		}

		return $p;
	}

	/**
	 * delete a config value with a path
	 */
	function delConfig($path, $recursiv = false) {
		if($recursiv == true) {
			$res = $this->CLASS['db']->query(sprintf("DELETE FROM settings WHERE name like '%s%%'",$path));
		} else {
			$res = $this->CLASS['db']->query(sprintf("DELETE FROM settings WHERE name='%s'",$path));
		}
	}

	/**
	 * mark content as opened
	 */
	function openContent($contentid, $userid) {
		$this->clearOpenContent();

		if(strlen($contentid) > 0 && strlen($userid) > 0) {
			$time = time();

			if(sprintf("%d",$userid) == "0") {
				$userid = session_id();
			} else {
				//echo "##";
			}

			$res = $this->CLASS['db']->query(sprintf("SELECT id FROM content_open WHERE contentid=%d AND userid='%s'",$contentid,$userid));
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz != 0) {
				$res = $this->CLASS['db']->query(sprintf("UPDATE content_open SET opened=%d WHERE contentid=%d and userid='%s'",$time,$contentid,$userid));
			} else {
				$res = $this->CLASS['db']->query(sprintf("INSERT INTO content_open (contentid, userid, opened) VALUES (%d, '%s', %d)",$_GET['eid'],$userid,$time));
			}
		}
	}

	/**
	 * close opened contents
	 */
	function closeOpenContent($contentid, $userid) {
		$this->clearOpenContent();

		if(sprintf("%d",$userid) == "0") {
			$userid = session_id();
		}

		if(strlen($contentid) > 0 && strlen($userid) > 0) {
			$res = $this->CLASS['db']->query(sprintf("DELETE FROM content_open WHERE contentid=%d AND userid='%s'",$contentid,$userid));
		}
	}

	/**
	 * clear old opened contents
	 */
	function clearOpenContent() {
		$timeout = 1800;
		$time = time() - $timeout;

		$res = $this->CLASS['db']->query(sprintf("DELETE FROM content_open WHERE opened <= %d",$time));
	}

	/**
	 * show if content is already opened by other user
	 */
	function isOpenContent($contentid, $userid) {
		$this->clearOpenContent();

		if(strlen($contentid) > 0 && strlen($userid) > 0) {
			if(sprintf("%d",$userid) == "0") {
				$userid = session_id();
			}

			$res = $this->CLASS['db']->query(sprintf("SELECT id FROM content_open WHERE contentid=%d AND userid!='%s'",$contentid,$userid));
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz > 0) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	/**
	 * returns an array with rights if the pageid should inherit rights - if not it returns false
	 */
	function getInheritRights($pageid) {
		if($this->isInheritRights($pageid)) {
			// check internal cache that was build by function isInheritRights
			if(isset($this->inerhitpagerights_cache[$pageid]) && is_array($this->inerhitpagerights_cache[$pageid])) {
				$row = $this->inerhitpagerights_cache[$pageid];
				
				if($row['subinheritrights'] == 1) {
					return $row;
				} elseif($row['subinheritrightsdisable'] == 1) {
					return $row;
				} else {
					return $this->getInheritRights($row['belongs_to']);
				}
			}
		}

		return false;
	}
	
	/**
	 * return true or false if the pageid should inherit rights
	 */
	function isInheritRights($pageid) {
		if(isset($this->inerhitpagerights_cache[$pageid]) && is_array($this->inerhitpagerights_cache[$pageid])) {
			$row = $this->inerhitpagerights_cache[$pageid];
			
			if($row['subinheritrights'] == 1) {
				return true;
			} elseif($row['subinheritrightsdisable'] == 1) {
				return false;
			} else {
				if($pageid != 0) {
					return $this->isInheritRights($row['belongs_to']);
				}
			}
		} else {
			$res = $this->CLASS['db']->query(sprintf("SELECT id, belongs_to, subinheritrights, subinheritrightseditable, subinheritrightsdisable, subinheritowner, subinheritgroup, subinherituserrights, subinheritgrouprights, subinheritotherrights FROM tree WHERE id=%d AND deleted=0",$pageid));
			$anz = $this->CLASS['db']->num_rows($res);
			
			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				$this->inerhitpagerights_cache[$pageid]  = $row;
				
				if($row['subinheritrights'] == 1) {
					return true;
				} elseif($row['subinheritrightsdisable'] == 1) {
					return false;
				} else {
					if($pageid != 0) {
						return $this->isInheritRights($row['belongs_to']);
					}
				}
			}
		}
		
		return false;
	}
}

?>
