<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 11.04.2006
 *
 * This Class inerhits functions that show content in knowledgeroot
 ******************************/

class knowledgeroot_content {
	var $CLASS;

	// init/start class
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	// this function show the content
	function show_content() {
		if($_GET['action'] == "newcontent") {
			$this->new_content();
		} elseif($_GET['action'] == "newpage") {
			$this->new_page();
		} elseif($_GET['action'] == "editpage") {
			$this->edit_page();
		} elseif($_GET['eid'] != "") {
			$this->edit_content();
		} elseif ($_POST['submit'] && $_POST['search'] != "") {
			$this->show_search();
		} elseif($_GET['action'] == "login") {
			$this->show_login();
		} elseif($_GET['action'] == "createroot" && $_SESSION['admin']) {
			$this->create_root();
		} elseif(($_GET['action'] == "options" || $_POST['action'] == "options") && !empty($_SESSION['userid'])) {
			$this->show_options();
		} elseif($_GET['action'] == "users" && $_SESSION['admin'] == 1) {
			$this->list_users();
		} elseif($_GET['action'] == "adduser" && $_SESSION['admin'] == 1) {
			$this->add_user();
		} elseif($_GET['action'] == "edituser" && $_SESSION['admin'] == 1) {
			$this->edit_user();
		} elseif($_GET['action'] == "addgroup" && $_SESSION['admin'] == 1) {
			$this->add_group();
		} elseif($_GET['action'] == "editgroup" && $_SESSION['admin'] == 1) {
			$this->edit_group();
		} elseif($_GET['action'] == "error") {
			$this->show_error();
		} else {
			$this->show_tree_content();
		}
	}

	// display main usermenu
	function show_menu() {
		echo "[";
		if($_SESSION['user'] == "guest" || empty($_SESSION['userid'])) {
			echo "<a href=\"index.php?action=login\">".$this->CLASS['language']->get['menu']['login']."</a>";
		} else {
			if($_SESSION['admin'] == 1) {
				echo "<a href=\"index.php?action=createroot\">".$this->CLASS['language']->get['menu']['roots']."</a>]&nbsp;";
				echo "[<a href=\"index.php?action=users\">".$this->CLASS['language']->get['menu']['user']."</a>]&nbsp;";
				echo "[<a href=\"index.php?action=options\">".$this->CLASS['language']->get['menu']['options']."</a>]&nbsp;";
				echo "[<a href=\"index.php?action=logout\">".$this->CLASS['language']->get['menu']['logout']."</a>";
			} else {
				echo "<a class=\"mainnavi\" href=\"index.php?action=options\">".$this->CLASS['language']->get['menu']['options']."</a>]&nbsp;";
				echo "[<a class=\"mainnavi\" href=\"index.php?action=logout\">".$this->CLASS['language']->get['menu']['logout']."</a>";
			}
		}
		echo "]";

		return 0;
	}

	// create form for new content
	function new_content() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
			echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br><br>";
			echo "<form action=\"index.php\" method=\"post\">";
			echo "<input type=\"hidden\" name=\"neditid\" value=\"new\">";
			echo "<input type=\"hidden\" name=\"belongsto\" value=\"".$_SESSION['cid']."\">";
			echo "<input type=\"hidden\" name=\"submit\" value=\"submit\">";
			echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\">";
			echo "<br><br>\n";

			if($this->CLASS['oFCKeditor']->use == 1 && $this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
				$this->CLASS['oFCKeditor']->Value = '';
				$this->CLASS['oFCKeditor']->Create() ;
			} else {
				echo "<textarea name=\"content\" cols=\"".$this->CLASS['vars']['htmleditor']['tinymce']['cols']."\" rows=\"".$this->CLASS['vars']['htmleditor']['tinymce']['rows']."\">\n";
				echo "</textarea>\n";
			}

			echo "<br><br>\n";
			//check rights!!!

			if(!empty($_SESSION['userid'])) {
				echo $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
			}

			echo "<br><br>\n";
			echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\">";
			echo "</form>";
		}
	}

	// this function create form for newpage
	function new_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
			echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br><br>";
			echo "<form action=\"index.php\" method=\"post\">";
			echo "<input type=\"hidden\" name=\"newpage\" value=\"new\">";
			echo "<input type=\"hidden\" name=\"belongsto\" value=\"".$_SESSION['cid']."\">";
			// automatically open the created page
			$auto_open = isset($_SESSION['auto_open']) && $_SESSION['auto_open'] == true ? "checked='checked'" : "";
			echo "<input type=\"text\" name=\"title\" value=\"\">&nbsp;&nbsp;<input type=\"checkbox\" name=\"auto_open\" $auto_open value=\"true\" /><span style='vertical-align:middle'> ".$this->CLASS['language']->get['autoopen'] . "</span>";
			echo "<br /><input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['save']."\">";
			//check rights!!!
			if(!empty($_SESSION['userid'])) {
				echo $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
			}

			echo "</form>";
		}
	}

	// this function create form for edit page
	function edit_page() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
			$res = $this->CLASS['db']->query("SELECT * FROM tree WHERE id='".$_SESSION['cid']."'");
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
			}

			echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br><br>";
			echo "<form action=\"index.php\" method=\"post\">";
			echo "<input type=\"hidden\" name=\"editpage\" value=\"".$_SESSION['cid']."\">";
			echo "<input type=\"text\" name=\"title\" value=\"".$row['title']."\"><br>";
			echo "<input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['rename']."\">";

			//check rights
			if(!empty($_SESSION['userid'])) {
				echo $this->CLASS['knowledgeroot']->editRightPanel($row['owner'],$row['group'],$row['userrights'].$row['grouprights'].$row['otherrights'],1);
			}

			echo "</form>";
		}
	}

	// this function create form for edit content
	function edit_content() {
		if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2 && $this->CLASS['knowledgeroot']->getContentRights($_GET['eid'],$_SESSION['userid']) == 2) {
			echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br><br>";
			echo "<form action=\"index.php\" method=\"post\">";
			echo "<input type=\"hidden\" name=\"editid\" value=\"".$_GET['eid']."\">";
			echo "<input type=\"hidden\" name=\"submit\" value=\"submit\">";
			echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\">";
			echo "<br><br>\n";
			$res = $this->CLASS['db']->query("SELECT * FROM content WHERE id='".$_GET['eid']."' ORDER BY id ASC");

			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				if($this->CLASS['oFCKeditor']->use == 1 && $this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
					$this->CLASS['oFCKeditor']->Value = $row['content'];
					$this->CLASS['oFCKeditor']->Create() ;
				} else {
					echo "<textarea name=\"content\" cols=\"".$this->CLASS['vars']['htmleditor']['tinymce']['cols']."\" rows=\"".$this->CLASS['vars']['htmleditor']['tinymce']['rows']."\">\n";
					echo $row['content'];
					echo "</textarea>\n";
				}

				echo "<br><br>";

				//check rights
				if(!empty($_SESSION['userid'])) {
					echo $this->CLASS['knowledgeroot']->editRightPanel($row['owner'],$row['group'],$row['userrights'].$row['grouprights'].$row['otherrights']);
				}
			}

			echo "<br><br>";
			echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\">";
			echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\">";
			echo "</form>";
		}
	}

	// this function shows search
	function show_search() {
		$searchword = addslashes($_POST['search']);

		if($this->CLASS['vars']['knowledgeroot']['charset'] == "utf8") {
			$charset = "UTF-8";
		} else {
			$charset = $this->CLASS['vars']['knowledgeroot']['charset'];
		}
		
		$searchwordhtml = @htmlentities($searchword,ENT_NOQUOTES,$charset);
		
		echo $this->CLASS['language']->get['searchfor'] . " <b>'" . $searchword . "'</b><br><br>";

		echo "<h3>" . $this->CLASS['language']->get['searchcontent'] . ":</h3>\n";

		$_SESSION['userid'] = $_SESSION['userid'] == "" ? 0 : $_SESSION['userid'];
		$_SESSION['groupid'] = $_SESSION['userid'] == "" ? 0 : $_SESSION['groupid'];

		if($_SESSION['admin'] == 1) {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$sql = "SELECT id,belongs_to,content FROM content WHERE (content ilike '%$searchword%' OR content ilike '%$searchwordhtml%') AND deleted=0";
			} else {
				$sql = "SELECT id,belongs_to,content FROM content WHERE (content like '%$searchword%' OR content like '%$searchwordhtml%') AND deleted=0";
			}
		} else {
			// get groups from user
			$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$_SESSION['userid']."");
			$orclause = "";
			while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$orclause .= "OR (\"group\"=".$rowuser['groupid']."  AND grouprights > 0) ";
				} else {
					$orclause .= "OR (`group`=".$rowuser['groupid']."  AND grouprights > 0) ";
				}
			}
			
			if($this->CLASS['db']->dbtype == "pgsql") {
				$sql = "SELECT id,belongs_to,content FROM content WHERE (content ilike '%$searchword%' OR content ilike '%$searchwordhtml%') AND deleted=0 AND ((otherrights > 0) OR (\"group\"=".$_SESSION['groupid']." AND grouprights > 0) ".$orclause."OR (owner=".$_SESSION['userid']." AND userrights>0))";
			} else {
				$sql = "SELECT id,belongs_to,content FROM content WHERE (content like '%$searchword%' OR content like '%$searchwordhtml%') AND deleted=0 AND ((otherrights > 0) OR (\"group\"=".$_SESSION['groupid']." AND grouprights > 0) ".$orclause."OR (owner=".$_SESSION['userid']." AND userrights>0))";
			}
		}

		$res = $this->CLASS['db']->query($sql);
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz != 0) {
			$x = 0;
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				//echo $row['id'];
				if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['belongs_to'],$_SESSION['userid']) != 0) {
					echo $this->CLASS['path']->getPath($row['belongs_to']) . "&nbsp;/&nbsp;[<a href=\"index.php?id=" . $row['belongs_to'] . "#" . $row['id'] . "\">" . $this->CLASS['language']->get['searchshow'] . "</a>]<br>\n";
					$x++;
				}
			}

			if($x == 0) {
				echo $this->CLASS['language']->get['nothingfound'] . "<br>\n";
			}
		} else {
			echo $this->CLASS['language']->get['nothingfound'];
		}

		echo "<hr>\n";

		echo "<h3>" . $this->CLASS['language']->get['searchmenu'] . ":</h3>\n";

		if($this->CLASS['db']->dbtype == "pgsql") {
			$sql = "SELECT id,belongs_to,title FROM tree WHERE title ilike '%$searchword%'";
		} else {
			$sql = "SELECT id,belongs_to,title FROM tree WHERE title like '%$searchword%'";
		}

		$res = $this->CLASS['db']->query($sql);
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz != 0) {
			$x = 0;
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				//echo $row['id'];
				if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['id'], $_SESSION['userid']) != 0) {
					echo $this->CLASS['path']->getPath($row['id']) . "<br>\n";
					$x++;
				}
			}

			if($x == 0) {
				echo $this->CLASS['language']->get['nothingfound'] . "<br>\n";
			}
		} else {
			echo $this->CLASS['language']->get['nothingfound'] . "<br>\n";
		}

		echo "<hr>\n";

		echo "<h3>" . $this->CLASS['language']->get['searchfiles'] . ":</h3>\n";

		if($this->CLASS['db']->dbtype == "pgsql") {
			$sql = "SELECT f.id as id,t.id as tid,f.filename,f.filesize, to_char(f.date,'DD. Mon YYYY HH24:MI:SS') AS dateform, f.owner AS owner FROM files f, tree t, content c WHERE f.belongs_to = c.id AND c.belongs_to = t.id AND f.deleted=0 AND filename ilike '%$searchword%'";
		} else {
			$sql = "SELECT f.id as id,t.id as tid,f.filename,f.filesize, DATE_FORMAT(f.date,'%d. %M %Y %H:%i:%s') AS dateform, f.owner AS owner FROM files f, tree t, content c WHERE f.belongs_to = c.id AND c.belongs_to = t.id AND f.deleted=0 AND filename like '%$searchword%'";
		}

		$res = $this->CLASS['db']->query($sql);
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz != 0) {
			$x = 0;
			while($row = $this->CLASS['db']->fetch_assoc($res)) {
				// get file information
				$title = "";
				if($row['owner'] == NULL || $row['owner'] == 0 || $row['owner'] == "") {
					$title = $row['dateform'];
				} else {
					$title = $this->CLASS['knowledgeroot']->getOwner($row['owner']) . " - " . $row['dateform'];
				}

				// show file
				if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['tid'], $_SESSION['userid']) != 0) {
					echo $this->CLASS['path']->getPath($row['tid']) . "&nbsp;/\n";
					echo "<a href=\"index.php?download=".$row['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\"> ".$row['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($row['filesize'])."]&nbsp;[".$title."]</font><br>\n";
					$x++;
				}
			}

			if($x == 0) {
				echo $this->CLASS['language']->get['nothingfound'] . "<br>\n";
			}
		} else {
			echo $this->CLASS['language']->get['nothingfound'] . "<br>\n";
		}
	}

	// form for login
	function show_login() {
		echo '
			<div class="loginform">

			<fieldset>
    				<legend><b>'.$this->CLASS['language']->get['loginform']['title'].'</b></legend>

			<form action="index.php" method="post">
			<input type="hidden" name="'.session_name().'" value="'.session_id().'">
			<table class="loginform" border="0" cellspacing="0" cellpadding="0" width="300">
				<tr><td><b style="color:#FFFFFF">Login</b></td></tr>
				<tr><td>'.$this->CLASS['language']->get['loginform']['user'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="text" name="user" value="" size="20"></td></tr>
				<tr><td>'.$this->CLASS['language']->get['loginform']['password'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password" value="" size="20"></td></tr>
				<tr><td colspan="2" align="right" style="padding:2px 2px 2px 2px;"><input class="button" type="submit" name="login" value="'.$this->CLASS['language']->get['loginform']['submit'].'"></td></tr>
			</table>
			</form>

			</fieldset>
			</div>
		';
	}

	// form for create root
	function create_root() {
		// rechte checken -> adminrechte
		echo '
			<h2>'.$this->CLASS['language']->get['rootform']['title'].'</h2>
			<div class="createroot">
			<form action="index.php" method="post">
			<input type="hidden" name="action" value="createroot">
			<input type="hidden" name="'.session_name().'" value="'.session_id().'">

			<fieldset>
    				<legend><b>'.$this->CLASS['language']->get['rootform']['title'].'</b></legend>

			<table border="0" cellspacing="1" cellpadding="1" width="300">
				<tr><td>'.$this->CLASS['language']->get['rootform']['name'].':</td><td style="padding:2px 2px 2px 2px;" colspan="3"><input type="text" name="title" value="" size="20"></td></tr>
				<tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['rootform']['submit'].'"></td></tr>
			</table><p />';

		if(!empty($_SESSION['userid'])) {
			echo $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
		}


		echo '	</fiedliest></form>
			</div>
		';
	}

	// form for options
	function show_options() {
		echo '
			<h2>'.$this->CLASS['language']->get['optionform']['title'].'</h2>
			<fieldset>
    				<legend><b>'.$this->CLASS['language']->get['optionform']['subtitle'].'</b></legend>

			<form action="index.php" method="post">
			<input type="hidden" name="action" value="options">
			<table border="0" cellpadding="0" cellspacing="0" width="300">
				<tr><td>'.$this->CLASS['language']->get['optionform']['newpassword'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password" value=""></td></tr>
				<tr><td>'.$this->CLASS['language']->get['optionform']['newpassword2'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password1" value=""></td></tr>
				<tr><td>'.$this->CLASS['language']->get['optionform']['theme'].':</td><td align="right" style="padding:2px 2px 2px 2px;">'.$this->CLASS['themes']->theme_dropdown($_SESSION['theme']).'</td></tr>
				<tr><td>'.$this->CLASS['language']->get['optionform']['language'].':</td><td align="right" style="padding:2px 2px 2px 2px;">'.$this->CLASS['language']->lang_dropdown("language",$_SESSION['language']).'</td></tr>
				<tr><td align="right" colspan="2" style="padding:2px 2px 2px 2px;"><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['optionform']['submit'].'"></td></tr>
			</table>
			</form>

			</fieldset>
		';
	}

	// list users
	function list_users() {
		// list users
		echo '
			<h2>'.$this->CLASS['language']->get['userform']['usertitle'].'</h2>
			[<a href="index.php?action=adduser">'.$this->CLASS['language']->get['userform']['adduser'].'</a>]<br>
			<table style="border:1px solid #000000;" cellpadding="1" cellspacing="1">
				<tr><td>'.$this->CLASS['language']->get['userform']['username'].'</td><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].'</td><td>'.$this->CLASS['language']->get['userform']['defaultrights'].'</td><td>'.$this->CLASS['language']->get['userform']['admin'].'</td><td>'.$this->CLASS['language']->get['userform']['rightedit'].'</td><td>'.$this->CLASS['language']->get['userform']['enabled'].'</td><td>'.$this->CLASS['language']->get['userform']['action'].'</td></tr>
		';

		$res = $this->CLASS['db']->query("SELECT * FROM users");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			echo "<tr><td>".$row['name']."</td><td>".$this->CLASS['knowledgeroot']->getGroup($row['defaultgroup'])."</td><td>".$row['defaultrights']."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['admin'])."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['rightedit'])."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['enabled'])."</td><td>[<a href=\"index.php?action=edituser&amp;uid=".$row['id']."\">".$this->CLASS['language']->get['userform']['edit']."</a>]&nbsp;[<a href=\"index.php?action=deluser&amp;uid=".$row['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['userform']['deluserask'] . "');\">".$this->CLASS['language']->get['userform']['delete']."</a>]</td></tr>\n";
		}

		echo '
			</table>
		';

		// list groups
		echo '
			<h2>'.$this->CLASS['language']->get['userform']['grouptitle'].'</h2>
			[<a href="index.php?action=addgroup">'.$this->CLASS['language']->get['userform']['addgroup'].'</a>]<br>
			<table style="border:1px solid #000000;" cellpadding="1" cellspacing="1">
				<tr><td>'.$this->CLASS['language']->get['userform']['groupname'].'</td><td>'.$this->CLASS['language']->get['userform']['action'].'</td></tr>
		';

		$res = $this->CLASS['db']->query("SELECT * FROM groups");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			echo "<tr><td>".$row['name']."</td><td>[<a href=\"index.php?action=editgroup&amp;gid=".$row['id']."\">".$this->CLASS['language']->get['userform']['edit']."</a>]&nbsp;[<a href=\"index.php?action=delgroup&amp;gid=".$row['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['userform']['delgroupask'] . "');\">".$this->CLASS['language']->get['userform']['delete']."</a>]</td></tr>\n";
		}

		echo '
			</table>
		';
	}

	// add user
	function add_user() {
		echo '
			<h2>'.$this->CLASS['language']->get['userform']['adduser'].'</h2>

			<form action="index.php" method="post">
			<input type="hidden" name="action" value="adduser">

			<fieldset>
    				<legend><b>'.$this->CLASS['language']->get['userform']['newuser'].'</b></legend>
			<table border="0" cellpadding="1" cellspacing="3">
			<tr><td>'.$this->CLASS['language']->get['userform']['username'].': </td><td><input type="text" name="name" value=""></td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['password'].': </td><td><input type="password" name="password" value=""></td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['theme'].': </td><td>' . $this->CLASS['themes']->theme_dropdown() . '</td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].': </td><td>' . $this->CLASS['knowledgeroot']->groupdropdown("defaultgroup") . '</td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['admin'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("admin") . '</td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['rightedit'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("rightedit") . '</td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['enabled'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("enabled") . '</td></tr>
			<tr><td valign="top">'.$this->CLASS['language']->get['userform']['groups'].': </td><td> ' . $this->CLASS['knowledgeroot']->groupDropDown("groups[]","","yes") . ' </td></tr>
			<tr><td>'.$this->CLASS['language']->get['userform']['defaultrights'].': </td><td></td></tr>
			<tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['user'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("userrights",2).'</td></tr>
			<tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['group'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("grouprights",1).'</td></tr>
			<tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['others'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("otherrights",1).'</td></tr>

			<tr><td></td><td align="left"><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'"></td></tr>
			</table>
			  </fieldset>
			</form>

		';
	}

	// edit user
	function edit_user() {
		$res = $this->CLASS['db']->query("SELECT * FROM users WHERE id=".$_GET['uid']."");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);

			//fetch groups
			$res = $this->CLASS['db']->query("SELECT * FROM user_group WHERE userid=".$row['id']."");
			$x = 0;
			while($rowgroup = $this->CLASS['db']->fetch_assoc($res)) {
				$grouparr[$x] = $rowgroup['groupid'];
				$x++;
			}

			echo '
				<h2>'.$this->CLASS['language']->get['userform']['edituser'].'</h2>

				<form action="index.php" method="post">
				<input type="hidden" name="action" value="edituser">
				<input type="hidden" name="uid" value="'.$row['id'].'">

				<fieldset>
					<legend><b>'.$this->CLASS['language']->get['userform']['edituser'].'</b></legend>

				<table border="0" cellpadding="1" cellspacing="3">
				<tr><td>'.$this->CLASS['language']->get['userform']['username'].': </td><td><input type="text" name="name" value="'.$row['name'].'"></td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['password'].': </td><td><input type="password" name="password" value=""></td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['theme'].': </td><td>' . $this->CLASS['themes']->theme_dropdown($row['theme']) . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].': </td><td>' . $this->CLASS['knowledgeroot']->groupdropdown("defaultgroup",$row['defaultgroup']) . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['admin'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("admin", $row['admin']) . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['rightedit'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("rightedit",$row['rightedit']) . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['enabled'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("enabled",$row['enabled']) . '</td></tr>
				<tr><td valign="top">'.$this->CLASS['language']->get['userform']['groups'].': </td><td>' . $this->CLASS['knowledgeroot']->groupDropDown("groups[]","","yes",$grouparr) . ' </td></tr>
				<tr><td>'.$this->CLASS['language']->get['userform']['defaultrights'].': </td><td></td></tr>
				<tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['user'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("userrights",substr($row['defaultrights'],0,1)).'</td></tr>
				<tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['group'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("grouprights",substr($row['defaultrights'],1,1)).'</td></tr>
				<tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['others'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("otherrights",substr($row['defaultrights'],2,1)).'</td></tr>

				<tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'"></td></tr>

				</table>
				</fieldset>
				</form>
			';
		}
	}

	// add group
	function add_group() {
		echo '
			<h2>'.$this->CLASS['language']->get['userform']['addgroup'].'</h2>
			<fieldset>
				<legend><b>'.$this->CLASS['language']->get['userform']['addgroup'].'</b></legend>
			<form action="index.php" method="post">
				<input type="hidden" name="action" value="addgroup">
				<table border="0" cellpadding="1" cellspacing="3">
				<tr><td>'.$this->CLASS['language']->get['userform']['groupname'].': </td><td><input type="text" name="name" value=""></td></tr>
				<tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'"></td></tr>
				</table>
			</form>
		';
	}

	// edit group
	function edit_group() {
		$res = $this->CLASS['db']->query("SELECT * FROM groups WHERE id=".$_GET['gid']."");
		$anz = $this->CLASS['db']->num_rows($res);

		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
			echo '
				<h2>'.$this->CLASS['language']->get['userform']['editgroup'].'</h2>
				<fieldset>
					<legend><b>'.$this->CLASS['language']->get['userform']['editgroup'].'</b></legend>
				<form action="index.php" method="post">
					<input type="hidden" name="action" value="editgroup">
					<input type="hidden" name="gid" value="'.$row['id'].'">
					<table border="0" cellpadding="1" cellspacing="3">
					<tr><td>'.$this->CLASS['language']->get['userform']['groupname'].': </td><td><input type="text" name="name" value="'.$row['name'].'"></td></tr>
					<tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'"></td></tr>
					</table>
				</form>
			';
		}
	}

	// show error
	function show_error() {
		echo '
			ERROR
		';
	}

	// show tree content
	function show_tree_content($count = 0) {
		if($_SESSION['cid'] != "" && $this->CLASS['path']->isTree($_SESSION['cid']) && $this->CLASS['knowledgeroot']->checkRecursivPerm($_SESSION['cid'], $_SESSION['userid']) != 0) {
			// get my rights - possible is 0,1,2
			$mypagerights = $this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']);

			if($mypagerights == 2) {
				echo "[<a href=\"index.php?action=newpage\">".$this->CLASS['language']->get['newpage']."</a>]&nbsp;\n";
				echo "[<a href=\"index.php?action=editpage\">".$this->CLASS['language']->get['renamepage']."</a>]&nbsp;\n";
				echo "[<a href=\"#\" onclick=\"window.document.forms.move.move.value='move'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=no,scrollbars=yes');\">".$this->CLASS['language']->get['movepage']."</a>]&nbsp;\n";
				echo "[<a href=\"index.php?delpage=".$_SESSION['cid']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['delpageask'] . "');\">".$this->CLASS['language']->get['delpage']."</a>]&nbsp;\n";
				echo "[<a href=\"index.php?action=newcontent\">".$this->CLASS['language']->get['newcontent']."</a>]\n<br><hr>";
			}

			//check if userid and groupid is set, if not set to 0
			if($_SESSION['userid'] == "" || $_SESSION['groupid'] == "") {
				$_SESSION['userid'] = 0;
				$_SESSION['groupid'] = 0;
			}

			// select the content in table content with userrights
			if($_SESSION['admin'] == 1) {
				$query = "SELECT id,content FROM content WHERE belongs_to='".$_SESSION['cid']."' AND deleted=0 ORDER BY sorting ASC";
			} else {
				$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$_SESSION['userid']."");
				$orclause = "";
				while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
					if($this->CLASS['db']->dbtype == "pgsql") {
						$orclause .= "OR (\"group\"=".$rowuser['groupid']."  AND grouprights > 0) ";
					} else {
						$orclause .= "OR (`group`=".$rowuser['groupid']."  AND grouprights > 0) ";
					}
				}
				
				if($this->CLASS['db']->dbtype == "pgsql") {
					$query = "SELECT id,content FROM content WHERE belongs_to='".$_SESSION['cid']."' AND deleted=0 AND ((otherrights > 0) OR (\"group\"='".$_SESSION['groupid']."' AND grouprights > 0) ".$orclause."OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY sorting ASC";
				} else {
					$query = "SELECT id,content FROM content WHERE belongs_to='".$_SESSION['cid']."' AND deleted=0 AND ((otherrights > 0) OR (`group`=".$_SESSION['groupid']." AND grouprights > 0) ".$orclause."OR (owner='".$_SESSION['userid']."' AND userrights>0)) ORDER BY sorting ASC";
				}
			}

			$res = $this->CLASS['db']->query($query);
			$anz = $this->CLASS['db']->num_rows($res);

			// needed for up and down arrows
			$firstcontent = 1;
			$maxcontent = $anz;
			$contentcounter = 0;

			// check if some table is on the page
			if($anz != 0) {
				while($row = $this->CLASS['db']->fetch_assoc($res)) {
					$contentcounter++;

					$mycontentrights = $this->CLASS['knowledgeroot']->getContentRights($row['id'],$_SESSION['userid']);

					echo "<div id=\"contentid_".$row['id']."\">\n";
					echo "<a name=\"" . $row['id'] . "\"></a>\n";
					//echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:1px solid black; padding:5px; background-color:#ffffff;\"><tr><td>";
					echo $row['content'];
					echo "<br>\n";
					if($this->CLASS['db']->dbtype == "pgsql") {
						$result = $this->CLASS['db']->query("SELECT *, to_char(date,'DD. Mon YYYY HH24:MI:SS') AS dateform FROM files WHERE belongs_to='".$row['id']."' AND deleted=0 ORDER BY id ASC");
					} else {
						$result = $this->CLASS['db']->query("SELECT *, DATE_FORMAT(date,'%d. %M %Y %H:%i:%s') AS dateform FROM files WHERE belongs_to='".$row['id']."' AND deleted=0 ORDER BY id ASC");
					}

					while($zeile = $this->CLASS['db']->fetch_assoc($result)) {
						$title = "";
						if($zeile['owner'] == NULL || $zeile['owner'] == 0 || $zeile['owner'] == "") {
							$title = $zeile['dateform'];
						} else {
							$title = $this->CLASS['knowledgeroot']->getOwner($zeile['owner']) . " - " . $zeile['dateform'];
						}

						if($mycontentrights == 2) {
							echo "<a href=\"index.php?delfile=".$zeile['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['delete'] . "');\"><img src=\"images/delete.gif\" title=\"".$this->CLASS['language']->get['del']."\" class=\"upload\"></a>&nbsp;<a href=\"index.php?download=".$zeile['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\"> ".$zeile['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($zeile['filesize'])."]&nbsp;[".$title."]</font><br>\n";
						} else {
							echo "<a href=\"index.php?download=".$zeile['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\"> ".$zeile['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($zeile['filesize'])."]&nbsp;[".$title."]</font><br>\n";
						}
					}

					if($mycontentrights == 2) {
						echo "<br>\n[<a href=\"index.php?eid=".$row['id']."\">".$this->CLASS['language']->get['editcontent']."</a>]&nbsp;\n";
						echo "[<a href=\"index.php?delid=".$row['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['delete'] . "');\">".$this->CLASS['language']->get['delcontent']."</a>]&nbsp;\n";
						echo "[<a href=\"#\" onclick=\"window.document.forms.move.contentid.value='".$row['id']."'; window.document.forms.move.move.value='cmove'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=no');\">".$this->CLASS['language']->get['movecontent']."</a>]\n<br><br>\n";

						echo "<b>".$this->CLASS['language']->get['addfile']."</b>\n<form action=\"index.php\" method=\"post\" enctype=\"multipart/form-data\">\n<input type=\"hidden\" name=\"upload\" value=\"yes\"><input type=\"hidden\" name=\"contentid\" value=\"".$row['id']."\"><input type=\"file\" name=\"datei\">&nbsp;\n<input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['add']."\"></form><br><div style=\"float:right;\">[&nbsp;<a href=\"#top\" alt=\"" . $this->CLASS['language']->get['topdescription'] . "\">".$this->CLASS['language']->get['top']."</a>&nbsp;]</div>";

						if($mypagerights == 2) {
							if ($maxcontent != $contentcounter) {
								echo "<div class=\"downarrow\"><a href=\"index.php?movedown=".$row['id']."\" title=\"".$this->CLASS['language']->get['movecontentdown']."\"><img src=\"images/down_arrow.gif\" border=\"0\" alt=\"".$this->CLASS['language']->get['movecontentdown']."\" /></a></div>\n";
							}

							if ($firstcontent != 1) {
								echo "<div class=\"uparrow\"><a href=\"index.php?moveup=".$row['id']."\" title=\"".$this->CLASS['language']->get['movecontentup']."\"><img src=\"images/up_arrow.gif\" border=\"0\" alt=\"".$this->CLASS['language']->get['movecontentup']."\" /></a></div>\n";
							}

							$firstcontent = 0;
						}

						echo "<br><hr><br>\n";

					} else {
						echo "<div style=\"float:right;\">[&nbsp;<a href=\"#top\" alt=\"" . $this->CLASS['language']->get['topdescription'] . "\">".$this->CLASS['language']->get['top']."</a>&nbsp;]</div><br><hr>";
					}
					//echo "</td></tr></table>";

					echo "</div>\n";
				}

				if($mypagerights == 2) {
					echo "[<a href=\"index.php?action=newpage\">".$this->CLASS['language']->get['newpage']."</a>]&nbsp;\n";
					echo "[<a href=\"index.php?action=editpage\">".$this->CLASS['language']->get['renamepage']."</a>]&nbsp;\n";
					echo "[<a href=\"#\" onclick=\"window.document.forms.move.move.value='move'; window.open('move.php','Knowledgeroot','width=310,height=400,menubar=yes,resizable=no');\">".$this->CLASS['language']->get['movepage']."</a>]&nbsp;\n";
					echo "[<a href=\"index.php?delpage=".$_SESSION['cid']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['delpageask'] . "');\">".$this->CLASS['language']->get['delpage']."</a>]&nbsp;\n";
					echo "[<a href=\"index.php?action=newcontent\">".$this->CLASS['language']->get['newcontent']."</a>]\n<br><br>";
				}
			} else {
				echo "<h3>" . $this->CLASS['language']->get['nocontent'] . "</h3>\n";
			}

			// form for move page
	                echo "<form name=\"move\" action=\"index.php\" method=\"post\">\n";
                	echo "<input type=\"hidden\" name=\"move\" value=\"move\">\n";
        	        echo "<input type=\"hidden\" name=\"to\" value=\"".$_SESSION['cid']."\">\n";
					echo "<input type=\"hidden\" name=\"contentid\" value=\"\">\n"; // use for move pagecontent
	                echo "</form>\n";


		} else {
			echo "<div class=\"welcome\">".$this->CLASS['language']->get['welcome']."</div>\n";
		}
	}
}
?>
