<?php
/*
 * Knowledgeroot
 * Configurationfile
 * Frank Habermann
 */

// set type of database - pgsql or mysql or mysqli
$CONFIG['db']['type'] = "mysql";

// configuration for database
$CONFIG['db']['host'] ="localhost";
$CONFIG['db']['user'] ="root";
$CONFIG['db']['pass'] = "";
$CONFIG['db']['database'] = "knowledgeroot";
$CONFIG['db']['schema'] = "public"; // only in pgsql
$CONFIG['db']['encoding'] = "LATIN1";

// set charset in htmlpage
$CONFIG['knowledgeroot']['charset'] = "utf8";

// set language for knowledgeroot
// available are: en, de, pt-br, fr, ja, nl
$CONFIG['knowledgeroot']['language']  = "en";

// used for languagedropdown at options
$CONFIG['knowledgeroot']['availablelanguages'] = array("en","de","pt-br","fr","ja","nl");

// using htmlarea to edit and create content ? 1 = true, 0 = false
$CONFIG['htmleditor']['use'] = 1;

// select your favorit htmleditor - tinymce or fckeditor
$CONFIG['htmleditor']['editor'] = "tinymce";

// configuration for tinymce and normal textarea
$CONFIG['htmleditor']['tinymce']['cols'] = "75";
$CONFIG['htmleditor']['tinymce']['rows'] = "20";

// configuration for fckeditor
$CONFIG['htmleditor']['fckeditor']['width'] = "600";
$CONFIG['htmleditor']['fckeditor']['height'] = "450";
$CONFIG['htmleditor']['fckeditor']['langdefault'] = "en";
$CONFIG['htmleditor']['fckeditor']['langdetect'] = false;
$CONFIG['htmleditor']['fckeditor']['toolbar'] = 'Default'; // Default
$CONFIG['htmleditor']['fckeditor']['skin'] = 'default'; // default or office2003 or silver

// set title to knowledgeroot
$CONFIG['knowledgeroot']['title'] = "Knowledgeroot";

//expand all - 1 or 0
$CONFIG['menu']['expandall'] = 1;

// static or slidemenu - slide or static
$CONFIG['menu']['type'] = "static";

// use ajax menu - yes or no
$CONFIG['menu']['ajax'] = "yes";

// set default theme to knowledgeroot
$CONFIG['knowledgeroot']['default_theme'] = "wordpress";

// define upload folder
// upload folder for knowledgeroot uploads
$CONFIG['knowledgeroot']['uploadfolder'] = "uploads/";
// upload folder for fckeditor - use "auto" unless problems arise ... then try absolute server path
$CONFIG['knowledgeroot']['uploadserverpath'] = "auto";

// if you wish to show another page as the welcome page insert here the pageid to show
$CONFIG['knowledgeroot']['defaultpage'] = "";

// enable mail notification if content/page is created/modified/deleted
$CONFIG['email']['notification'] = 0;

// comma separated list with email addresses which will receive an email
$CONFIG['email']['recipients'] = "";

// advanced configuration settings for email notifications
$CONFIG['email']['type'] = "text"; // text or html mail
$CONFIG['email']['from_name'] ="Knowledgeroot";
$CONFIG['email']['from_email'] ="knowledgeroot@mydomain.com";
$CONFIG['email']['smtp_mode'] = 0; // 0 => disabled, 1 => enabled
$CONFIG['email']['smtp_host'] = "";
$CONFIG['email']['smtp_port'] = 25; // default SMTP port is 25
$CONFIG['email']['smtp_username'] = ""; // non-empty value here will force use of SMTP authentication
$CONFIG['email']['smtp_password'] = "";
?>
