/***************************************************************************
                          chatinformation.h  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATINFORMATION_H
#define CHATINFORMATION_H

#include <qstring.h>

// Forward declarations
class ContactList;
class MsnNotificationConnection;

/**A container for neccessary chat information.
  *@author Mike K. Bennett
  */

class ChatInformation
{
  public:
    // The constructor for a user-started chat
    ChatInformation(MsnNotificationConnection *parent, const QString& handle, ContactList *contactList);
    // The constructor for a contact-started chat
    ChatInformation(MsnNotificationConnection *parent, const QString& handle, ContactList *contactList,
                   const QString &ip, int port, const QString &authorization, const QString &chatId);
    // The destructor
  	~ChatInformation();
    // Return the switchboard authorization
    const QString&   getAuthorization() const;
    // Return the contact-started chat verification id
    const QString&   getChatId() const;
    // Return the handle of the contact this is a chat with
    const QString&   getContactHandle() const;
    // Return the pointer to the list of contacts
    ContactList*     getContactList();
    // Return the switchboard server ip
    const QString&   getIp() const;
    // Return the notification connection that spawned this object
    MsnNotificationConnection *getNotificationConnection() const;
    // Return the switchboard server port
    const int&       getPort() const;
    // Return whether the user started the chat
    bool             getUserStartedChat() const;
    // Set server information
    void             setServerInformation( const QString& ip, const int& port, const QString& authorization );


  private: // Private attributes
    // The authorization used to connect to the switchboard server
    QString          authorization_;
    // The id of the chat, used for authenticating a contact-started chat
    QString          chatId_;
    // The handle of the contact being chatted with
    QString          contactHandle_;
    // A pointer to the notification server's contact list
    ContactList     *contactList_;
    // The switchboard server's ip
    QString          ip_;
    // The notification connection that spawned this object
    MsnNotificationConnection *notificationConnection_;
    // The switchboard server's port
    int              port_;
    // Whether the user (true) or the contact (false) started the chat
    bool             userStartedChat_;

};

#endif
