#ifndef INTERFACE_H
#define	INTERFACE_H
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <bfd.h>
#include "chump.h"

#  define uchar unsigned char
#  define _(String) (String)


void board_getcpuinfo(void); /*set all CPU the vareables below from the dot file*/
int board_ping(int);         /*big ping the board returns 1 if ok 0 if not*/
int board_mini_ping(int);    /*pass TRUE if you want to set board version*/
int board_micro_ping(void);  /*mini is a smaller ping and micro is even faster*/
int board_enq(void);         /*ask the board what it is doing */
int board_wotru(void);       /*check board info*/
int board_get_regbank (int); /*update the info on all registers in that bank*/
int board_set_register (int,int,unsigned char*); /*set one register (regbank,regnumber,value)*/
int board_get_memory (int,unsigned char*,unsigned char*,int);/*get memory (count,address,destination, size)*/
int board_set_memory (int,unsigned char*,unsigned char*,int);/*set memory (count,address,source, size)*/
void dead_child(int);
int main(int argc, char *argv[]); /* main function*/
void commandline(int argc, char *argv[]); /* process command line paramiters*/
void setup(void);            /* setup function*/

typedef enum {        /*Board instructions unsigned char*/
 BR_NOP     = 0x0,    /*need work on*/
 BR_PING    = 0x1, 
 BR_WOT_R_U = 0x2,
 BR_RESET   = 0x4,
 BR_H_RESET = 0x5,
 BR_COMM_W  = 0x6,
 BR_COMM_R  = 0x7,
 
 BR_FR_GET  = 0x10,
 BR_FR_SET  = 0x11,
 BR_FR_WRITE= 0x12,
 BR_FR_READ = 0x13,
 BR_FR_FILE = 0x14,
 BR_FR_SEND = 0x15,
 
 BR_WOT_U_DO= 0x20,
 BR_STOP    = 0x21,
 BR_PAUSE   = 0x22,
 BR_CONTINUE= 0x23,
 
 BR_RTF_SET = 0x24,
 BR_RTF_GET = 0x25,
 
 BR_BP_WRITE= 0x30,
 BR_BP_READ = 0x31,
 BR_BP_SET  = 0x32,
 BR_BP_GET  = 0x33,
 
 BR_GET_REG = 0x5a, /*not general case!*/
 BR_GET_MEM = 0x48,
 BR_SET_REG = 0x52, /*not general case!*/
 BR_SET_MEM = 0x40,
 BR_START   = 0x80
} BR_Instruction;

typedef struct {        /* Regbank struct*/
 char          *name;   /* Name to display in window*/
 int           offset;  /* offset in registers (in bits if flags)*/
 unsigned char width;   /* width in bytes (0 means 1bit flags)*/
 unsigned char number;  /* count of registers*/
 GList         **names; /* array of strings for names*/
 unsigned char *values; /* array of values (regvalue = values + regnumber * width*/
 int           pointer; /* does this regbank store memory pointers */
} reg_bank;             /* flags use 1 char each*/

typedef struct {        /* special_reg struct*/
 char          *name;   /* Name of register  */
 unsigned char *value;  /* offset of value   */
 GdkColor      colour;  
 char**        pixmap_data;
 GdkPixmap*    pixmap;
 GdkBitmap*    bitmap;
 int           banknumber;
 int           regnumber;
 int           active;  /* if activated or not */
} special_reg;   




typedef enum {
    UNKNOWN,
    XILINX_FPGA,
    CONSOLE,
    I_HAVE_TO_PUT_SOMETHING_HERE,
    ELSE_IT_WOULD_LOOK_STUPID
 } feature_type;

typedef struct {
 char* filestring;
 } xilinx_fpga_data;

typedef struct {
 GtkWidget *text;
 } console_data;
 
typedef struct {        /* Feature struct */
 unsigned char reference_number;
 int           sub_reference_number;
 char*         name;
 feature_type  type;
 int           number;
 union {
       xilinx_fpga_data xilinx_fpga;
       console_data console;
 } data;
} feature;



typedef struct {        /* Memory Segments */
 unsigned char*	start;  /* chararr pointer to address of length board_memory_ptr_width*/
 unsigned char*	length; /* chararr of length board_memory_ptr_width*/
} memory_segment;

typedef enum {
 SERIAL,
 PIPE,
 EMULATOR,
 FAKE
} target_type;

typedef struct {
 char*  string;
 int    number;
} StringMatch;


uchar board_nulreg[16];


char* rcfile;
char* emulator_prog;
char* pipe_name_out;
char* pipe_name_in;

int use_internal;
int VERBOSE;


// Symbol* symbol_table;
// int symbol_count;

SymbolTable* symbol_table;




GList* config_toplist;
char* config_file;

GtkStyle* fixed_style;
GdkFont*  fixed_font;
int board_there;
target_type board_type;
int board_version;
int board_wordaline;
int board_memory_ptr_width;
unsigned char board_cpu_reference_number;
int	board_cpu_sub_reference_number;
char *board_cpu_name;
int board_num_regbanks;
int board_main_regbank;
int special_register_count;
special_reg special_registers[3];
uchar board_startcommand; 
reg_bank *board_reg_banks;
int board_regbanks_gran;
int board_num_features;
feature *board_features;
int board_num_mem_segments;
memory_segment *board_mem_segments;
DefinitionStack *board_asm_tables;
int board_emulation_communication_from[2];
int board_emulation_communication_to[2];
int board_emulation_pid;
#endif
