/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SCHEDULE_H_
#define _SCHEDULE_H_

#include <qvariant.h>
#include <qdialog.h>
#include <qspinbox.h> 

#include <qdatetime.h> 
#include <qlineedit.h> 
#include <qstring.h>
#include <qtimer.h>
#include <qvalidator.h>
#include <qwidget.h>
#include <qcheckbox.h>

#include "cthost.h"
#include "cttask.h"
#include "ctcron.h"

#include <kdatepicker.h>
#include <knuminput.h>


class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
//class QListView;
class KTView;
class QListViewItem;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class CollectionSetup;
class QToolButton;
class QHBoxLayout;

class HMSTimeWidget : public KIntSpinBox
{
  Q_OBJECT
 public:
  HMSTimeWidget(QWidget *parent=0, const char *name=0);
 protected:
  QString mapValueToText(int);
};

class KStrictIntValidator : public QIntValidator 
{
public:
  KStrictIntValidator(int bottom, int top, QWidget * parent,
		      const char * name = 0 )
    : QIntValidator(bottom, top, parent, name) {};
  
  QValidator::State validate( QString & input, int & d ) const; 
};

/**
 * This class serves as the main window for Schedule.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Schedule  : public QDialog
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Schedule( QWidget* parent = 0, QStringList filepattern = 0,const char* name = 0, bool modal = FALSE, WFlags fl = 0 );

    /**
     * Default Destructor
     */
    virtual ~Schedule();

    /**
     * Use this method to load whatever file/URL you have
     */
    
    void  setDirName(QString);
    bool isMultiScan();
    const CTHost& getCTHost() const;

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:

	void slotQueryDatePicker(int index);
	void slotAddDateToCombo(QDate newdate);
	void slotScheduleScan();
	void slotDelete();
	void slotOK();
	void slotCancel();
private:
    void setupAccel();
    void setupActions();
    QString createScanScript();
    QString createStartupScript();
private:

signals:

public slots:
private slots:
private:
    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo, *check_combo;
    QCheckBox *recursive_box;
//    QListView *resultview;
    QPushButton *search_button, *cancel_button;
    QLabel *status_label, *status2_label,*matches_label,*matches2_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    bool errorsEncountered;
    QPushButton* adv_options;
    QString urlsToScan;
    QString prevdir;
    QStringList listOfUrlsToScan;
    bool multi_recursive;
    CollectionSetup* setup;
    QToolButton *m_tabsClose;
    QToolButton* play;
    QToolButton* stop;
    QHBoxLayout* controls;
    QDate _date;
    HMSTimeWidget* hour;
    HMSTimeWidget* minute;
    QStringList _filepattern;
    KTView *schedulebox;
    CTHost* cthost;
    CTTask* cttask;
    CTCron* ctcron;
};


#endif // _SCHEDULE_H_
