/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/
/*
 * Common Cluster Definitions
 * $Revision: 1.6 $
 */

#ifndef	_CLUSTERDEFS_H
#define	_CLUSTERDEFS_H	1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define CLU_CONFIG_SEPARATOR	'%'
#define SM_COMMAND_NAME		"svcmgr"

/*
 * Note: these defines dictate the on-disk formats of the node and service
 * 	 descriptions.  Consequently, changing these values can result in
 *	 "rolling upgrade" type issues.
 */
#define MIN_NODE		0		// First available node number
#define MAX_NODES		2		// Max cluster members
#define MAX_CHANNELS		10		// Max heartbeat channels
#define NODE_ID_NONE		999		// ID representing "None"
#define MAX_DESC		256		// Descriptive comment
#define MIN_SERVICE		0		// First available svc number
#define MAX_SERVICES		100		// Max # of cluster services
#define MAX_SERVICE_NAMELEN	64		// Max service name length
#define SERVICE_ID_NONE		999		// service ID not set yet

/*
 * Node States
 */
#define NODE_UNINITIALIZED	0	// First time polling partner
#define NODE_INVALID		1	// Invalid status block read
#define NODE_IOERROR		2	// Error in reading status block
#define NODE_UP			3	// Node is a cluster member
#define NODE_DOWN		4	// Node not a cluster member
#define LAST_STATE		5	// Last one in the list, not a valid state

/*
 * Strings corresponding to the states to allow printing for debug purposes.
 */
extern char *nodeStateStrings[];

/*
 * Service states
 */
#define SVC_UNINITIALIZED       0	// initialized disk, not a valid state
#define SVC_STARTING    	1	// svc is starting
#define SVC_RUNNING     	2	// svc is running
#define SVC_STOPPING    	3	// svc is stopping
#define SVC_STOPPED     	4	// svc is stopped
#define SVC_DISABLING   	5	// user requested service stop
#define SVC_DISABLED    	6	// user stopped service
#define SVC_ERROR       	7    	// svc did not cleanly move states
#define SVC_LAST_STATE          7       // for audits

extern char *serviceStateStrings[];

/*
 * ServiceBlock
 *
 * This structure represents a service description.  This data structure
 * represents the in-memory service description.  (There is a separate
 * description of the on-disk format.)
 */
typedef struct {
	int	id;			// Range: 0 to (MAX_SERVICES-1)
	int	owner;			// Node number of server
	int	state;			// See above Service states defined
} ServiceBlock;

#ifdef __cplusplus
}
#endif

#endif /* clusterdefs.h */
