/* $Id: we_protocols.c 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gmodule.h>

#include "simocombobox.h"

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


GtkWidget *
get_we_protocols_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel = glade_xml_get_widget(gladexml, "we_panel_protocols");

  return panel;
}


void
fill_we_protocols_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *rad;

  if (!world) {
    return;
  }

  if (world->mccp_behavior == MCCP_DISABLE) {
    rad = glade_xml_get_widget(gladexml, "radMCCPDisable");
  } else if (world->mccp_behavior == MCCP_ALWAYS) {
    rad = glade_xml_get_widget(gladexml, "radMCCPAlways");
  } else {
    rad = glade_xml_get_widget(gladexml, "radMCCPAfterConnect");
  }

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rad), TRUE);
}



void
update_we_protocols_parameters(World *world)
{
  GladeXML  *gladexml;
  GtkWidget *radMCCPAfterConnect;
  GtkWidget *radMCCPAlways;
  GtkWidget *radMCCPDisable;

  gladexml            = glade_get_widget_tree(world->dlgEditWorld);
  radMCCPAfterConnect = glade_xml_get_widget(gladexml, "radMCCPAfterConnect");
  radMCCPAlways       = glade_xml_get_widget(gladexml, "radMCCPAlways");
  radMCCPDisable      = glade_xml_get_widget(gladexml, "radMCCPDisable");

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPAfterConnect))) {
    world->mccp_behavior = MCCP_AFTER_CONNECT;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPAlways))) {
    world->mccp_behavior = MCCP_ALWAYS;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radMCCPDisable))) {
    world->mccp_behavior = MCCP_DISABLE;
  }
}
