/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : The main widget, show photo properties
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */


#ifndef _KFLICKRWIDGET_H_
#define _KFLICKRWIDGET_H_

#include "flickrcomm.h"
#include "kflickrWidgetUI.h"
#include "kflickrwidgetiface.h"

#include <kurl.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qstring.h>
#include <qstringlist.h>

class QDropEvent;
class QComboBox;
class QPushButton;
class KPushButton;
class PhotoListView;
class QListViewItem;
class KProgressDialog;
class PhotoListViewItem;

/**
 * This is our main widget that contains the widgets to manage user accounts
 * and add, remove and edit photos that are intended for upload.
 * @short The Main Widget.
 * @author M. Asselstine <asselsm@gmail.com>
 */
class kflickrWidget : public kflickrWidgetUI, virtual public kflickrWidgetIface
{
    Q_OBJECT

public:
    kflickrWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~kflickrWidget();
    
    QStringList persistentTags() const;
    
    void addPhoto(const KURL &url);
    PhotoListViewItem* addPhoto(const KURL &url, bool doPreview);
    void addPhotos(const KURL::List &urls);
    void addPhoto(const KURL &url, const QString &title,
                  const QStringList &tags, const QString &desc);

public slots:
    void addPhotos();
    void removePhotos();
    void uploadPhotos();
    void onEditSelected();
    void updateActionStates();
    void updateCount(QListViewItem*);
    
    void handleCommError(const QString &);
    void dropSlot(QDropEvent*, QListViewItem*);
    void setPersistentTags(const QStringList &);
    void doUserAuthentication(const QString &frob);
    void newBandwidthValue(const QString &val);
    void setPhotosets(const QStringList &, const QString &);
    void addUser(const QString &name, const QString &token, const QString &nsid);

private:
    int m_currentUserIndex;
    QStringList m_userNSIDs;
    QStringList m_userTokens;
    PhotoListView* m_photolist;

    QTimer m_timer;
    FlickrComm m_comm;
    QStringList m_persistTags;
    KProgressDialog *m_progressDlg;
    bool m_uploadInProgress;

private:        
    void uploadNextPhoto();
    void hideUploadProgress();
    void showUploadProgress(int numPhotos);
    void updateUploadProgress(const QString &);

private slots:
    void cancelUpload();
    void authorizeNewUser();
    
    void editSelectedItem();
    void editSelectedItems();
    
    void refreshCount();
    void setActiveUser(const QString &);
    void photoUploadedOK(const QString &);
    
signals:
    void enableEdit(bool);
    void enableRemove(bool);
    void enableUpload(bool);
    
    void photoCount(int);
    void bandwidthValue(const QString&);
};

#endif

