/***************************************************************************
                          popup.cpp  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2001-2003 by Aurelien Jarno
    email                : aurelien@aurel32.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// application specific includes
#include "popup.h"

// includes files for Qt
#include <qpainter.h>
#include <qstring.h>
#include <qsize.h>
#include <qfontmetrics.h>

// includes files for KDE
#include <kwin.h>

Popup::Popup(QWidget *parent, const char *name) : QWidget(parent,name), 
						  relX(0),
                                                  relY(0),
						  isDragged(false),
                                                  popupFont("fixed", 12), 
						  popupText(QString(""))
{
  KWin::setType(winId(), NET::Override);
  KWin::setState(winId(), NET::Sticky | NET::SkipTaskbar | NET::StaysOnTop);
}

Popup::~Popup()
{
}

void Popup::autoResize()
{
  QFontMetrics fm(popupFont);
  QSize newsize = fm.size(0, popupText) + QSize(30, 0);

  if (size() != newsize)
    resize(newsize);
  else
    repaint();
}

void Popup::setText(const QString text)
{
  if (popupText != text)
  {
    popupText = text;
    autoResize();
  }
}

void Popup::setFont(const QFont font)
{
  if (popupFont != font)
  {
    popupFont = font;
    autoResize();
  }
}

void Popup::paintEvent(QPaintEvent *Event)
{
  Event = (QPaintEvent *) 0;
  QPainter p(this);

  p.fillRect(0, 0, width(), height(), QBrush(QColor((isDragged) ? QColor(0, 0, 255) : QColor(0, 0, 100))));
  p.fillRect(2, 2, width() - 4, height() - 4, QBrush(QColor(254, 254, 220)));

  p.setFont(popupFont);
  p.setPen(QColor(0, 0, 0));
  p.drawText(0, 0, width(), height(), AlignCenter | AlignVCenter, popupText);
}

void Popup::mousePressEvent(QMouseEvent *Event)
{
  if(Event->button() == RightButton) emit clicked();
  else
  {
    isDragged = TRUE;
    relX = Event->x();
    relY = Event->y();
    repaint();
  }
}

void Popup::mouseReleaseEvent(QMouseEvent *Event)
{
  Event = (QMouseEvent *) 0;
  isDragged = FALSE;
  repaint();
  emit savePos();
}

void Popup::mouseMoveEvent(QMouseEvent *Event)
{
  move(Event->globalX() - relX, Event->globalY() - relY);
}
