/* Debian GNU/Linux Swirl
 * include/linux/linux_logo.h: This is a linux logo
 *                             to be displayed on boot.
 *
 * Created with ppm2logo, (c) 1998 by Bernd Paysan (bernd.paysan@gmx.de)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *           linux_logo_green[0],
 *           linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */

#define LINUX_LOGO_COLORS 221

#ifdef INCLUDE_LINUX_LOGO256

unsigned char linux_logo_red[] __initdata = {
  0xFD, 0xFE, 0xF5, 0xEC, 0xF4, 0xFE, 0xFC, 0xFD,
  0xDF, 0xC3, 0xAC, 0xA0, 0xB5, 0xBF, 0xAC, 0xB4,
  0xBD, 0xAD, 0xAD, 0xBF, 0xDA, 0xDF, 0xD4, 0xC6,
  0xD4, 0xEC, 0xF7, 0xFD, 0xFD, 0xFE, 0xEC, 0xFE,
  0xF2, 0xE8, 0xE2, 0xC4, 0xB8, 0xAF, 0x9C, 0xA4,
  0xA4, 0xAE, 0xAF, 0xA4, 0x9C, 0xB9, 0xA3, 0xD7,
  0xE1, 0xEE, 0xF2, 0xF5, 0xFD, 0xE3, 0xBA, 0xB1,
  0xA1, 0xA3, 0xC1, 0xC2, 0xB8, 0x9D, 0x94, 0x94,
  0xA5, 0xED, 0xE9, 0xD0, 0xB8, 0xB9, 0xAC, 0x8C,
  0x95, 0x93, 0xA0, 0xD8, 0x95, 0x92, 0xCE, 0xC4,
  0xCB, 0xC8, 0x9C, 0xAE, 0xF1, 0xFD, 0xE7, 0x9D,
  0xF3, 0xBC, 0x96, 0xAF, 0xBB, 0xD7, 0xEF, 0xFC,
  0xCF, 0xCB, 0xCC, 0xCB, 0xCE, 0xF9, 0xC9, 0xED,
  0xC8, 0xAE, 0xC6, 0xDF, 0xF1, 0xE1, 0xB4, 0xE2,
  0x94, 0xA1, 0xC9, 0xED, 0xE9, 0xC5, 0xB9, 0xE0,
  0xF4, 0xD7, 0xE7, 0xB9, 0xD6, 0xD1, 0xB5, 0xF0,
  0xCD, 0x8C, 0xDE, 0xC8, 0xBC, 0x7B, 0xBB, 0xD5,
  0xE6, 0x83, 0xA5, 0xF6, 0xFE, 0xF9, 0xB0, 0x8B,
  0xF4, 0xDC, 0xD6, 0xBD, 0xAD, 0x8B, 0x88, 0x99,
  0x92, 0x9E, 0xE6, 0x8A, 0x7F, 0x76, 0x96, 0x8E,
  0x98, 0xEC, 0xD2, 0xEF, 0xB0, 0x70, 0xE0, 0xB8,
  0x92, 0xB6, 0xDE, 0xDE, 0xE2, 0xDC, 0x8E, 0xE5,
  0xC3, 0xC2, 0xC5, 0xBD, 0xD6, 0xC8, 0xA2, 0x8D,
  0xE2, 0x96, 0xD3, 0xD0, 0xAD, 0xBE, 0xD8, 0xD4,
  0xC6, 0x8B, 0x9C, 0xC0, 0x81, 0x83, 0xD2, 0xBE,
  0x83, 0xA0, 0xAE, 0x84, 0x83, 0x76, 0xAA, 0x7A,
  0x6A, 0x7E, 0xDE, 0x74, 0x77, 0xB8, 0xA8, 0x6D,
  0xFA, 0xA2, 0x76, 0xD0, 0x80
};

unsigned char linux_logo_green[] __initdata = {
  0xFD, 0xF4, 0xFD, 0xFE, 0xED, 0xE4, 0xC4, 0xAB,
  0x84, 0x5D, 0x3C, 0x2D, 0x2B, 0x2C, 0x1D, 0x25,
  0x35, 0x25, 0x2C, 0x43, 0x5E, 0x68, 0x5D, 0x54,
  0x65, 0x7E, 0x92, 0xB4, 0xCC, 0xEC, 0xF4, 0xD4,
  0xB3, 0xA4, 0x8D, 0x6B, 0x54, 0x34, 0x24, 0x13,
  0x0C, 0x0C, 0x04, 0x04, 0x0C, 0x1D, 0x1C, 0x6D,
  0x78, 0x94, 0xBB, 0xF4, 0xDC, 0x9C, 0x5C, 0x4C,
  0x34, 0x24, 0x0B, 0x04, 0x03, 0x03, 0x0C, 0x1C,
  0x3C, 0xE3, 0xAA, 0x84, 0x0B, 0x13, 0x13, 0x15,
  0x24, 0x2C, 0x43, 0x84, 0x13, 0x03, 0x74, 0x63,
  0x04, 0x13, 0x13, 0x44, 0xA4, 0xBC, 0xC3, 0x1B,
  0xAD, 0x6C, 0x34, 0x62, 0x65, 0x7D, 0x9D, 0xA4,
  0x7C, 0x0B, 0x64, 0x5D, 0x6D, 0x9C, 0x44, 0xEB,
  0x4D, 0x54, 0x7C, 0xAB, 0xC5, 0x71, 0x3D, 0x94,
  0x46, 0x63, 0x9C, 0xCD, 0xBC, 0x84, 0x43, 0x7E,
  0xE6, 0x75, 0xB5, 0x4D, 0x8C, 0xC5, 0xA5, 0xD4,
  0x55, 0x33, 0xC3, 0xB6, 0x3B, 0x24, 0x7C, 0x23,
  0x50, 0x2C, 0x6D, 0x46, 0x76, 0x8D, 0x5D, 0x0D,
  0x7E, 0xA5, 0xB2, 0x8D, 0x73, 0x4B, 0x46, 0x54,
  0x5E, 0x7E, 0xD3, 0x52, 0x43, 0x3A, 0x64, 0x6E,
  0x84, 0xDC, 0xA2, 0x8C, 0x7C, 0x33, 0xBB, 0x9E,
  0x7E, 0xB2, 0xCC, 0xD2, 0xDE, 0xB4, 0x3C, 0xE4,
  0x3B, 0x1E, 0x8B, 0x73, 0x1E, 0x94, 0x5C, 0x1C,
  0x26, 0x4C, 0x9B, 0xCE, 0x6C, 0xBE, 0x30, 0x95,
  0xC6, 0x23, 0x3C, 0x22, 0x3A, 0x34, 0xBA, 0xAE,
  0x1C, 0x8C, 0x98, 0x0E, 0x15, 0x0A, 0x9E, 0x6E,
  0x5A, 0x66, 0xEA, 0x14, 0x1A, 0x83, 0x4B, 0x0D,
  0x84, 0x4E, 0x2B, 0xAC, 0x02
};

unsigned char linux_logo_blue[] __initdata = {
  0xFC, 0xFB, 0xFC, 0xFB, 0xF0, 0xF1, 0xD7, 0xC6,
  0xA1, 0x7D, 0x60, 0x50, 0x54, 0x56, 0x4A, 0x52,
  0x5E, 0x4F, 0x55, 0x6A, 0x84, 0x8E, 0x83, 0x78,
  0x89, 0xA0, 0xB1, 0xCC, 0xDE, 0xF7, 0xF3, 0xE5,
  0xCA, 0xB9, 0xA7, 0x87, 0x73, 0x5A, 0x48, 0x3F,
  0x3B, 0x3D, 0x39, 0x34, 0x39, 0x4F, 0x46, 0x8D,
  0x99, 0xB2, 0xCD, 0xF5, 0xEB, 0xB4, 0x7D, 0x6E,
  0x57, 0x4C, 0x44, 0x3C, 0x39, 0x33, 0x37, 0x41,
  0x5C, 0xE6, 0xC2, 0x9E, 0x3F, 0x42, 0x43, 0x3C,
  0x4B, 0x50, 0x64, 0xA1, 0x3D, 0x2F, 0x92, 0x81,
  0x3E, 0x4A, 0x3E, 0x67, 0xBE, 0xD2, 0xCF, 0x44,
  0xC5, 0x87, 0x53, 0x7C, 0x82, 0x99, 0xB9, 0xC0,
  0x95, 0x46, 0x86, 0x7F, 0x8D, 0xBC, 0x6E, 0xEC,
  0x76, 0x73, 0x96, 0xBD, 0xD5, 0x95, 0x61, 0xAC,
  0x60, 0x7B, 0xAA, 0xD8, 0xCD, 0x9C, 0x68, 0x9C,
  0xEB, 0x91, 0xC6, 0x73, 0xA6, 0xC9, 0xAC, 0xDE,
  0x78, 0x54, 0xCF, 0xB8, 0x65, 0x44, 0x93, 0x59,
  0x7C, 0x4C, 0x81, 0x7C, 0xA4, 0xAC, 0x7A, 0x3A,
  0xA0, 0xB6, 0xC4, 0x9F, 0x8A, 0x64, 0x5C, 0x6D,
  0x74, 0x8C, 0xDC, 0x64, 0x59, 0x4C, 0x78, 0x74,
  0x8C, 0xE3, 0xB4, 0xAC, 0x90, 0x48, 0xCA, 0xA4,
  0x84, 0xB4, 0xD2, 0xD9, 0xDC, 0xC5, 0x5A, 0xE4,
  0x64, 0x4C, 0xA2, 0x8D, 0x54, 0xA8, 0x74, 0x43,
  0x5C, 0x68, 0xAF, 0xD0, 0x84, 0xBC, 0x60, 0xAC,
  0xC4, 0x47, 0x5C, 0x50, 0x54, 0x52, 0xC4, 0xB4,
  0x41, 0x94, 0xA4, 0x34, 0x3C, 0x2C, 0xA4, 0x74,
  0x64, 0x74, 0xEC, 0x39, 0x3C, 0x96, 0x6E, 0x2F,
  0xAC, 0x6C, 0x44, 0xB8, 0x2C
};

unsigned char linux_logo[] __initdata = {
  0x20, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x22,
  0x22, 0x23, 0x22, 0x22, 0x20, 0x20, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x22, 0x24, 0x21, 0x21, 0x21,
  0x21, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B,
  0x2C, 0x2D, 0x2D, 0x2E, 0x2F, 0x30, 0x30, 0x31,
  0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39,
  0x3A, 0x3B, 0x3C, 0x25, 0x3D, 0x21, 0x21, 0x20,
  0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x23, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x23, 0x23,
  0x22, 0x22, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x21, 0x21, 0x21,
  0x24, 0x3E, 0x3E, 0x24, 0x20, 0x21, 0x3D, 0x3F,
  0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
  0x48, 0x49, 0x4A, 0x4B, 0x4B, 0x49, 0x48, 0x4C,
  0x4D, 0x2F, 0x30, 0x30, 0x31, 0x4E, 0x2C, 0x33,
  0x4F, 0x50, 0x51, 0x41, 0x52, 0x3F, 0x3D, 0x3D,
  0x3D, 0x21, 0x20, 0x3D, 0x21, 0x3D, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x53,
  0x21, 0x20, 0x21, 0x20, 0x20, 0x22, 0x23, 0x23,
  0x20, 0x22, 0x20, 0x20, 0x21, 0x21, 0x20, 0x20,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x54, 0x52, 0x55,
  0x56, 0x57, 0x58, 0x59, 0x4E, 0x4C, 0x48, 0x49,
  0x5A, 0x5A, 0x5B, 0x5A, 0x5A, 0x5A, 0x5C, 0x49,
  0x49, 0x4A, 0x49, 0x49, 0x4B, 0x5D, 0x4B, 0x49,
  0x4C, 0x5E, 0x5F, 0x60, 0x43, 0x55, 0x3B, 0x3C,
  0x3C, 0x3C, 0x3C, 0x3F, 0x3D, 0x21, 0x21, 0x61,
  0x21, 0x21, 0x20, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x20, 0x21, 0x21,
  0x21, 0x21, 0x25, 0x3C, 0x62, 0x63, 0x44, 0x58,
  0x59, 0x4C, 0x5D, 0x5D, 0x4B, 0x49, 0x64, 0x5A,
  0x5B, 0x5C, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B,
  0x5B, 0x64, 0x64, 0x64, 0x64, 0x49, 0x49, 0x49,
  0x65, 0x66, 0x4C, 0x5E, 0x67, 0x68, 0x58, 0x58,
  0x2B, 0x69, 0x6A, 0x43, 0x41, 0x3C, 0x25, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x20, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x21, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x53, 0x53, 0x53, 0x25,
  0x54, 0x3C, 0x40, 0x6B, 0x44, 0x2B, 0x6C, 0x6D,
  0x65, 0x4A, 0x5C, 0x5B, 0x5B, 0x5B, 0x5B, 0x5B,
  0x5B, 0x5C, 0x5C, 0x5B, 0x5B, 0x5B, 0x5B, 0x5C,
  0x5C, 0x5C, 0x64, 0x4A, 0x4A, 0x4A, 0x4A, 0x49,
  0x4A, 0x4A, 0x4A, 0x49, 0x4B, 0x4C, 0x47, 0x2E,
  0x4C, 0x5E, 0x5E, 0x46, 0x2B, 0x6A, 0x6E, 0x27,
  0x3F, 0x25, 0x21, 0x21, 0x21, 0x23, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x3D, 0x54,
  0x40, 0x42, 0x6F, 0x2A, 0x46, 0x48, 0x4A, 0x5C,
  0x5B, 0x70, 0x70, 0x70, 0x70, 0x5B, 0x5B, 0x5C,
  0x5A, 0x5C, 0x4A, 0x4A, 0x4A, 0x49, 0x4A, 0x4A,
  0x49, 0x66, 0x49, 0x48, 0x48, 0x48, 0x66, 0x66,
  0x4B, 0x4A, 0x49, 0x64, 0x4A, 0x4A, 0x5C, 0x64,
  0x71, 0x4A, 0x4B, 0x48, 0x5E, 0x72, 0x73, 0x6E,
  0x74, 0x75, 0x54, 0x21, 0x20, 0x21, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x21, 0x20, 0x21, 0x20, 0x21,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x21, 0x21, 0x3D, 0x25, 0x76, 0x55,
  0x56, 0x45, 0x77, 0x5E, 0x5D, 0x4A, 0x5C, 0x5B,
  0x70, 0x5B, 0x70, 0x5B, 0x5B, 0x5C, 0x4A, 0x49,
  0x47, 0x4E, 0x72, 0x72, 0x77, 0x32, 0x45, 0x32,
  0x46, 0x2B, 0x2B, 0x2B, 0x2B, 0x58, 0x46, 0x77,
  0x2E, 0x66, 0x48, 0x48, 0x4B, 0x4A, 0x5C, 0x5A,
  0x5B, 0x5C, 0x5C, 0x5C, 0x49, 0x49, 0x66, 0x77,
  0x29, 0x6B, 0x78, 0x3C, 0x3D, 0x21, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x21, 0x3D, 0x3F, 0x78, 0x79, 0x7A,
  0x5F, 0x4C, 0x48, 0x49, 0x64, 0x5C, 0x70, 0x70,
  0x70, 0x5B, 0x5C, 0x4A, 0x4B, 0x5D, 0x47, 0x59,
  0x57, 0x44, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x74,
  0x27, 0x27, 0x3B, 0x3B, 0x3B, 0x27, 0x55, 0x80,
  0x6F, 0x73, 0x46, 0x72, 0x48, 0x48, 0x4A, 0x4A,
  0x5C, 0x81, 0x81, 0x5C, 0x5C, 0x5C, 0x4A, 0x5D,
  0x47, 0x45, 0x82, 0x51, 0x75, 0x54, 0x3D, 0x20,
  0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x23, 0x22, 0x22, 0x22, 0x20,
  0x20, 0x21, 0x25, 0x26, 0x42, 0x83, 0x45, 0x6D,
  0x5D, 0x4B, 0x5A, 0x5C, 0x5C, 0x5C, 0x5B, 0x5C,
  0x5C, 0x4A, 0x49, 0x72, 0x5F, 0x58, 0x84, 0x7E,
  0x26, 0x26, 0x3F, 0x3F, 0x3F, 0x25, 0x25, 0x25,
  0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x54,
  0x3F, 0x3C, 0x75, 0x85, 0x50, 0x86, 0x2F, 0x4B,
  0x4A, 0x5C, 0x5A, 0x4A, 0x5B, 0x5C, 0x5B, 0x64,
  0x49, 0x47, 0x6C, 0x58, 0x6E, 0x40, 0x3F, 0x3D,
  0x20, 0x20, 0x87, 0x22, 0x20, 0x20, 0x20, 0x21,
  0x21, 0x20, 0x20, 0x22, 0x22, 0x23, 0x23, 0x20,
  0x21, 0x25, 0x3C, 0x3A, 0x88, 0x2C, 0x66, 0x4B,
  0x5C, 0x5C, 0x71, 0x5A, 0x5C, 0x5B, 0x4A, 0x4A,
  0x66, 0x4C, 0x5F, 0x7A, 0x89, 0x8A, 0x8B, 0x8C,
  0x25, 0x3D, 0x3D, 0x3D, 0x3D, 0x21, 0x21, 0x3D,
  0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x3D, 0x54, 0x3C, 0x75, 0x7F, 0x8D, 0x88,
  0x31, 0x5D, 0x4B, 0x4A, 0x71, 0x5B, 0x5B, 0x70,
  0x5C, 0x4A, 0x48, 0x47, 0x8E, 0x7D, 0x3B, 0x3D,
  0x3D, 0x20, 0x87, 0x20, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x23, 0x23, 0x23, 0x21,
  0x25, 0x75, 0x8F, 0x37, 0x47, 0x4B, 0x5C, 0x5C,
  0x5B, 0x5B, 0x71, 0x64, 0x4B, 0x5D, 0x4C, 0x2C,
  0x2B, 0x69, 0x90, 0x91, 0x92, 0x93, 0x3D, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x21, 0x20, 0x20, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x53, 0x3D, 0x3D, 0x25, 0x26, 0x85,
  0x82, 0x45, 0x5E, 0x48, 0x49, 0x5A, 0x5C, 0x5B,
  0x5B, 0x5B, 0x4A, 0x4B, 0x47, 0x8E, 0x7D, 0x26,
  0x3D, 0x20, 0x20, 0x20, 0x22, 0x20, 0x20, 0x20,
  0x21, 0x3D, 0x20, 0x22, 0x22, 0x22, 0x21, 0x21,
  0x94, 0x95, 0x73, 0x72, 0x4B, 0x5C, 0x70, 0x5B,
  0x5C, 0x49, 0x65, 0x4B, 0x6D, 0x72, 0x96, 0x97,
  0x26, 0x3F, 0x54, 0x25, 0x98, 0x3D, 0x20, 0x53,
  0x53, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x23, 0x23, 0x22, 0x20, 0x20, 0x3D, 0x25, 0x54,
  0x3B, 0x7E, 0x37, 0x2B, 0x5E, 0x49, 0x5C, 0x5C,
  0x5B, 0x70, 0x5B, 0x5B, 0x49, 0x47, 0x8E, 0x99,
  0x75, 0x25, 0x21, 0x20, 0x53, 0x22, 0x20, 0x22,
  0x20, 0x3D, 0x20, 0x20, 0x53, 0x20, 0x3D, 0x3F,
  0x63, 0x73, 0x6C, 0x5D, 0x5C, 0x70, 0x70, 0x5B,
  0x64, 0x4B, 0x66, 0x77, 0x45, 0x29, 0x42, 0x3F,
  0x54, 0x3D, 0x21, 0x20, 0x21, 0x21, 0x20, 0x53,
  0x22, 0x53, 0x20, 0x22, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20,
  0x22, 0x23, 0x22, 0x20, 0x21, 0x21, 0x21, 0x21,
  0x25, 0x54, 0x78, 0x84, 0x2B, 0x4E, 0x49, 0x64,
  0x5B, 0x70, 0x70, 0x81, 0x64, 0x4A, 0x4C, 0x58,
  0x80, 0x9A, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x21, 0x21, 0x3F, 0x8F,
  0x57, 0x77, 0x5D, 0x4A, 0x5C, 0x5B, 0x5B, 0x5C,
  0x49, 0x72, 0x59, 0x8E, 0x84, 0x41, 0x3C, 0x25,
  0x3D, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
  0x20, 0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x21, 0x24,
  0x21, 0x3D, 0x54, 0x52, 0x6E, 0x45, 0x5E, 0x4B,
  0x5B, 0x70, 0x5B, 0x70, 0x70, 0x4A, 0x5D, 0x4C,
  0x9B, 0x63, 0x3F, 0x3D, 0x21, 0x21, 0x20, 0x20,
  0x21, 0x3D, 0x20, 0x3D, 0x25, 0x3D, 0x40, 0x89,
  0x59, 0x48, 0x4A, 0x5A, 0x5C, 0x5C, 0x5C, 0x64,
  0x2C, 0x33, 0x4F, 0x42, 0x27, 0x3F, 0x25, 0x3D,
  0x20, 0x53, 0x53, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x20, 0x20, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x53, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x3E,
  0x22, 0x24, 0x3D, 0x54, 0x75, 0x99, 0x45, 0x4C,
  0x4A, 0x5B, 0x5B, 0x5B, 0x70, 0x5B, 0x4A, 0x48,
  0x2B, 0x44, 0x40, 0x3F, 0x21, 0x21, 0x21, 0x20,
  0x98, 0x87, 0x3D, 0x3D, 0x54, 0x3F, 0x51, 0x77,
  0x48, 0x4B, 0x5C, 0x5A, 0x5B, 0x4B, 0x49, 0x32,
  0x83, 0x42, 0x3C, 0x54, 0x25, 0x3D, 0x21, 0x20,
  0x20, 0x53, 0x53, 0x20, 0x20, 0x3D, 0x3D, 0x20,
  0x20, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x21, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x54, 0x25, 0x75, 0x7D, 0x2B,
  0x4C, 0x64, 0x5B, 0x5B, 0x70, 0x70, 0x5B, 0x65,
  0x6D, 0x69, 0x9C, 0x52, 0x3D, 0x21, 0x21, 0x20,
  0x9D, 0x9E, 0x9F, 0x54, 0x54, 0x42, 0xA0, 0x72,
  0x4A, 0x5C, 0x4A, 0x64, 0x6D, 0x30, 0x37, 0x85,
  0x3F, 0x25, 0x3D, 0x21, 0x21, 0x21, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x21, 0x53, 0x53, 0x20, 0x22, 0x20, 0x22, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x53,
  0x20, 0x20, 0x20, 0x3D, 0x3D, 0x3D, 0x26, 0x8F,
  0x2A, 0x72, 0x4B, 0x5C, 0x5B, 0x70, 0x5B, 0x5A,
  0x6D, 0x67, 0xA1, 0x92, 0x54, 0x3D, 0x20, 0x21,
  0xA2, 0xA3, 0x9F, 0x26, 0x3B, 0x4F, 0xA4, 0x4B,
  0x4A, 0x5A, 0x5A, 0x49, 0x72, 0x84, 0x7E, 0x54,
  0x25, 0x24, 0x53, 0x20, 0x53, 0x22, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x21, 0x22, 0x22, 0x22,
  0x53, 0x20, 0x20, 0x21, 0x21, 0x3D, 0x54, 0x94,
  0x56, 0x46, 0x6D, 0x4A, 0x70, 0x5B, 0x5C, 0x5C,
  0x66, 0x5F, 0xA5, 0xA6, 0x54, 0x3D, 0x21, 0x21,
  0x9F, 0x54, 0x54, 0x3B, 0x43, 0x2B, 0x47, 0x49,
  0x49, 0x4B, 0x48, 0x32, 0x82, 0x3B, 0x3C, 0x3D,
  0x21, 0x20, 0x20, 0x20, 0x53, 0x53, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x21, 0x53, 0x22, 0x21, 0x20, 0x21,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x20, 0x53, 0x20, 0x53, 0x22,
  0x21, 0x20, 0x21, 0x21, 0x21, 0x21, 0x3D, 0x54,
  0x80, 0x8E, 0x6D, 0x49, 0x71, 0x70, 0x5B, 0xA7,
  0xA8, 0x36, 0xA9, 0xAA, 0x93, 0x3D, 0x21, 0x21,
  0x54, 0x25, 0x75, 0x6B, 0x68, 0x6D, 0x48, 0x66,
  0x49, 0x6D, 0x45, 0x84, 0x75, 0x3F, 0x25, 0x21,
  0x20, 0x20, 0x20, 0x53, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x22, 0x22, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x3D, 0x3D, 0x25, 0x25, 0x25, 0x25, 0x3D, 0x21,
  0x21, 0x20, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x21,
  0x74, 0x50, 0x59, 0x66, 0x5A, 0x5B, 0x81, 0xAB,
  0xAC, 0xAD, 0xAE, 0xA6, 0x3F, 0x3D, 0x21, 0x20,
  0x3D, 0x3C, 0x79, 0x73, 0xAF, 0x47, 0x66, 0x4C,
  0x47, 0x2A, 0x51, 0x75, 0x21, 0x3D, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x53, 0x53, 0x22, 0x53,
  0x20, 0x20, 0x21, 0x21, 0x21, 0x3D, 0x25, 0x3F,
  0x3F, 0x3C, 0x26, 0x40, 0x40, 0x52, 0x26, 0x3F,
  0x54, 0x24, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x21,
  0x3F, 0x3B, 0x57, 0x2E, 0x4B, 0x5C, 0x5B, 0xA7,
  0xA8, 0xB0, 0x6B, 0xB1, 0x54, 0x3D, 0x21, 0x21,
  0x3F, 0x3B, 0x73, 0x59, 0x48, 0x49, 0x49, 0x5D,
  0x45, 0x84, 0x3C, 0x25, 0x21, 0x20, 0x22, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x53, 0x21, 0x3D, 0x25, 0x9F, 0xB2, 0xB3, 0xB4,
  0xB5, 0xB5, 0xB5, 0xB5, 0xB6, 0xB6, 0xB7, 0xB8,
  0xB9, 0x9E, 0xBA, 0x21, 0x21, 0x21, 0x20, 0x20,
  0x20, 0x53, 0x53, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x25, 0x3F, 0x29, 0x2C, 0x4B, 0x64, 0x4A, 0x4B,
  0x2C, 0x36, 0x7F, 0x52, 0x8C, 0x25, 0x3D, 0x3D,
  0x27, 0x85, 0x8E, 0x2E, 0x49, 0x4B, 0x49, 0x4C,
  0x35, 0x7E, 0x54, 0x98, 0x21, 0x20, 0x22, 0x3E,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x20, 0x22, 0x22, 0x22, 0x20,
  0x3D, 0x21, 0x25, 0x8C, 0x92, 0xAA, 0xBB, 0xBC,
  0xBD, 0xBC, 0xB7, 0xBE, 0x91, 0xBE, 0xB8, 0xBE,
  0xBF, 0xC0, 0x9E, 0x9D, 0xC1, 0x87, 0x53, 0x53,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x3D, 0x25, 0x80, 0x37, 0x48, 0x64, 0x4A, 0x5D,
  0x2F, 0x8E, 0x27, 0x40, 0xC2, 0x54, 0x3D, 0x21,
  0x28, 0x99, 0x77, 0x48, 0x5C, 0x4A, 0x49, 0x72,
  0xC3, 0x52, 0x21, 0x20, 0x23, 0x22, 0x23, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3D, 0x3F, 0x9A, 0xC4, 0xBC, 0xC5, 0xC5, 0xB5,
  0xAA, 0x95, 0xB1, 0x52, 0x3C, 0x8C, 0x76, 0xC6,
  0xC6, 0xC7, 0xC8, 0xC0, 0xC9, 0xC1, 0x21, 0x20,
  0x21, 0x20, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x3D, 0x3D, 0x55, 0x4F, 0x5E, 0x5D, 0x64, 0x4B,
  0x47, 0x68, 0x3B, 0x52, 0xB3, 0x54, 0x21, 0x3D,
  0x35, 0x8E, 0x72, 0x4B, 0x64, 0x4A, 0x49, 0x45,
  0x85, 0x3C, 0x21, 0x20, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x20, 0x20, 0x53, 0x21, 0x3D,
  0x3C, 0x40, 0xBC, 0xC5, 0xC5, 0xA6, 0xB1, 0x26,
  0x25, 0x25, 0x3D, 0x25, 0x3D, 0x21, 0x21, 0x21,
  0x25, 0x25, 0x98, 0xC1, 0xCA, 0x9D, 0xCB, 0xCC,
  0x3E, 0x20, 0x20, 0x20, 0x20, 0x23, 0x20, 0x22,
  0x24, 0x25, 0x26, 0x7D, 0xAF, 0x47, 0x49, 0x4D,
  0x2E, 0x2B, 0x27, 0x40, 0xCD, 0xC1, 0x3D, 0x21,
  0xA0, 0x59, 0x48, 0x49, 0x5C, 0x4A, 0x4D, 0x8D,
  0x27, 0x54, 0x21, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x21, 0x21, 0x21, 0x3D, 0x21, 0x93,
  0x8A, 0xAE, 0xCE, 0xB7, 0x9C, 0x75, 0x54, 0x3D,
  0x25, 0x3D, 0x3D, 0x20, 0x21, 0x20, 0x22, 0x20,
  0x20, 0x21, 0x21, 0x98, 0x61, 0xCF, 0x87, 0x53,
  0x53, 0x20, 0x53, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x22, 0x21, 0x3F, 0x6B, 0x5F, 0x48, 0x66, 0x66,
  0x4E, 0x58, 0x7F, 0x26, 0x8C, 0x25, 0x3D, 0x21,
  0xD0, 0x4C, 0x66, 0x49, 0x4A, 0x66, 0xD0, 0x27,
  0x3C, 0x3D, 0x20, 0x22, 0x20, 0x20, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x21, 0x21, 0x3D, 0x54, 0x92,
  0xB7, 0xA1, 0x7B, 0x9C, 0x3F, 0x54, 0x25, 0x25,
  0x21, 0x21, 0x20, 0x20, 0x22, 0x22, 0x23, 0x22,
  0x20, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x20,
  0x22, 0x20, 0x53, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x54, 0x42, 0x5F, 0x4C, 0x4B, 0x66,
  0x4C, 0x2B, 0x27, 0x3F, 0x54, 0x21, 0x21, 0x21,
  0x30, 0x6D, 0x49, 0x49, 0x5D, 0x30, 0x83, 0x3C,
  0x54, 0x20, 0x20, 0x22, 0x20, 0x20, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x3D, 0x54, 0xA2, 0xBE,
  0xCE, 0xCE, 0x55, 0x75, 0x25, 0x54, 0x3D, 0x21,
  0x21, 0x20, 0x22, 0x22, 0x23, 0x23, 0x23, 0x22,
  0x20, 0x21, 0x3D, 0x3D, 0x21, 0x20, 0x20, 0x21,
  0x21, 0x53, 0x22, 0x20, 0x20, 0x20, 0x20, 0x53,
  0x22, 0x20, 0x25, 0x8F, 0x46, 0x48, 0x4B, 0x48,
  0x5E, 0x58, 0x3B, 0x54, 0x3D, 0x21, 0x21, 0x20,
  0xD1, 0x5D, 0x49, 0x4B, 0x5E, 0x35, 0x3A, 0x25,
  0x3D, 0x20, 0x22, 0x23, 0x20, 0x20, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x21, 0x21, 0x3D, 0x3D, 0x52, 0xD2, 0xC5,
  0xB7, 0xD3, 0x3C, 0x25, 0x25, 0x21, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x20, 0x20, 0x21, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x53, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
  0x22, 0x20, 0x25, 0x7E, 0x60, 0x2E, 0x49, 0x4B,
  0x72, 0x2B, 0x51, 0x3C, 0x3D, 0x20, 0x20, 0x20,
  0xD4, 0x64, 0x49, 0x4C, 0x6C, 0xAD, 0x3B, 0x25,
  0x20, 0x22, 0x23, 0x23, 0x22, 0x20, 0x21, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x3D, 0x25, 0xD5, 0xD6, 0xC5,
  0xD2, 0x94, 0x25, 0x21, 0x25, 0x20, 0x21, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x20, 0x20,
  0x20, 0x87, 0x20, 0x20, 0x53, 0x20, 0x20, 0x22,
  0x22, 0x21, 0x25, 0x74, 0x8E, 0x2F, 0x49, 0x48,
  0x72, 0xD7, 0x79, 0xB1, 0x3D, 0x21, 0x20, 0x20,
  0xD8, 0x71, 0x4A, 0x48, 0xD7, 0x7E, 0x3C, 0x3D,
  0x20, 0x23, 0x23, 0x23, 0x22, 0x20, 0x21, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x22, 0x22, 0x23, 0x22,
  0x20, 0x20, 0x21, 0x25, 0x54, 0xAA, 0x90, 0xD9,
  0xDA, 0x3F, 0x25, 0x21, 0x21, 0x20, 0x22, 0x23,
  0x23, 0x22, 0x22, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x20,
  0xCF, 0xDB, 0x53, 0x20, 0x53, 0x20, 0x20, 0x20,
  0x22, 0x21, 0x25, 0x74, 0x8E, 0x2E, 0x49, 0x48,
  0x72, 0xD7, 0x7B, 0xB1, 0x3D, 0x21, 0x20, 0x22,
  0xD4, 0x71, 0x5D, 0x72, 0xD7, 0x7E, 0x25, 0x21,
  0x22, 0x22, 0x23, 0x23, 0x22, 0x22, 0x21, 0x20,
  0x20, 0x20, 0x21, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x21, 0x21, 0x54, 0x26, 0xBC, 0xCE, 0xDC,
  0xC6, 0x21, 0x3D, 0x21, 0x20, 0x22, 0x22, 0x23,
  0x23, 0x23, 0x22, 0x20, 0x21, 0x21, 0x21, 0x20,
  0x20, 0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20,
  0xDD, 0xC9, 0xCF, 0x20, 0x53, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x25, 0x7E, 0x2B, 0x66, 0x4B, 0x49,
  0xAF, 0x2B, 0x63, 0x3C, 0x21, 0x21, 0x22, 0x22,
  0xDE, 0x64, 0x48, 0x72, 0x68, 0x74, 0x21, 0x21,
  0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x20, 0x53, 0x20, 0x93, 0xDF, 0xB6, 0xCE, 0x63,
  0x93, 0x24, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x23, 0x22, 0x22, 0x20, 0x20, 0x21, 0x20,
  0x20, 0x3E, 0x53, 0x22, 0x22, 0x22, 0x20, 0x3E,
  0xDB, 0xE0, 0xCC, 0x20, 0x20, 0x53, 0x20, 0x20,
  0x22, 0x53, 0x54, 0x42, 0x6C, 0x49, 0x49, 0x4B,
  0x6C, 0xE1, 0x75, 0x54, 0x20, 0x3E, 0x22, 0x22,
  0xDE, 0x66, 0x48, 0x72, 0xE2, 0x40, 0x3D, 0x20,
  0x22, 0x22, 0x20, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x21, 0xC6, 0x95, 0xCE, 0xE2, 0x9C,
  0xCA, 0x22, 0x21, 0x20, 0x20, 0x21, 0x20, 0x20,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x53, 0x53, 0x20, 0x20,
  0x87, 0xCF, 0x53, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x53, 0x21, 0x3F, 0x6B, 0x6C, 0x48, 0x4A, 0x48,
  0x4E, 0xE2, 0x75, 0x25, 0x20, 0x22, 0x22, 0x23,
  0xE3, 0x4A, 0x4C, 0x59, 0x73, 0x75, 0x21, 0x20,
  0x22, 0x22, 0x20, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x21, 0xB2, 0xA6, 0xE4, 0xE2, 0x80,
  0xA2, 0x21, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x23,
  0x53, 0x21, 0x3F, 0x28, 0x5F, 0x48, 0x4B, 0x4C,
  0x45, 0x6F, 0x75, 0x54, 0x21, 0x53, 0x20, 0x22,
  0x4D, 0x4C, 0x4C, 0x59, 0x9B, 0x75, 0x3D, 0x20,
  0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x3D, 0x94, 0xD2, 0xA1, 0x7A, 0x79,
  0xC6, 0x3D, 0x21, 0x20, 0x21, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x23, 0x20, 0x20, 0x20, 0x98, 0x93,
  0x25, 0x3D, 0x21, 0x24, 0x24, 0x22, 0x22, 0x53,
  0x24, 0x3D, 0x3F, 0x6B, 0x77, 0x72, 0x5D, 0x4C,
  0x88, 0x42, 0x78, 0x93, 0x20, 0x53, 0x20, 0x20,
  0x4D, 0x48, 0x4C, 0x32, 0x29, 0x75, 0x25, 0x20,
  0x22, 0x22, 0x20, 0x21, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x3D, 0x26, 0xDA, 0xE5, 0xE1, 0x89,
  0x8B, 0x25, 0x3D, 0x21, 0x20, 0x21, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x20, 0x53, 0x20, 0x20, 0x54, 0xE6, 0xE7,
  0x93, 0x3D, 0x20, 0x21, 0x53, 0x20, 0x22, 0x20,
  0x21, 0x25, 0x3B, 0x99, 0x5F, 0x72, 0x4C, 0x32,
  0x8D, 0x74, 0x41, 0x94, 0x21, 0x21, 0x20, 0x21,
  0xE3, 0x48, 0x4C, 0x2C, 0x38, 0x26, 0x3D, 0x20,
  0x22, 0x23, 0x22, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x54, 0x3C, 0x7E, 0xA1, 0xE8, 0xE2,
  0x41, 0x3F, 0x3D, 0x21, 0x20, 0x53, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x21, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x20, 0x61, 0xE7, 0xE9, 0xC7,
  0x93, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x3D, 0x26, 0xDF, 0x89, 0x67, 0x6C, 0x46, 0x83,
  0x85, 0x3B, 0x9A, 0x93, 0x21, 0x21, 0x21, 0x21,
  0x2D, 0x47, 0x72, 0x45, 0x8D, 0x26, 0x25, 0x20,
  0x22, 0x23, 0x22, 0x22, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x25, 0x3C, 0x78, 0xE2, 0xD7, 0x68,
  0x6B, 0x26, 0x25, 0x21, 0x20, 0x22, 0x22, 0x22,
  0x20, 0x21, 0x21, 0x21, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x21, 0xC1, 0xEA, 0xE9, 0xA3,
  0xC1, 0x21, 0x21, 0x21, 0x20, 0x20, 0x53, 0x21,
  0x26, 0x9C, 0x44, 0x7A, 0xEB, 0x5F, 0x8E, 0x3A,
  0x27, 0x52, 0x93, 0x54, 0x21, 0x20, 0x21, 0x21,
  0x2C, 0x47, 0x4C, 0xA4, 0x50, 0x3C, 0x25, 0x20,
  0x22, 0x22, 0x23, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22, 0x21,
  0x21, 0x20, 0x25, 0x54, 0x75, 0x89, 0x68, 0xEC,
  0x38, 0x7F, 0x3F, 0x3D, 0x20, 0x23, 0x22, 0x23,
  0x22, 0x20, 0x20, 0x21, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3D, 0x20, 0x87, 0xC9, 0x9E, 0xCC,
  0x24, 0x21, 0x21, 0x3D, 0x20, 0x21, 0x3D, 0x3D,
  0xDF, 0x56, 0x69, 0x68, 0x67, 0x2B, 0x37, 0x3B,
  0x62, 0x94, 0x9F, 0x21, 0x20, 0x20, 0x21, 0x20,
  0x31, 0x6D, 0x47, 0xD0, 0x35, 0x26, 0x25, 0x20,
  0x22, 0x22, 0x23, 0x22, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3D, 0x21, 0x54, 0x3F, 0x7C, 0x68, 0xEB,
  0x33, 0x8D, 0x3C, 0x25, 0x20, 0x23, 0x23, 0x23,
  0x23, 0x22, 0x20, 0x20, 0x21, 0x24, 0x24, 0x24,
  0x3D, 0x3D, 0x21, 0x20, 0x53, 0x3E, 0x3E, 0x23,
  0x22, 0xCF, 0x21, 0x20, 0x21, 0x21, 0x3D, 0x3F,
  0x7C, 0x69, 0xED, 0xEC, 0x58, 0x57, 0x7D, 0x3C,
  0x8B, 0xCD, 0x61, 0x20, 0x21, 0x20, 0x20, 0x20,
  0x2C, 0x5E, 0x4C, 0x31, 0x88, 0x75, 0x54, 0x20,
  0x22, 0x23, 0x22, 0x22, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x21, 0x21, 0x25, 0x26, 0x7C, 0x7A, 0x68,
  0x6C, 0x5F, 0x7E, 0x3C, 0x87, 0x3E, 0x23, 0x23,
  0x23, 0x22, 0x21, 0x3D, 0xCB, 0xEE, 0xEF, 0xF0,
  0xF1, 0xEA, 0x9F, 0x20, 0x20, 0x23, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x3D, 0x54, 0x3F, 0x3F, 0x75,
  0x57, 0x68, 0xEC, 0x2A, 0x50, 0x51, 0x78, 0x3F,
  0x76, 0xCA, 0x87, 0x20, 0x22, 0x20, 0x20, 0x20,
  0xD0, 0x4E, 0x48, 0x72, 0x8E, 0x27, 0x54, 0x20,
  0x20, 0x23, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x21, 0x21, 0x54, 0x75, 0x6B, 0x44, 0x2B,
  0x4E, 0x32, 0x6F, 0x95, 0x3D, 0x3E, 0xF2, 0x23,
  0x22, 0x22, 0x20, 0x20, 0x3D, 0xC1, 0xCB, 0xCA,
  0x9F, 0x25, 0x3D, 0x20, 0x20, 0x53, 0x23, 0x22,
  0x22, 0x21, 0x3D, 0x25, 0x25, 0x54, 0x74, 0x89,
  0x69, 0xEC, 0xE1, 0x56, 0x7F, 0x3C, 0x3C, 0x3C,
  0xC1, 0x61, 0x22, 0x20, 0x22, 0x20, 0x22, 0x20,
  0x30, 0x4E, 0x47, 0x47, 0x32, 0x7F, 0x3F, 0x3D,
  0x22, 0x22, 0x23, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x22, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x3D, 0x76, 0xDA, 0x8F, 0x42, 0x29,
  0x45, 0x6C, 0xE8, 0x7C, 0x9A, 0x3D, 0x3D, 0x53,
  0x53, 0x53, 0x3D, 0x21, 0x21, 0x3D, 0x25, 0x25,
  0x25, 0x3D, 0x3D, 0x3D, 0x21, 0x20, 0x20, 0x21,
  0x21, 0x21, 0x3D, 0x3C, 0x40, 0x8F, 0x56, 0xA1,
  0xF3, 0xF4, 0xA1, 0xD3, 0x75, 0x54, 0x54, 0x54,
  0x24, 0x53, 0x22, 0x22, 0x22, 0x22, 0x20, 0x22,
  0x30, 0x77, 0x4C, 0x4C, 0x59, 0xAD, 0x26, 0x3D,
  0x20, 0x23, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x22,
  0x22, 0x20, 0x21, 0xA2, 0xF5, 0xA6, 0x9C, 0x51,
  0x36, 0xA4, 0xEC, 0x7A, 0x89, 0x78, 0x26, 0x3D,
  0x25, 0x3D, 0x3D, 0x21, 0x21, 0x20, 0x21, 0x20,
  0x3D, 0x20, 0x21, 0x20, 0x21, 0x3D, 0x3D, 0x25,
  0x3F, 0x3F, 0x26, 0x27, 0x7D, 0xF6, 0xE8, 0xF7,
  0xE5, 0xD9, 0xD3, 0xB1, 0x3C, 0x25, 0x3D, 0x20,
  0x53, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x86, 0x72, 0x4C, 0x5D, 0x72, 0x8D, 0x40, 0x21,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x53, 0x21, 0x54, 0xB2, 0xB4, 0xD3, 0x28,
  0x50, 0xF8, 0x96, 0x68, 0xF3, 0x73, 0x89, 0x3B,
  0x54, 0x25, 0x3D, 0x3D, 0x3D, 0x21, 0x21, 0x3D,
  0x3D, 0x3D, 0x21, 0x3D, 0x3D, 0x3D, 0x25, 0x3F,
  0x75, 0x6B, 0xF9, 0xA1, 0xE1, 0xEC, 0x68, 0x57,
  0xD3, 0xC2, 0x52, 0x54, 0x3D, 0x21, 0x21, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0xA0, 0x4E, 0x48, 0x47, 0x72, 0x83, 0x55, 0x3D,
  0x20, 0x23, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22,
  0x22, 0x3E, 0x20, 0x21, 0x25, 0xDA, 0xA6, 0x8A,
  0x29, 0x73, 0x36, 0x34, 0x6C, 0x5E, 0x59, 0x58,
  0x6E, 0x8F, 0x75, 0x54, 0x3D, 0x21, 0x21, 0x87,
  0x20, 0x20, 0x3D, 0x3D, 0x25, 0x3F, 0x78, 0x28,
  0xF6, 0x58, 0xD7, 0xD7, 0xD7, 0xD7, 0x57, 0x85,
  0x26, 0x25, 0x3D, 0x21, 0x20, 0x21, 0x53, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0xA0, 0x72, 0x4C, 0x66, 0x5E, 0x96, 0x63, 0x25,
  0x53, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x61, 0x21, 0x76, 0x52, 0x40,
  0x95, 0xAE, 0x82, 0x37, 0x88, 0x59, 0x6C, 0x59,
  0x45, 0x56, 0x8A, 0x9C, 0xDA, 0xCD, 0x93, 0x93,
  0xA2, 0xA2, 0xCD, 0xC2, 0xDF, 0x95, 0x7C, 0xF6,
  0x69, 0xD7, 0xF3, 0xE1, 0x89, 0x84, 0x28, 0x26,
  0x25, 0x3D, 0x3D, 0x3D, 0x21, 0x53, 0x3E, 0x20,
  0x23, 0x20, 0x22, 0x53, 0x20, 0x20, 0x3D, 0x20,
  0x82, 0x2B, 0x5F, 0x72, 0x4C, 0xA4, 0x29, 0x3F,
  0x25, 0x21, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 0x3D,
  0x8C, 0xDA, 0xDC, 0xAE, 0x29, 0x29, 0x32, 0xAF,
  0x5F, 0x6C, 0xD7, 0x7A, 0x89, 0x6F, 0x6E, 0x8A,
  0x6E, 0x6E, 0x7C, 0xF9, 0xA1, 0xF4, 0xA5, 0xFA,
  0xFA, 0xE5, 0xB5, 0xDC, 0xD5, 0x52, 0x54, 0x3D,
  0x21, 0x20, 0x22, 0x20, 0x53, 0x22, 0x22, 0x53,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x51, 0x9B, 0x46, 0x6C, 0x5E, 0x31, 0x33, 0x3B,
  0x54, 0x21, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x21, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x3D, 0x3D, 0x3C, 0xDF, 0x7B, 0x6A, 0x73, 0x73,
  0x59, 0x46, 0x5F, 0x6C, 0xEC, 0xEC, 0xF3, 0xE8,
  0xE1, 0x68, 0xD7, 0xF3, 0xF7, 0xF4, 0xA5, 0xE4,
  0x91, 0xB3, 0x8B, 0x3F, 0x3D, 0x21, 0x3D, 0x3D,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3B, 0x6E, 0x5F, 0x6C, 0x4C, 0x4C, 0x2C, 0xF8,
  0x3B, 0x3F, 0x3D, 0x20, 0x20, 0x20, 0x21, 0x20,
  0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x3D, 0x3F, 0x26, 0x74, 0x84, 0xE2,
  0x73, 0x29, 0x50, 0xC3, 0xC3, 0x28, 0x6E, 0x43,
  0x6E, 0x6E, 0x7D, 0x6B, 0x9C, 0x55, 0x40, 0x26,
  0x3F, 0x54, 0x3D, 0x21, 0x21, 0x21, 0x20, 0x20,
  0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x75, 0x51, 0x68, 0x6C, 0x4B, 0x5D, 0x66, 0x86,
  0x38, 0x42, 0x9A, 0x54, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21,
  0x21, 0x20, 0x21, 0x3D, 0x25, 0x54, 0x52, 0xDF,
  0x63, 0x9C, 0x6B, 0x63, 0x8A, 0xD3, 0x79, 0xD3,
  0x8A, 0x9C, 0x55, 0x40, 0x75, 0x3C, 0x54, 0x25,
  0x3D, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3F, 0x75, 0x73, 0x5F, 0x4B, 0x4B, 0x4A, 0x49,
  0x4E, 0x2A, 0x43, 0x62, 0x25, 0x20, 0x20, 0x20,
  0x53, 0x22, 0x20, 0x22, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x21, 0x21, 0x25, 0x25, 0x25,
  0x3C, 0x52, 0xDA, 0xA6, 0xAA, 0xB4, 0xC4, 0xF5,
  0x92, 0xFB, 0x94, 0x3C, 0x54, 0x25, 0x3D, 0x3D,
  0x3D, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3E,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x25, 0x3F, 0x6E, 0x45, 0x6D, 0x4A, 0x64, 0x4A,
  0x5D, 0x4C, 0x7A, 0xA6, 0x3C, 0x3D, 0x21, 0x20,
  0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x20, 0x20,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x53, 0x21, 0x20, 0x20, 0x20, 0x3D, 0x3D,
  0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x24, 0x25, 0x25,
  0x54, 0x25, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x53, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x3D, 0x25, 0x41, 0x6F, 0x4C, 0x49, 0x81, 0x5B,
  0x4A, 0x5D, 0x77, 0x56, 0x40, 0x3D, 0x21, 0x20,
  0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x53, 0x53, 0x20, 0x20,
  0x20, 0x21, 0x21, 0x21, 0x3D, 0x21, 0x3D, 0x3D,
  0x20, 0x20, 0x21, 0x20, 0x21, 0x21, 0x20, 0x21,
  0x53, 0x22, 0x20, 0x20, 0x22, 0x22, 0x22, 0x23,
  0x22, 0x20, 0x20, 0x22, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x3D, 0x3C, 0x42, 0x77, 0x48, 0x5C, 0x5C,
  0x5C, 0x4A, 0x47, 0x44, 0x78, 0x54, 0x3D, 0x21,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x20,
  0x22, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x21, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x20, 0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x53, 0x21, 0x54, 0x41, 0x6F, 0x5E, 0x4B, 0x5A,
  0x4A, 0x4A, 0x47, 0x34, 0x7E, 0x54, 0x21, 0x21,
  0x21, 0x20, 0x22, 0x22, 0x22, 0x23, 0x22, 0x20,
  0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x3D, 0x3C, 0x42, 0x2B, 0x4C, 0x4A,
  0x5A, 0x4A, 0x4B, 0x30, 0x7D, 0x3F, 0x3D, 0x53,
  0x53, 0x22, 0x20, 0x22, 0x22, 0x20, 0x22, 0x22,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x20, 0x20, 0x22, 0x23,
  0x23, 0x22, 0x22, 0x22, 0x21, 0x20, 0x21, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x20, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x20, 0x3D, 0x26, 0x43, 0x45, 0x47,
  0x49, 0x4B, 0x66, 0x4E, 0x60, 0x74, 0x3F, 0x21,
  0x21, 0x20, 0x22, 0x53, 0x22, 0x20, 0x22, 0x22,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x21, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x22, 0x22, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x3D, 0x54, 0xDA, 0x82, 0x77,
  0x5D, 0x5D, 0x4D, 0x2E, 0x67, 0x7D, 0x40, 0x3D,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x22,
  0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x22, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x21, 0x25, 0x8C, 0x42, 0x69,
  0x31, 0x5D, 0x49, 0x47, 0x6C, 0x83, 0x42, 0x54,
  0x3D, 0x21, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x53, 0x21, 0x25, 0x26, 0x56,
  0x45, 0x4C, 0x5D, 0x48, 0x5E, 0xA4, 0x4F, 0x3F,
  0x3D, 0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x53, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x22, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x21, 0x3D, 0x3D, 0x74,
  0x37, 0xD0, 0x48, 0x4B, 0x5D, 0x72, 0xA4, 0x7F,
  0x3F, 0x3D, 0x21, 0x20, 0x21, 0x21, 0x53, 0x53,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x20, 0x22, 0x20, 0x22, 0x20,
  0x20, 0x21, 0x20, 0x20, 0x53, 0x25, 0x21, 0x3F,
  0x51, 0x8D, 0x4E, 0x47, 0x4E, 0x5E, 0x6C, 0x9B,
  0x78, 0x3C, 0x3D, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x53, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x20, 0x21, 0x21,
  0x26, 0x74, 0xF6, 0x58, 0xAF, 0x31, 0x47, 0x6C,
  0x82, 0x7E, 0x54, 0x25, 0x20, 0x23, 0x23, 0x23,
  0x20, 0x20, 0x21, 0x21, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x53, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x21,
  0x3D, 0x3F, 0x9C, 0x7C, 0xEC, 0xFC, 0x6D, 0x47,
  0x2C, 0x96, 0x8F, 0x8C, 0x20, 0x3E, 0x23, 0x23,
  0x22, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x21,
  0x21, 0x3D, 0x26, 0x7E, 0x89, 0xEC, 0x67, 0x72,
  0x6C, 0x6C, 0x44, 0x7E, 0x25, 0x21, 0x20, 0x23,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x20, 0x20, 0x21, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x21, 0x21, 0x3D, 0x3C, 0x27, 0x29, 0x2A, 0x67,
  0x5E, 0x6C, 0x59, 0x29, 0x74, 0x3C, 0x3D, 0x21,
  0x20, 0x22, 0x23, 0x22, 0x22, 0x20, 0x20, 0x21,
  0x21, 0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x54, 0x54, 0x74, 0x6E, 0xA9,
  0x5F, 0x67, 0x5E, 0x32, 0x38, 0xAD, 0x75, 0x54,
  0x3D, 0x20, 0x23, 0x23, 0x3E, 0x21, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x21, 0x20, 0x20, 0x25, 0x3D, 0x3F, 0x52, 0x8A,
  0x7A, 0xEC, 0xFC, 0x4E, 0x2F, 0x86, 0x35, 0x85,
  0x3F, 0x3D, 0x20, 0x20, 0x22, 0x22, 0x21, 0x21,
  0x20, 0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x3D, 0x21, 0x25, 0x3D, 0x3C,
  0xA6, 0xD9, 0xE8, 0x6C, 0x6D, 0x4B, 0x66, 0xA4,
  0xC3, 0x75, 0x25, 0x20, 0x21, 0x20, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x22, 0x22,
  0x22, 0x20, 0x21, 0x20, 0x21, 0x3D, 0x21, 0x3D,
  0x25, 0x8C, 0xD3, 0x2A, 0x5E, 0x47, 0x48, 0x47,
  0x8E, 0x6E, 0x52, 0x54, 0x3D, 0x21, 0x21, 0x21,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21,
  0x21, 0x25, 0x52, 0x63, 0x9B, 0x59, 0x4C, 0x5E,
  0x77, 0x8E, 0x82, 0x74, 0x3F, 0x25, 0x54, 0x3D,
  0x21, 0x20, 0x21, 0x21, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x21, 0x25, 0x3C, 0x55, 0x43, 0x60, 0x67,
  0x5F, 0x68, 0x60, 0x43, 0x7E, 0x62, 0x52, 0x54,
  0x25, 0x21, 0x20, 0x20, 0x20, 0x21, 0x3D, 0x21,
  0x20, 0x20, 0x21, 0x22, 0x22, 0x53, 0x23, 0x23,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x20, 0x20,
  0x20, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x20, 0x21, 0x21, 0x21, 0x54, 0x94, 0xDF, 0xD3,
  0xE2, 0xA5, 0xF7, 0xF3, 0xA9, 0xA9, 0x89, 0x9C,
  0x8C, 0x25, 0x21, 0x21, 0x21, 0x20, 0x21, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x20, 0x21, 0x3D, 0x3D, 0x20, 0x21, 0x25, 0x3F,
  0x9A, 0x63, 0x89, 0x7A, 0xF4, 0xF7, 0xF4, 0xE5,
  0xD2, 0x9A, 0x3F, 0x54, 0x25, 0x3D, 0x3D, 0x3D,
  0x3D, 0x21, 0x21, 0x20, 0x20, 0x20, 0x22, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x21, 0x20, 0x20, 0x20, 0x22, 0x20, 0x21,
  0x54, 0x94, 0x62, 0x9C, 0xD3, 0x89, 0xCE, 0xA5,
  0xE5, 0x7B, 0x9C, 0x62, 0x3C, 0x25, 0x25, 0x3D,
  0x25, 0x3D, 0x21, 0x21, 0x21, 0x21, 0x20, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22,
  0x21, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x21, 0x25, 0x3F, 0x40, 0xDF, 0xDC, 0xE4,
  0xF9, 0x89, 0xAE, 0x79, 0x6B, 0x55, 0x78, 0x52,
  0x8C, 0x93, 0x54, 0x25, 0x21, 0x21, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x21, 0x20, 0x20, 0x20, 0x22, 0x20, 0x22,
  0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x20, 0x20,
  0x24, 0x98, 0x3D, 0x21, 0x3D, 0x3D, 0x25, 0x26,
  0x85, 0x39, 0x9B, 0x7A, 0xA1, 0xCE, 0x90, 0xD6,
  0xF5, 0xD5, 0xB2, 0x93, 0xC1, 0x3D, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x22, 0x20, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x20, 0x20, 0x20, 0x20, 0x20, 0x22, 0x22,
  0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x20,
  0x20, 0x98, 0x21, 0x20, 0x3D, 0x25, 0x54, 0x26,
  0x7F, 0xB0, 0x9B, 0x7A, 0x69, 0xA1, 0xCE, 0xD6,
  0xD3, 0xB3, 0xCD, 0x93, 0x25, 0x3D, 0x21, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
};

#endif

#ifdef INCLUDE_LINUX_LOGOBW

unsigned char linux_logo_bw[] __initdata = {
  0x32, 0x35, 0x35, 0x0A, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC,
  0xFE, 0xF4, 0xFB, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD,
  0xFC, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xEC,
  0xFE, 0xFB, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4,
  0xFB, 0xFE, 0xF4, 0xFB, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF4, 0xED, 0xF0, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4,
  0xFB, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFE,
  0xE4, 0xF1, 0xFC, 0xC4, 0xD7, 0xFD, 0xAB, 0xC6,
  0xDF, 0x84, 0xA1, 0xC3, 0x5D, 0x7D, 0xAC, 0x3C,
  0x60, 0xA0, 0x2D, 0x50, 0xB5, 0x2B, 0x54, 0xBF,
  0x2C, 0x56, 0xBF, 0x2C, 0x56, 0xAC, 0x1D, 0x4A,
  0xB4, 0x25, 0x52, 0xBD, 0x35, 0x5E, 0xBD, 0x35,
  0x5E, 0xAD, 0x25, 0x4F, 0xAD, 0x2C, 0x55, 0xBF,
  0x43, 0x6A, 0xDA, 0x5E, 0x84, 0xDF, 0x68, 0x8E,
  0xD4, 0x5D, 0x83, 0xC6, 0x54, 0x78, 0xD4, 0x65,
  0x89, 0xEC, 0x7E, 0xA0, 0xF7, 0x92, 0xB1, 0xFD,
  0xB4, 0xCC, 0xFD, 0xCC, 0xDE, 0xFE, 0xE4, 0xF1,
  0xFE, 0xEC, 0xF7, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4,
  0xFB, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFE,
  0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFD, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF5, 0xFD, 0xFC, 0xEC, 0xFE, 0xFB, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xEC, 0xFE,
  0xFB, 0xEC, 0xFE, 0xFB, 0xF5, 0xFD, 0xFC, 0xF5,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB,
  0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xF5,
  0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4,
  0xFB, 0xFE, 0xF4, 0xFB, 0xF4, 0xED, 0xF0, 0xEC,
  0xF4, 0xF3, 0xEC, 0xF4, 0xF3, 0xF4, 0xED, 0xF0,
  0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFE, 0xEC,
  0xF7, 0xFE, 0xD4, 0xE5, 0xF2, 0xB3, 0xCA, 0xE8,
  0xA4, 0xB9, 0xE2, 0x8D, 0xA7, 0xC4, 0x6B, 0x87,
  0xB8, 0x54, 0x73, 0xAF, 0x34, 0x5A, 0x9C, 0x24,
  0x48, 0xA4, 0x13, 0x3F, 0xA4, 0x0C, 0x3B, 0xAE,
  0x0C, 0x3D, 0xAF, 0x04, 0x39, 0xA4, 0x04, 0x34,
  0xA4, 0x04, 0x34, 0xAE, 0x0C, 0x3D, 0xA4, 0x0C,
  0x3B, 0x9C, 0x0C, 0x39, 0xB9, 0x1D, 0x4F, 0xB4,
  0x25, 0x52, 0xBD, 0x35, 0x5E, 0xBD, 0x35, 0x5E,
  0xAD, 0x25, 0x4F, 0xA3, 0x1C, 0x46, 0xB5, 0x2B,
  0x54, 0xBF, 0x43, 0x6A, 0xD7, 0x6D, 0x8D, 0xE1,
  0x78, 0x99, 0xEE, 0x94, 0xB2, 0xE8, 0xA4, 0xB9,
  0xF2, 0xBB, 0xCD, 0xFE, 0xD4, 0xE5, 0xFE, 0xEC,
  0xF7, 0xFE, 0xEC, 0xF7, 0xFE, 0xEC, 0xF7, 0xFE,
  0xF4, 0xFB, 0xFD, 0xFD, 0xFC, 0xFE, 0xEC, 0xF7,
  0xFE, 0xF4, 0xFB, 0xFE, 0xEC, 0xF7, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD,
  0xFC, 0xF5, 0xF4, 0xF5, 0xFE, 0xF4, 0xFB, 0xFD,
  0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFD, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xEC, 0xFE,
  0xFB, 0xEC, 0xFE, 0xFB, 0xFD, 0xFD, 0xFC, 0xF5,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC,
  0xFE, 0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xF5,
  0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF5, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFE,
  0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4, 0xFB,
  0xFE, 0xF4, 0xFB, 0xFD, 0xDC, 0xEB, 0xF2, 0xBB,
  0xCD, 0xE3, 0x9C, 0xB4, 0xBA, 0x5C, 0x7D, 0xB1,
  0x4C, 0x6E, 0xA1, 0x34, 0x57, 0xA3, 0x24, 0x4C,
  0xA3, 0x1C, 0x46, 0x9C, 0x0C, 0x39, 0xA4, 0x0C,
  0x3B, 0xAE, 0x0C, 0x3D, 0xC1, 0x0B, 0x44, 0xC1,
  0x0B, 0x44, 0xC2, 0x04, 0x3C, 0xC1, 0x0B, 0x44,
  0xC1, 0x0B, 0x44, 0xC1, 0x0B, 0x44, 0xB8, 0x03,
  0x39, 0xAE, 0x0C, 0x3D, 0xAE, 0x0C, 0x3D, 0xAF,
  0x04, 0x39, 0xAE, 0x0C, 0x3D, 0xAE, 0x0C, 0x3D,
  0xA4, 0x04, 0x34, 0x9D, 0x03, 0x33, 0xA4, 0x04,
  0x34, 0xAE, 0x0C, 0x3D, 0x9C, 0x0C, 0x39, 0x94,
  0x0C, 0x37, 0x94, 0x1C, 0x41, 0xA5, 0x3C, 0x5C,
  0xC4, 0x6B, 0x87, 0xE3, 0x9C, 0xB4, 0xFD, 0xB4,
  0xCC, 0xFD, 0xCC, 0xDE, 0xFD, 0xCC, 0xDE, 0xFD,
  0xCC, 0xDE, 0xFD, 0xCC, 0xDE, 0xFE, 0xD4, 0xE5,
  0xFE, 0xEC, 0xF7, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4,
  0xFB, 0xED, 0xE3, 0xE6, 0xFE, 0xF4, 0xFB, 0xFE,
  0xF4, 0xFB, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xFD, 0xFD,
  0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFE, 0xF4, 0xFB, 0xFD, 0xFD, 0xFC,
  0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD,
  0xFC, 0xF5, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC,
  0xFE, 0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4,
  0xFB, 0xFD, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFD,
  0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xF5, 0xFD, 0xFC,
  0xF5, 0xFD, 0xFC, 0xFD, 0xFD, 0xFC, 0xFE, 0xF4,
  0xFB, 0xFE, 0xF4, 0xFB, 0xFE, 0xF4, 0xFB, 0xFE,
  0xF4, 0xFB, 0xFE, 0xE4, 0xF1, 0xFD, 0xCC, 0xDE,
  0xE9, 0xAA, 0xC2, 0xD0, 0x84, 0x9E, 0xB8, 0x54,
  0x73, 0xA1, 0x34, 0x57, 0xA3, 0x24, 0x4C, 0x9C,
};

#endif

#ifdef INCLUDE_LINUX_LOGO16

unsigned char linux_logo16_red[] __initdata = {
  0x00, 0x90, 0xFE, 0xFA, 0xF2, 0xD6, 0xC6, 0xAA,
  0xA4, 0xBA, 0xE2, 0x9A, 0x86, 0xA2, 0xBE, 0xC6
};

unsigned char linux_logo16_green[] __initdata = {
  0x00, 0x90, 0xFA, 0xD2, 0xB2, 0x74, 0x56, 0x4E,
  0x30, 0x0A, 0x92, 0x12, 0x4A, 0x6A, 0x8E, 0xAE
};

unsigned char linux_logo16_blue[] __initdata = {
  0x00, 0x90, 0xFC, 0xE4, 0xCC, 0x93, 0x7C, 0x6C,
  0x58, 0x3C, 0xAC, 0x3C, 0x64, 0x84, 0x9C, 0xB4
};

unsigned char linux_logo16[] __initdata = {
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x34, 0x56, 0x78,
  0x88, 0x89, 0x88, 0x88, 0x88, 0x55, 0x66, 0x55,
  0xA4, 0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x33, 0x4A, 0xA5, 0x68, 0xBB,
  0x99, 0x9B, 0x99, 0x99, 0x98, 0x88, 0x8B, 0x86,
  0x55, 0xA4, 0x43, 0x32, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x32, 0x23, 0x3A, 0x57, 0x88, 0xBB, 0xB9,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xB9,
  0xBB, 0xB8, 0x5A, 0x43, 0x33, 0x33, 0x32, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x22, 0x33, 0x45, 0x68, 0xBB, 0xBB, 0x99, 0x99,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x9B, 0xBB, 0xB8, 0x88, 0x88, 0x85, 0x43, 0x32,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x23, 0x45, 0x78, 0xBB, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0xB9, 0xB9,
  0x99, 0x9B, 0xBB, 0xB9, 0xBB, 0xBB, 0x8C, 0x54,
  0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x4A, 0x6C, 0x8B, 0xB9, 0x99, 0x99, 0x99, 0x99,
  0x99, 0x99, 0x99, 0x99, 0x99, 0xB9, 0xB9, 0xB9,
  0xB9, 0x99, 0x99, 0x99, 0x99, 0xBB, 0xBB, 0x85,
  0xA3, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x3A,
  0x78, 0xBB, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x9B, 0xBB, 0xB8, 0x88, 0xB8, 0x88, 0x8B, 0x8B,
  0xBB, 0x9B, 0x99, 0x99, 0x99, 0x99, 0x9B, 0xB8,
  0x75, 0x43, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x34, 0x58,
  0x8B, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98,
  0x76, 0x75, 0x5A, 0xA4, 0x44, 0x44, 0x44, 0xAA,
  0x6C, 0xBB, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x9B,
  0xB8, 0x6A, 0x43, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0xA7, 0x8B,
  0xB9, 0x99, 0x99, 0x99, 0x99, 0x9B, 0xB8, 0xDA,
  0x33, 0x33, 0x32, 0x33, 0x23, 0x32, 0x32, 0x33,
  0x33, 0x3A, 0x57, 0x99, 0x99, 0x99, 0x99, 0x99,
  0x9B, 0xB8, 0x54, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x3A, 0x68, 0xB9,
  0x99, 0x99, 0x99, 0x99, 0x9B, 0xBB, 0xD5, 0x43,
  0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x33, 0x44, 0x57, 0xB9, 0x99, 0x99, 0x99,
  0x99, 0xBB, 0x75, 0x43, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x24, 0xA7, 0x99, 0x99,
  0x99, 0x99, 0x99, 0xB8, 0x88, 0xCD, 0xE3, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x44, 0x68, 0xBB, 0x99, 0x99,
  0x99, 0x99, 0xB7, 0x53, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x45, 0x7B, 0x99, 0x99,
  0x99, 0x99, 0xBB, 0x85, 0x33, 0x33, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x4A, 0x78, 0x99, 0x99,
  0x99, 0x99, 0x9B, 0x75, 0x33, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0xE7, 0xBB, 0x99, 0x99,
  0x99, 0xBB, 0xB6, 0xA3, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x4D, 0x8B, 0x99,
  0x99, 0x99, 0x99, 0xB8, 0x54, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x3A, 0x7B, 0xB9, 0x99, 0x99,
  0x9B, 0x8C, 0x54, 0x33, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x34, 0x68, 0xB9,
  0x99, 0x99, 0x99, 0xBB, 0x7D, 0x32, 0x22, 0x22,
  0x22, 0x22, 0x33, 0x46, 0x89, 0x99, 0x99, 0x99,
  0x88, 0x55, 0x43, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x45, 0x8B,
  0x99, 0x99, 0x99, 0x9B, 0x87, 0x43, 0x22, 0x22,
  0x32, 0x32, 0x23, 0xEB, 0xBB, 0x99, 0x99, 0x98,
  0x6A, 0x33, 0x32, 0x22, 0x22, 0x22, 0x23, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x24, 0x58,
  0x99, 0x99, 0x99, 0x99, 0xB8, 0xA4, 0x22, 0x22,
  0xFF, 0x33, 0x3A, 0x6B, 0x99, 0x99, 0xB8, 0x6A,
  0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x3A,
  0x8B, 0x99, 0x99, 0x99, 0xBB, 0x8E, 0x32, 0x22,
  0x3F, 0x33, 0x45, 0x89, 0x99, 0x99, 0xB5, 0x43,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x34,
  0x7B, 0x99, 0x99, 0x99, 0xBB, 0x8D, 0x33, 0x22,
  0x33, 0x34, 0x58, 0xB9, 0x99, 0xBB, 0x64, 0x32,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0xE8, 0xB9, 0x99, 0x98, 0x67, 0x8D, 0x32, 0x22,
  0x32, 0x35, 0xBB, 0xBB, 0xBB, 0x85, 0x43, 0x32,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x45, 0x89, 0x99, 0x96, 0x5A, 0x7E, 0x33, 0x22,
  0x23, 0x68, 0xBB, 0x9B, 0xB8, 0xA3, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x33, 0x34, 0x44, 0x44, 0x33,
  0x32, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x34, 0x79, 0x99, 0x99, 0x65, 0xA4, 0x32, 0x22,
  0x34, 0x78, 0xB9, 0x99, 0x85, 0x33, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x3F, 0xED, 0xCC, 0xCC, 0xCC, 0xCD,
  0xDF, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x68, 0x99, 0x99, 0x85, 0xA4, 0x33, 0x32,
  0x4A, 0x8B, 0x99, 0xBB, 0x5A, 0x32, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0xED, 0xCC, 0xCC, 0xCD, 0xDD, 0xDD,
  0xDD, 0xFF, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x32, 0x57, 0xB9, 0x99, 0x88, 0x44, 0xF3, 0x22,
  0xA5, 0xBB, 0x99, 0x99, 0xA4, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x4D, 0xCC, 0x8C, 0xDE, 0x44, 0x43, 0xF3,
  0xFF, 0xDE, 0xF3, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0xA5, 0xBB, 0x99, 0x98, 0x44, 0xE3, 0x22,
  0x58, 0xB9, 0x99, 0xB8, 0xA3, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x44, 0xC8, 0x8D, 0xF4, 0x32, 0x32, 0x22, 0x22,
  0x32, 0x23, 0x3F, 0x33, 0x22, 0x22, 0x22, 0x22,
  0x33, 0x35, 0xBB, 0x9B, 0xB8, 0x44, 0x43, 0x22,
  0x68, 0xB9, 0x99, 0x85, 0x43, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23,
  0xEC, 0xCC, 0xE3, 0x32, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x35, 0xBB, 0x98, 0xB8, 0x43, 0x42, 0x32,
  0x8B, 0x9B, 0x9B, 0x84, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3E,
  0x78, 0xDE, 0x33, 0x23, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x3A, 0xBB, 0x99, 0xB8, 0x43, 0x32, 0x22,
  0x8B, 0xB9, 0x98, 0x63, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x4D,
  0xCC, 0xA3, 0x33, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x25, 0x8B, 0xBB, 0xB8, 0x43, 0x32, 0x22,
  0x99, 0x9B, 0xB6, 0xA3, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x34, 0xE8,
  0xCD, 0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x34, 0x8B, 0x99, 0xB8, 0xA3, 0x22, 0x22,
  0x89, 0x99, 0xBA, 0x42, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2E, 0xD8,
  0xE4, 0x32, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x34, 0x88, 0x9B, 0xBB, 0xD4, 0x32, 0x22,
  0x89, 0x9B, 0xB4, 0x33, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x3D, 0xCC,
  0xF3, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x33, 0x22, 0x22, 0x22,
  0x22, 0x34, 0x8B, 0x9B, 0xB8, 0x7F, 0x22, 0x22,
  0x99, 0xBB, 0xB4, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x3C, 0x8D,
  0x42, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0xFF, 0x32, 0x22, 0x22,
  0x22, 0x34, 0x89, 0xB9, 0xB8, 0xA4, 0x22, 0x22,
  0x89, 0x9B, 0xBA, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0xEC, 0x8E,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x3F, 0x22, 0x22, 0x22,
  0x22, 0x3A, 0xBB, 0x9B, 0xBB, 0x42, 0x22, 0x22,
  0x89, 0xBB, 0x84, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x2F, 0xE8, 0xCE,
  0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22,
  0x22, 0x35, 0xBB, 0x9B, 0x88, 0x33, 0x22, 0x22,
  0x89, 0xB8, 0xC4, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0x5C, 0x8E,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x3A, 0xBB, 0x9B, 0x86, 0x43, 0x22, 0x22,
  0x9B, 0x98, 0x64, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0xE8, 0x8D,
  0xF3, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x33, 0x32, 0x22, 0x22, 0x22,
  0x32, 0x35, 0xBB, 0xBB, 0x6A, 0x43, 0x22, 0x22,
  0x89, 0xBB, 0x63, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0xE8, 0x8C,
  0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0xFF, 0x33, 0x22, 0x22, 0x22,
  0x23, 0x45, 0xBB, 0xBB, 0x54, 0xF4, 0x22, 0x22,
  0x8B, 0xB8, 0x73, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0xF8, 0xBC,
  0xA3, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x2F, 0xEF, 0x32, 0x22, 0x22, 0x22,
  0x23, 0xA7, 0xBB, 0x86, 0xA4, 0x43, 0x22, 0x22,
  0x89, 0xB8, 0x53, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x4C, 0xB8,
  0xE4, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x3F, 0xEF, 0x32, 0x22, 0x22, 0x22,
  0x4A, 0x68, 0xBB, 0x7A, 0x44, 0x33, 0x22, 0x22,
  0x8B, 0x98, 0x53, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x4C, 0x8B,
  0x5E, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x2F, 0xF3, 0x32, 0x22, 0x22, 0x32,
  0xAD, 0x8B, 0xB8, 0x74, 0x44, 0x32, 0x22, 0x22,
  0x8B, 0xB8, 0x53, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x35, 0xBB,
  0x85, 0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x32, 0x22, 0x22, 0x22, 0x23, 0x22, 0x22, 0x23,
  0x78, 0xBB, 0x87, 0x53, 0xFF, 0x32, 0x22, 0x22,
  0x8B, 0x98, 0x64, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x3D, 0x88,
  0xB8, 0xA3, 0x22, 0x22, 0x22, 0x22, 0x3E, 0xDC,
  0xDE, 0x32, 0x22, 0x22, 0x22, 0x22, 0x33, 0x33,
  0xC8, 0xB7, 0x5A, 0x43, 0x43, 0x22, 0x22, 0x22,
  0x89, 0xBB, 0x84, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x4A, 0x7B,
  0xB8, 0x6E, 0x32, 0x22, 0x22, 0x22, 0x23, 0x33,
  0x33, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x47,
  0x8B, 0xBD, 0x43, 0x33, 0x32, 0x22, 0x22, 0x22,
  0x8B, 0x9B, 0x84, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0xAA, 0xA6,
  0x8B, 0x8D, 0xF2, 0x32, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x32, 0x22, 0x22, 0x22, 0x33, 0x4A, 0xC8,
  0xB8, 0x85, 0x43, 0x33, 0x32, 0x22, 0x22, 0x22,
  0x88, 0xBB, 0xBA, 0x33, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x24, 0xEE, 0xAA,
  0x67, 0xB8, 0xC4, 0x32, 0x32, 0x32, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x33, 0x34, 0x57, 0xBB,
  0x8C, 0xDF, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x6B, 0xB9, 0xB5, 0x42, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0xFD, 0x5A,
  0x55, 0xC8, 0xB8, 0xC4, 0x33, 0x22, 0x32, 0x22,
  0x32, 0x23, 0x23, 0x23, 0x45, 0xC8, 0x8B, 0x8C,
  0xEE, 0x33, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x69, 0xBB, 0xB6, 0xA2, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2A, 0x65,
  0x58, 0x66, 0xBB, 0x88, 0x5E, 0x33, 0x22, 0x32,
  0x22, 0x22, 0x33, 0x4E, 0x78, 0x8B, 0xB8, 0xCA,
  0x43, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x6B, 0xBB, 0xB7, 0xE3, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x44,
  0x55, 0x56, 0x68, 0xB8, 0x86, 0xDE, 0xEF, 0x33,
  0x4F, 0x4F, 0xAE, 0x67, 0x8B, 0xBB, 0x75, 0xA4,
  0x22, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x5B, 0xBB, 0xB8, 0x63, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x3E, 0xD7, 0x57, 0x8B, 0x8B, 0x88, 0x75, 0xD5,
  0xED, 0xD7, 0x8B, 0xB8, 0x88, 0xCD, 0xE4, 0x32,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0xA6, 0x8B, 0x98, 0x74, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x3E, 0x77, 0xC8, 0xB8, 0xBB, 0xBB, 0xBB,
  0x8B, 0x8B, 0xBB, 0x88, 0xDE, 0xF3, 0x22, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x45, 0xBB, 0xBB, 0xBA, 0x43, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x3A, 0x5C, 0x77, 0x5A, 0xAE, 0x6D,
  0xD5, 0xDE, 0xEE, 0x43, 0x33, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x4A, 0x8B, 0x99, 0x97, 0x6E, 0x43, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x23, 0x4A, 0xAA, 0xEA, 0x5D, 0x55,
  0xEA, 0xA4, 0x33, 0x33, 0x23, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x34, 0x7B, 0xBB, 0x99, 0xB7, 0x54, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x23, 0x34, 0xAE, 0xDD, 0xED,
  0xFF, 0x43, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x5B, 0xB9, 0x99, 0xBB, 0x8D, 0x32, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x22, 0x23, 0x22, 0x32,
  0x33, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x46, 0xB9, 0x99, 0x9B, 0xBD, 0x43, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x3A, 0xBB, 0x99, 0x99, 0xB6, 0x43, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x34, 0x7B, 0x99, 0x99, 0xB7, 0x43, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0xAB, 0xB9, 0x99, 0x98, 0x53, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x36, 0x8B, 0x9B, 0x9B, 0x84, 0x32,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x3A, 0x5B, 0xBB, 0x8B, 0xB5, 0xE2,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x24, 0xAB, 0xB9, 0xB9, 0xB5, 0xA3,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x36, 0x8B, 0x9B, 0xB8, 0x53,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x2A, 0x68, 0x9B, 0xBB, 0x8A,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x23, 0xA5, 0xBB, 0x9B, 0xB7,
  0x43, 0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x34, 0x78, 0xB8, 0x9B,
  0x7A, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x33, 0xED, 0xBB, 0xBB,
  0x87, 0xE3, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x4A, 0x7B, 0xBB,
  0xBB, 0x6A, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x46, 0x8B,
  0xBB, 0x86, 0xE3, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x34, 0x58,
  0xBB, 0xB8, 0x5A, 0x43, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x46,
  0xCB, 0xB9, 0x88, 0x5E, 0x32, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x23,
  0xDC, 0xBB, 0xB9, 0xB8, 0xA4, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23,
  0x24, 0x58, 0x99, 0x9B, 0x8D, 0x43, 0x32, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x4E, 0x78, 0xB9, 0xB7, 0x54, 0x33, 0x32,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x33, 0xA5, 0x7B, 0xB8, 0x8D, 0x44, 0x43,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x34, 0xA6, 0xC8, 0xBB, 0x88, 0xCF,
  0x32, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x23, 0xFE, 0xCB, 0xBB, 0xB8,
  0xD4, 0x33, 0x32, 0x32, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x34, 0x4E, 0xDD, 0xC8,
  0x8D, 0xE4, 0x33, 0x23, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x33, 0x4E, 0xD8,
  0x77, 0x75, 0xAE, 0x44, 0x43, 0x33, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x23, 0x24,
  0x45, 0x78, 0x88, 0xCD, 0xDE, 0x43, 0x32, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x32, 0x33,
  0x45, 0x78, 0x88, 0x8D, 0xDE, 0xF3, 0x32, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
};

#endif
