/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2004  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */

#include "sourceview.h"
#include "context.h"

#include <qlayout.h>
#include <qwhatsthis.h>

#include <kcursor.h>
#include <klocale.h>

#include "resources.h"
#include "kbcatalog.h"

using namespace KBabel;

SourceView::SourceView(KBCatalog* catalog,QWidget *parent, Project::Ptr project)
    : KBCatalogView(catalog,parent,project)
{
    QVBoxLayout* layout = new QVBoxLayout( this );
    layout->setResizeMode( QLayout::Minimum );

    _contextView = new SourceContext (this);
    layout->addWidget (_contextView);
    
    connect(_catalog, SIGNAL(signalFileOpened(bool)), this, SLOT(setDisabled(bool)));
}

void SourceView::updateView()
{
    if (isVisible ())
    {
	_contextView->setContext(_catalog->packageDir()
            ,_catalog->packageName(), _catalog->context(_currentIndex));
    }
}

#include "sourceview.moc"
