/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qregexp.h>
#include <qstringlist.h>

#include "kmtvalidator.h"


PointValidator::PointValidator(QObject* parent, const char* name)
  : QValidator(parent, name), s(TwoD)
{
}

PointValidator::PointValidator(Size size, QObject* parent, const char* name)
  : QValidator(parent, name), s(size)
{
}

PointValidator::~PointValidator( )
{
}

QValidator::State PointValidator::validate(QString& input, int&)
{
  QString stripped = input.stripWhiteSpace( );

  // does input start and end with a bracket?
  if (stripped.find(QRegExp("^(.*)$")) == -1)
    return Invalid;

  QStringList points = QStringList::split('|', stripped.mid(1, stripped.length( )-2));
  // wrong number of points?
  if (points.count( ) != (uint)s)
    return Invalid;

  int i = 0;
  bool ok = true;
  while (i < s && ok) {
    bool ok2;
    (void)points[i].toDouble(&ok2);
    ok = ok && ok2;
    i++;
  }
  if (!ok) return Invalid;

  return Acceptable;
}

#include "kmtvalidator.moc"
