/***************************************************************************
                            KPasswordEdit.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 The widget uses the user's global "echo mode" setting.
 
 See {@link KPasswordEditSignals} for signals emitted by KPasswordEdit.

 See {@link KPasswordEditEventHandling} for event handlers to override in subclasses of KPasswordEdit.

 @author Geert Jansen <geertj@kde.org>

 @short A safe password input widget.

*/
public class KPasswordEdit extends QLineEdit  {
	protected KPasswordEdit(Class dummy){super((Class) null);}


/** 
 Create a widget using the user's global "echo mode" setting.
     
*/
	private native void newKPasswordEdit( QWidget parent, String name);
	public KPasswordEdit( QWidget parent, String name) {
		super((Class) null);
		newKPasswordEdit( parent, name);
	}
	private native void newKPasswordEdit();
	public KPasswordEdit() {
		super((Class) null);
		newKPasswordEdit();
	}

/** 
 Create a widget using echoMode as "echo mode".
     
*/
	private native void newKPasswordEdit( QWidget parent, String name, int echoMode);
	public KPasswordEdit( QWidget parent, String name, int echoMode) {
		super((Class) null);
		newKPasswordEdit( parent, name, echoMode);
	}
	protected native void finalize() throws InternalError;

/**  
 Returns the password. The memory is freed in the destructor
 so you should make a copy.
     
*/
	public native String password();

/**  Erase the current password. 
*/
	public native void erase();
	public native boolean event( QEvent e);
	public static final int OneStar = 0;
	public static final int ThreeStars = 1;
	public static final int NoEcho = 2;
}
