/***************************************************************************
                            KMenuBar.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDE Style-able menubar.

 This is required since {@link QMenuBar} is currently not handled by
 {@link QStyle}.

 See {@link KMenuBarSignals} for signals emitted by KMenuBar.

 See {@link KMenuBarEventHandling} for event handlers to override in subclasses of KMenuBar.

 @author Daniel "Mosfet" Duley.

 @version $Id: KMenuBar.java,v 1.2.2.1 2001/08/29 23:14:10 rdale Exp $

 @short 
 KDE Style-able menubar.
*/
public class KMenuBar extends QMenuBar  {
	protected KMenuBar(Class dummy){super((Class) null);}

	private native void newKMenuBar( QWidget parent, String name);
	public KMenuBar( QWidget parent, String name) {
		super((Class) null);
		newKMenuBar( parent, name);
	}
	private native void newKMenuBar();
	public KMenuBar() {
		super((Class) null);
		newKMenuBar();
	}
	protected native void finalize() throws InternalError;

/** 
 This controls whether or not this menubar will be a top-level
 bar similar to the way Macintosh handles menubars.  This
 overrides any global config settings.

 Keep in mind that it is probably a really bad idea to use this
 unless you really know what you're doing.  A feature like a
 top-level menubar is one that should really be shared by all
 applications.  If your app is the only one with a top-level
 bar, then things might look very... odd.

 This is included only for those people that <code>do</code> know that
 they need to use it.

*/
	public native void setTopLevelMenu( boolean top_level);
	public native void setTopLevelMenu();

/** 
 Is our menubar a top-level (Macintosh style) menubar?

*/
	public native boolean isTopLevelMenu();
	public native void show();
	protected native void drawContents( QPainter p);
	public native boolean eventFilter( QObject arg1, QEvent arg2);
	protected native void slotReadConfig();
}
