/***************************************************************************
                            KLibFactory.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you develop a library that is to be loaded dynamically at runtime, then
 you should provide a function that returns a pointer to your factory like this:
 <pre>
 extern "C"
 {
   void init_libkspread()
   {
     return new KSpreadFactory;
   }
 };
 </pre>
 You should especially see that the function must follow the naming pattern
 "init_libname".

 In the constructor of your factory you should create an instance of {@link KInstance}
 like this:
 <pre>
     s_global = new KInstance( "kspread" );
 </pre>
 This {@link KInstance} is compareable to {@link KGlobal} used by normal applications.
 It allows you to find ressource files (images, XML, sound etc.) belonging
 to the library.

 If you want to load a library, use {@link KLibLoader}. You can query {@link KLibLoader}
 directly for a pointer to the libraries factory by using the {@link KLibLoader#factory}
 function.

 The KLibFactory is used to create the components, the library has to offer.
 The factory of KSpread for example will create instances of KSpreadDoc,
 while the Konqueror factory will create KonqView widgets.
 All objects created by the factory must be derived from {@link QObject}, since {@link QObject}
 offers type safe casting.

 KLibFactory is an abstract class. Reimplement the {@link #createObject} method to give it functionality.

 See {@link KLibFactorySignals} for signals emitted by KLibFactory.

 See {@link KLibFactoryEventHandling} for event handlers to override in subclasses of KLibFactory.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you develop a library that is to be loaded dynamically at runtime, then
 you should provide a function that returns a pointer to your factory like this:
 <pre>
 extern "C"
 {
   void* init_libkspread()
   {
     return new KSpreadFactory;
   }
 };
 </pre>
 You should especially see that the function must follow the naming pattern
 "init_libname".
*/
public class KLibFactory extends QObject  {
	protected KLibFactory(Class dummy){super((Class) null);}


/** 
 Create a new factory.
     
*/
	private native void newKLibFactory( QObject parent, String name);
	public KLibFactory( QObject parent, String name) {
		super((Class) null);
		newKLibFactory( parent, name);
	}
	private native void newKLibFactory();
	public KLibFactory() {
		super((Class) null);
		newKLibFactory();
	}
	protected native void finalize() throws InternalError;

/** 
 Creates a new object. The returned object has to be derived from
 the requested classname.

 It is valid behavior to create different kinds of objects
 depending on the requested <code>classname.</code> For example a koffice
 library may usually return a pointer to {@link KoDocument}.  But
 if asked for a "QWidget", it could create a wrapper widget,
 that encapsulates the Koffice specific features.

 Never reimplement this function. Instead, reimplement {@link #createObject}.

 create() automatically emits a signal {@link objectCreated} to tell
 the library about its newly created object.  This is very
 important for reference counting, and allows unloading the
 library automatically once all its objects have been destroyed.

 This function is virtual for compatibility reasons only.
     
*/
	public native QObject create( QObject parent, String name, String classname, String[] args);
	public native QObject create();

/** 
 Creates a new object. The returned object has to be derived from
 the requested classname.

 It is valid behavior to create different kinds of objects
 depending on the requested <code>classname.</code> For example a koffice
 library may usually return a pointer to {@link KoDocument}.  But
 if asked for a "QWidget", it could create a wrapper widget,
 that encapsulates the Koffice specific features.

 This function is called by {@link #create}
     
*/
	protected native QObject createObject( QObject parent, String name, String classname, String[] args);
	protected native QObject createObject();
}
