/***************************************************************************
                            KEditToolbarWidget.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a widget used to customize or configure toolbars

 This is the widget that does all of the work for the
 {@link KEditToolbar} dialog.  In most cases, you will want to use the
 dialog instead of this widget directly.

 Typically, you would use this widget only if you wanted to embed
 the toolbar editing directly into your existing configure or
 preferences dialog.

 This widget only works if your application uses the XML UI
 framework for creating menus and toolbars.  It depends on the XML
 files to describe the toolbar layouts and it requires the actions
 to determine which buttons are active.

 See {@link KEditToolbarWidgetSignals} for signals emitted by KEditToolbarWidget.

 See {@link KEditToolbarWidgetEventHandling} for event handlers to override in subclasses of KEditToolbarWidget.

 @author Kurt Granroth <granroth@kde.org>

 @short A widget used to customize or configure toolbars.
*/
public class KEditToolbarWidget extends QWidget implements  KXMLGUIClientInterface {
	protected KEditToolbarWidget(Class dummy){super((Class) null);}


/** 
 Constructor.  This is the only entry point to this class.  You
 <code>must</code> pass along your collection of actions (some of which
 appear in your toolbars).  The other three parameters are
 optional.

 The second parameter, {@link #xmlfile}, is the name (absolute or
 relative) of your application's UI resource file.  If it is
 left blank, then the resource file: share/apps/appname/appnameui.rc
 is used.  This is the same resource file that is used by the
 default createGUI function in KMainWindow so you're usually
 pretty safe in leaving it blank.

 The third parameter, {@link #global}, controls whether or not the
 global resource file is used.  If this is true, then you may
 edit all of the actions in your toolbars -- global ones and
 local one.  If it is false, then you may edit only your
 application's entries.  The only time you should set this to
 false is if your application does not use the global resource
 file at all (very rare)

 The last parameter, {@link #parent}, is the standard parent stuff.

*/
	private native void newKEditToolbarWidget( KActionCollection collection, String file, boolean global, QWidget parent);
	public KEditToolbarWidget( KActionCollection collection, String file, boolean global, QWidget parent) {
		super((Class) null);
		newKEditToolbarWidget( collection, file, global, parent);
	}
	private native void newKEditToolbarWidget( KActionCollection collection);
	public KEditToolbarWidget( KActionCollection collection) {
		super((Class) null);
		newKEditToolbarWidget( collection);
	}

/** 
 Constructor for KParts based apps.

 The first parameter, {@link #factory}, is a pointer to the XML GUI
 factory object for your application.  It contains a list of all
 of the GUI clients (along with the action collections and xml
 files) and the toolbar editor uses that.

 The second parameter, {@link #parent}, is the standard parent

 Use this like so:
 <pre>
 KEditToolbar edit(factory());
 if ( edit.exec() )
 ...
 </pre>

*/
	private native void newKEditToolbarWidget( KXMLGUIFactory factory, QWidget parent);
	public KEditToolbarWidget( KXMLGUIFactory factory, QWidget parent) {
		super((Class) null);
		newKEditToolbarWidget( factory, parent);
	}
	private native void newKEditToolbarWidget( KXMLGUIFactory factory);
	public KEditToolbarWidget( KXMLGUIFactory factory) {
		super((Class) null);
		newKEditToolbarWidget( factory);
	}

/** 
 Destructor.  Note that any changes done in this widget will
 <code>NOT</code> be saved in the destructor.  You <code>must</code> call {@link #save}
 to do that.
   
*/
	protected native void finalize() throws InternalError;

/** 
 This is overriden so that the KXMLGUIClient internal functions
 have the proper action collections to deal with.  You shouldn't
 have to do anything with this as it was your collection in the
 first place.

*/
	public native KActionCollection actionCollection();

/** 
 Save any changes the user made.  The file will be in the user's
 local directory (usually $HOME/.kde/share/apps/<appname>).  The
 filename will be the one specified in the constructor.. or the
 made up one if the filename was NULL.

*/
	public native boolean save();
	protected native void setupLayout();
	protected native void loadToolbarCombo();
	protected native void loadActionList( QDomElement elem);
	protected native void updateLocal( QDomElement elem);
	protected native void slotToolbarSelected( String text);
	protected native void slotInactiveSelected( QListViewItem item);
	protected native void slotActiveSelected( QListViewItem item);
	protected native void slotInsertButton();
	protected native void slotRemoveButton();
	protected native void slotUpButton();
	protected native void slotDownButton();

        // From KXMLGUIClientInterface
        
        /** 
 Retrieve an action of the client by name.
 This method is provided for convenience, as it uses {@link #actionCollection}
 to get the action object.
   
*/
	public native KAction action( String name);

/** 
 Retrieve an action for a given {@link QDomElement}. The default
 implementation uses the "name" attribute to query the action
 object via the other action() method.
   
*/
	public native KAction action( QDomElement element);


/** 

*/
	public native KInstanceInterface instance();

/** 

*/
	public native QDomDocument domDocument();

/** 
 This will return the name of the XML file as set by {@link #setXMLFile}.
 If {@link #setXML} is used directly, then this will return NULL.

 The filename that this returns is obvious for components as each
 component has exactly one XML file.  In non-components, however,
 there are usually two: the global file and the local file.  This
 function doesn't really care about that, though.  It will always
 return the last XML file set.  This, in almost all cases, will
 be the local XML file.

*/
	public native String xmlFile();
	public native String localXMLFile();

/** 

   
*/
	public native void setXMLGUIBuildDocument( QDomDocument doc);

/** 

   
*/
	public native QDomDocument xmlguiBuildDocument();

/** 
 This method is called by the {@link KXMLGUIFactory} as soon as the client
 is added to the KXMLGUIFactory's GUI.
   
*/
	public native void setFactory( KXMLGUIFactory factory);

/** 
 Retrieve a pointer to the {@link KXMLGUIFactory} this client is
 associated with (will return 0L if the client's GUI has not been built
 by a KXMLGUIFactory.
   
*/
	public native KXMLGUIFactory factory();

/** 
 KXMLGUIClients can form a simple child/parent object tree. This
 method returns a pointer to the parent client or 0L if it has no
 parent client assigned.
   
*/
	public native KXMLGUIClientInterface parentClient();

/** 
 Use this method to make a client a child client of another client.
 Usually you don't need to call this method, as it is called
 automatically when using the second constructor, which takes a
 arent argument.
   
*/
	public native void insertChildClient( KXMLGUIClientInterface child);

/** 
 Remove the given <code>child</code> from the client's children list.
   
*/
	public native void removeChildClient( KXMLGUIClientInterface child);

/** 
 A client can have an own {@link KXMLGUIBuilder}.
 Use this method to assign your builder instance to the client (so that the
 {@link KXMLGUIFactory} can use it when building the client's GUI)

 Client specific guibuilders are useful if you want to create
 custom container widgets for your GUI.
   
*/
	public native void setClientBuilder( KXMLGUIBuilderInterface builder);

/** 
 Retrieve the client's GUI builder or 0L if no client specific
 uilder has been assigned via {@link #setClientBuilder}
   
*/
	public native KXMLGUIBuilderInterface clientBuilder();

/** 
 Force this client to re-read its XML resource file.  This is
 intended to be used when you know that the resource file has
 changed and you will soon be rebuilding the GUI.  It has no
 useful effect with non-KParts GUIs, so don't bother using it
 unless your app is component based.
   
*/
	public native void reloadXML();
	public native void unplugActionList( String name);
	public static native String findMostRecentXMLFile( String[] files, String doc);

/** 
 Set the instance ({@link KInstance}) for this part.

 Call this first in the inherited class constructor.
 (At least before {@link #setXMLFile}.)
   
*/
	public native void setInstance( KInstanceInterface instance);

/** 
 Set the name of the rc file containing the XML for the part.

 Call this in the Part-inherited class constructor.

*/
	protected native void setXMLFile( String file, boolean merge, boolean setXMLDoc);
	protected native void setXMLFile( String file);
	protected native void setLocalXMLFile( String file);

/** 
 Set the XML for the part.

 Call this in the Part-inherited class constructor if you
  don't call {@link #setXMLFile}.

*/
	protected native void setXML( String document, boolean merge);
	protected native void setXML( String document);

/** 
 Set the Document for the part, describing the layout of the GUI.

 Call this in the Part-inherited class constructor if you don't call
 {@link setXMLFile} or {@link setXML} .
   
*/
	protected native void setDOMDocument( QDomDocument document, boolean merge);
	protected native void setDOMDocument( QDomDocument document);

/** 
 This function will attempt to give up some memory after the GUI
 is built.  It should never be used in apps where the GUI may be
 rebuilt at some later time (components, for instance).
   
*/
	protected native void conserveMemory();

}
