/***************************************************************************
                            KDockTabCtl.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A manager for a single {@link #KDockTabBar}.
 The {@link KDockWidget} class ever use this class instead of accessing the KDockTabBar directly.

 For some reasons it's more practical for the Dockwidget class set than {@link QTabBar} or {@link KTabBar} .

 See {@link KDockTabCtlSignals} for signals emitted by KDockTabCtl.

 See {@link KDockTabCtlEventHandling} for event handlers to override in subclasses of KDockTabCtl.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 A manager for a single @ref KDockTabBar  (and member of the dockwidget class set).
*/
public class KDockTabCtl extends QWidget  {
	protected KDockTabCtl(Class dummy){super((Class) null);}


/** 
 Constructs a dock-tab control object.
   
*/
	private native void newKDockTabCtl( QWidget parent, String name);
	public KDockTabCtl( QWidget parent, String name) {
		super((Class) null);
		newKDockTabCtl( parent, name);
	}
	private native void newKDockTabCtl();
	public KDockTabCtl() {
		super((Class) null);
		newKDockTabCtl();
	}

/** 
 Destructs this.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Calls {@link KDockTabBar#setTabPos} of its embedded tab bar but does layout actions, additionally.

   
*/
	public native void setTabPos( int arg1);

/** 
 Returns the current tab position of its docktabbar.
   
*/
	public native int getTabPos();

/** 
 Inserts a new tab page in the encapsulated docktabbar.
 Mainly it calls {@link KDockTabBar#insertTab} and does additional management operations.

*/
	public native int insertPage( QWidget w, String label, int identifier, int index);
	public native int insertPage( QWidget w, String label);

/** 
 Sets the title of the tab page.
 Mainly it calls {@link KDockTabBar#setPageCaption} but calls it internally by the page id.

*/
	public native void setPageCaption( QWidget w, String s);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native void setPageCaption( int identifier, String caption);

/** 
 Returns the title of the tab page.
 Mainly it calls {@link KDockTabBar#setPageCaption} but calls it internally by the page id.

*/
	public native String pageCaption( QWidget w);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native String pageCaption( int identifier);
	public native void captionAutoSet( boolean autoSet);
	public native boolean isCaptionAutoSet();

/** 
 Sets an icon for the tab page (shown in the tab header).

*/
	public native void setPixmap( QWidget w, QPixmap pix);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native void setPixmap( int identifier, QPixmap pix);

/** 
 Sets a toolTip for the tab page (shown in the tab header).

*/
	public native void setToolTip( QWidget w, String toolTipStr);

/** 
 Sets the text colour of the tab page.
 Mainly it calls {@link KDockTabBar#setTextColor} but calls it internally by the page id.

*/
	public native void setTabTextColor( QWidget arg1, QColor color);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native void setTabTextColor( int identifier, QColor color);

/** 
 Returns the text colour of the tab page.
 Mainly it calls {@link KDockTabBar#textColor} but calls it internally by the page id.

*/
	public native QColor tabTextColor( QWidget w);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native QColor tabTextColor( int identifier);

/** 
 Returns if the tab page is enabled (if it can get the focus).

*/
	public native boolean isPageEnabled( QWidget w);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native boolean isPageEnabled( int identifier);

/** 
 Enable or disable the tab page (whether it can get the focus or not).
 Mainly it calls {@link KDockTabBar#setPageEnabled} but calls it internally by the page id.

*/
	public native void setPageEnabled( QWidget w, boolean e);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native void setPageEnabled( int identifier, boolean enabled);

/** /

  /
 Returns the widget that embedded in a page.

*/
	public native QWidget page( int identifier);

/** 
 Returns the widget's Id.

*/
	public native int id( QWidget w);

/** 
 Returns the widget's index. (tab page position)

*/
	public native int index( QWidget w);

/** 
 Removes the tab page from the covered tab bar.
 Mainly it calls {@link KDockTabBar#removeTab} but calls it internally by the page id.

*/
	public native void removePage( QWidget w);

/**  This is an overloaded member function, provided for convenience.
  It differs from the above function only in what argument(s) it accepts. 
   
*/
	public native void removePage( int identifier);

/** 
 Returns the current (visible) tab page.
   
*/
	public native QWidget visiblePage();

/** 
 Returns the id of the current (visible) tab page.
   
*/
	public native int visiblePageId();

/** 
 Sets the given tab page as the active (and visible) one.
   
*/
	public native void setVisiblePage( QWidget arg1, boolean allowDisable);
	public native void setVisiblePage( QWidget arg1);

/** 
 Sets the font for the tab pages. 
 It just calls the appropriate method of its KDockTabBar.
   
*/
	public native void setTabFont( QFont font);

/** 
 Returns the font for the tab pages.
 It simply calls {@link KDockTabBar#tabFont} .
   
*/
	public native QFont tabFont();

/** 
 Enables or disables the showing of the icons for every tab page.
 It simply calls {@link KDockTabBar#showTabIcon} .
   
*/
	public native void showTabIcon( boolean arg1);

/** 
 Returns if the tab icon is shown.
 It simply calls {@link KDockTabBar#isShowTabIcon} .
   
*/
	public native boolean isShowTabIcon();

/** 
 Returns the number of inserted tab pages.
   
*/
	public native int pageCount();

/** 
 Returns the first tab page in its KDockTabBar.
   
*/
	public native QWidget getFirstPage();

/** 
 Returns the last tab page in its KDockTabBar.
   
*/
	public native QWidget getLastPage();

/** 
 Returns the tab page that is at the right side of the given tab widget.
   
*/
	public native QWidget getNextPage( QWidget arg1);

/** 
 Returns the tab page that is at the left side of the given tab widget.
   
*/
	public native QWidget getPrevPage( QWidget arg1);

/** 
 Shows its encapsulated tab bar and shows the current tab page.
   
*/
	public native void show();

/** 
 Catches some events that are of interest for this class.
   
*/
	public native boolean eventFilter( QObject arg1, QEvent arg2);

/** 
 Enables or disables this and its KDockTabBar.
   
*/
	public native void setEnabled( boolean arg1);

/** 
 Sets the visible page by its id.
   
*/
	public native void setVisiblePage( int identifier);

/** 
 Returns the appropriate data for the widget from the parameter list.
   
*/
//	protected native KDockTabCtl_PrivateStruct findData( QWidget arg1);

/** 
 Returns the appropriate data for the widget from the parameter list described by its id.
   
*/
//	protected native KDockTabCtl_PrivateStruct findData( int identifier);

/** 
 Shows the tab page.
   
*/
	protected native void showPage( QWidget arg1, boolean allowDisable);
	protected native void showPage( QWidget arg1);

/** 
 Do some things that should be done when someone has pressed the right mouse button on this.
   
*/
	protected native void rightButtonPress( int arg1, QPoint arg2);
}
