/***************************************************************************
                            KDirLister.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The dir lister deals with the kiojob used to list and update a directory
 and has signals for the user of this class (e.g. konqueror view or
 kdesktop) to create/destroy its items when asked.

 This class is independent from the graphical representation of the dir
 (icon container, tree view, ...) and it stores the items (as KFileItems).

 Typical usage :
 Create an instance.
 Connect to at least update, clear, newItem, and deleteItem.
 Call openURL - the signals will be called.
 Reuse the instance when opening a new url (openURL).
 Destroy the instance when not needed anymore (usually destructor).

 Advanced usage : call openURL with _keep = true to list directories
 without forgetting the ones previously read (e.g. for a tree view)

 See {@link KDirListerSignals} for signals emitted by KDirLister.

 See {@link KDirListerEventHandling} for event handlers to override in subclasses of KDirLister.

 @short Helper class for the kiojob used to list and update a directory.
 
*/
public class KDirLister extends QObject implements  KDirNotifyInterface {
	protected KDirLister(Class dummy){super((Class) null);}


/** 
 Create a directory lister.
   
*/
	private native void newKDirLister( boolean _delayedMimeTypes);
	public KDirLister( boolean _delayedMimeTypes) {
		super((Class) null);
		newKDirLister( _delayedMimeTypes);
	}
	private native void newKDirLister();
	public KDirLister() {
		super((Class) null);
		newKDirLister();
	}

/** 
 Destroy the directory lister.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Run the directory lister on the given url. If <code>_url</code> is already in the cache
 (i.e. openURL() was already called with <code>_url</code>) and _keep == true this is
 equivalent to <code>updateDirectory</code>( _url ).

 The {@link #newItems} signal may be emitted more than once to supply you
 with KFileItems, up until the signal {@link #completed} is emitted
 (and {@link #isFinished} returns true).
   
*/
	public native void openURL( KURL _url, boolean _showDotFiles, boolean _keep);
	public native void openURL( KURL _url, boolean _showDotFiles);

/** 
 Stop listing all directories currently being listed.

 Emits {@link #canceled} if there was at least one job running.
 Emits {@link #canceled} for each stopped job if
 there are at least two dirctories being watched by KDirLister.
   
*/
	public native void stop();

/** 
 Stop listing the given directory.

 Emits {@link #canceled} if the killed job was the last running one.
 Emits {@link #canceled} for the killed job if
 there are at least two directories being watched by KDirLister.
 No signal is emitted if there was no job running for <code>_url.</code>

*/
	public native void stop( KURL _url);

/** 

*/
	public native KURL url();

/** 
 Sets <code>url</code> as the current url, forgetting any previous ones and stopping
 any pending job. If <code>url</code> is malformed, the previous url will be kept
 and false will be returned.

 Does _not_ start loading that url,
   
*/
	public native boolean setURL( KURL url);

/** 
 Update <code>_dir.</code>
 The current implementation calls it automatically for
 local files, using KDirWatch (if autoUpdate() is true), but it might be
 useful to force an update manually.

*/
	public native void updateDirectory( KURL _dir);

/** 
 Convenience method. Starts loading the current directory, e.g. set via
 {@link #setURL}, if the URL is "dirty" -- otherwise the cached entries are
 reused. The url is dirty when a new URL was set via setURL or the
 nameFilter was changed.

*/
	public native void listDirectory();

/** 
 Sets the current URL "dirty", so it will be reloaded upon the next
 {@link #listDirectory} call.
   
*/
	public native void setURLDirty( boolean dirty);

/** 
 Enable/disable automatic directory updating, when a directory changes
 (using KDirWatch).
   
*/
	public native void setAutoUpdate( boolean enable);

/** 

*/
	public native boolean autoUpdate();

/** 
 Changes the "is viewing dot files" setting.
 Calls {@link #updateDirectory} if setting changed
   
*/
	public native void setShowingDotFiles( boolean _showDotFiles);

/** 

*/
	public native boolean showingDotFiles();

/** 
 Find an item by its URL

*/
	public native KFileItem find( KURL _url);

/** 
 Find an item by its name

*/
	public native KFileItem findByName( String name);

/** 

*/
	public native KFileItem rootItem();

/** 
 ## problem, if there are more jobs running (merge?)
   
*/
	public native ListJob job();

/** 
 Call this with <code>dirsOnly</code> == true to list only directories
   
*/
	public native void setDirOnlyMode( boolean dirsOnly);

/** 

*/
	public native boolean dirOnlyMode();

/** 
 Set a name filter to only list items matching this name, e.g. ".cpp".

 You can set more than one filter by separating them with whitespace, e.g
 ".cpp .h".
 Call setNameFilter( String.null ) to disable filtering.
 Note: the direcory is not automatically reloaded.

*/
	public native void setNameFilter( String arg1);

/** 
 Set mime-based filter to only list items matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

*/
	public native void setMimeFilter( String[] arg1);

/** 
 Clears the mime based filter.

*/
	public native void clearMimeFilter();

/** 

 Sets mime filters separated with space.
 ## remove for 3.0
   
*/
	public native void setMimeFilter( String arg1);

/** 

*/
	public native String nameFilter();

/** 

*/
	public native ArrayList mimeFilters();

/** 

*/
	public native String mimeFilter();

/** 

*/
	public native boolean matchesFilter( String name);

/** 

*/
	public native boolean matchesMimeFilter( String mime);

/** 
 Notify that files have been added in <code>directory</code>
 The receiver will list that directory again to find
 the new items (since it needs more than just the names anyway).
 Reimplemented from KDirNotify.
   
*/
	public native void FilesAdded( KURL directory);

/** 
 Notify that files have been deleted.
 This call passes the exact urls of the deleted files
 so that any view showing them can simply remove them
 or be closed (if its current dir was deleted)
 Reimplemented from KDirNotify.
   
*/
	public native void FilesRemoved( ArrayList fileList);

/** 
 Notify that files have been changed.
 At the moment, this is only used for new icon, but it could be
 used for size etc. as well.
 Note: this is ASYNC so that it can be used with a broadcast
   
*/
	public native void FilesChanged( ArrayList fileList);
	public native void FileRenamed( KURL src, KURL dst);

/** 
 Returns true if no io operation is currently in progress.
   
*/
	public native boolean isFinished();

/** 
 called to create a KFileItem - you may subclass and reimplement this
 method if you use "special KFileItems", i.e. a subclass like KonqFileItem
 Must return a valid KFileItem

*/
//	protected native KFileItem createFileItem( UDSEntry arg1, KURL url, boolean determineMimeTypeOnDemand);

/** 
 Called for every item after {@link #createFileItem}.

*/
	protected native boolean matchesFilter( KFileItem arg1);

/** 

   
*/
	protected native boolean matchesMimeFilter( KFileItem arg1);

/** 
 Unregister dirs from kdirwatch and clear list of dirs
   
*/
	protected native void forgetDirs();

/** 
 Delete unmarked items, as it says on the tin
   
*/
	protected native void deleteUnmarkedItems();

/** 
 Checks if a url is malformed or not and displays an error message if it
 is. Returns true if it is valid, otherwise false.
   
*/
	protected native boolean validURL( KURL arg1);

/** 
 If an update was triggered while we were listing, we'll process it
 after the end of the listing. This processes the next update in the
 list of pending updates.
   
*/
	protected native void processPendingUpdates();
	protected native void slotResult( Job arg1);
//	protected native void slotEntries( Job arg1, UDSEntryList arg2);
	protected native void slotUpdateResult( Job arg1);
//	protected native void slotUpdateEntries( Job arg1, UDSEntryList arg2);
	protected native void slotRedirection( Job arg1, KURL url);
	protected native void slotDirectoryDirty( String _dir);
	protected native void slotFileDirty( String _file);
	protected native void slotURLDirty( KURL dir);
}
