/***************************************************************************
                            KComboBox.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A combined button, line-edit and a popup list widget.

 This widget inherits from {@link QComboBox} and implements
 the following additional functionalities:  a completion
 object that provides both automatic and manual text
 completion as well as text rotation features, configurable
 key-bindings to activate these features, and a popup-menu
 item that can be used to allow the user to set text completion
 modes on the fly based on their preference.

 To support these new features {@link KComboBox} also emits a few
 more additional signals as well.  The main ones are the
 {@link #completion} and {@link #textRotation}
 signals.  The completion signal is intended to be connected to a slot
 that will assist the user in filling out the remaining text while
 the rotation signals is intended to be used to trasverse through all
 possible matches whenever text completion results in multiple matches.
 The {@link #returnPressed} and {@link #returnPressed}
 signal is emitted when the user presses the Enter/Return key.

 This widget by default creates a completion object when you invoke
 the {@link #completionObject} member function for the first time
 or use {@link #setCompletionObject} to assign your
 own completion object.  Additionally, to make this widget more functional,
 {@link KComboBox} will by default handle the text rotation and completion
 events internally whenever a completion object is created through either
 one of the methods mentioned above.  If you do not need this functionality,
 simply use {@link KCompletionBase#setHandleSignals} or alternatively
 set the boolean parameter in the above methods to FALSE.

 The default key-bindings for completion and rotation is determined
 from the global settings in {@link KStdAccel}.  These values, however,
 can be overriden locally by invoking {@link KCompletionBase#setKeyBinding}.
 The values can easily be reverted back to the default setting, by simply
 calling {@link #useGlobalSettings}. An alternate method would be to default
 individual key-bindings by usning {@link #setKeyBinding} with the default
 second argument.

 Note that if this widget is not editable ( i.e. select-only ), then only
 one completion mode, <code>CompletionAuto</code>, will work.  All the other modes are
 simply ignored.  The <code>CompletionAuto</code> mode in this case allows you to
 automatically select an item from the list by trying to match the pressed
 keycode with the first letter of the enteries in the combo box.

 To enable the basic completion feature:

 <pre>
 KComboBox combo = new KComboBox( true, this, "mywidget" );
 KCompletion comp = combo.completionObject();
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>

 To use your own completion object:

 <pre>
 KComboBox combo = new KComboBox( this,"mywidget" );
 KURLCompletion comp = new KURLCompletion();
 combo.setCompletionObject( comp );
 // Connect to the return pressed signal - optional
 connect(combo,SIGNAL("returnPressed(String)"),comp,SLOT("addItem(String)");
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 Miscellaneous function calls:

 <pre>
 // Tell the widget not to handle completion and rotation
 combo.setHandleSignals( false );
 // Set your own completion key for manual completions.
 combo.setKeyBinding( KCompletionBase.TextCompletion, Qt.End );
 // Hide the context (popup) menu
 combo.setContextMenuEnabled( false );
 // Temporarly disable signal emition
 combo.disableSignals();
 // Default the all key-bindings to their system-wide settings.
 combo.useGlobalKeyBindings();
 </pre>

 See {@link KComboBoxSignals} for signals emitted by KComboBox.

 See {@link KComboBoxEventHandling} for event handlers to override in subclasses of KComboBox.

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced combo box.

*/
public class KComboBox extends QComboBox implements  KCompletionBaseInterface {
	protected KComboBox(Class dummy){super((Class) null);}


/** 
 Construct a read-only or rather select-only combo box with a
 parent object and a name.

*/
	private native void newKComboBox( QWidget parent, String name);
	public KComboBox( QWidget parent, String name) {
		super((Class) null);
		newKComboBox( parent, name);
	}
	private native void newKComboBox();
	public KComboBox() {
		super((Class) null);
		newKComboBox();
	}

/** 
 Construct a "read-write" or "read-only" combo box depending on
 the value of the first argument( <code>rw</code> ) with a parent, a
 name.

*/
	private native void newKComboBox( boolean rw, QWidget parent, String name);
	public KComboBox( boolean rw, QWidget parent, String name) {
		super((Class) null);
		newKComboBox( rw, parent, name);
	}
	private native void newKComboBox( boolean rw);
	public KComboBox( boolean rw) {
		super((Class) null);
		newKComboBox( rw);
	}

/** 
 Destructor.
    
*/
	protected native void finalize() throws InternalError;

/** 
 Sets <code>url</code> into the edit field of the combobox. It uses
 {@link KURL#prettyURL} so that the url is properly decoded for
 displaying.
     
*/
	public native void setEditURL( KURL url);

/** 
 Inserts <code>url</code> at position <code>index</code> into the combobox. The item will
 be appended if <code>index</code> is negative. {@link KURL#prettyURL} is used
 so that the url is properly decoded for displaying.
     
*/
	public native void insertURL( KURL url, int index);
	public native void insertURL( KURL url);

/** 
 Inserts <code>url</code> with the pixmap &p pixmap at position <code>index</code> into
 the combobox. The item will be appended if <code>index</code> is negative.
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void insertURL( QPixmap pixmap, KURL url, int index);
	public native void insertURL( QPixmap pixmap, KURL url);

/** 
 Replaces the item at position <code>index</code> with <code>url.</code>
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void changeURL( KURL url, int index);

/** 
 Replaces the item at position <code>index</code> with <code>url</code> and pixmap <code>pixmap.</code>
 {@link KURL#prettyURL} is used so that the url is properly decoded
 for displaying.
     
*/
	public native void changeURL( QPixmap pixmap, KURL url, int index);

/** 
 Retreive the current cursor position.

 This method always returns a -1 if the combo-box is <em>not</em>
 editable (read-write).

*/
	public native int cursorPosition();

/** 
 Re-implemented from {@link QComboBox}.

 If <code>true</code>, the completion mode will be set to automatic.
 Otherwise, it is defaulted to the gloabl setting.  This
 methods has been replaced by the more comprehensive
 {@link #setCompletionMode}.

*/
	public native void setAutoCompletion( boolean autocomplete);

/** 
 Re-implemented from QComboBox.

 Returns <code>true</code> if the current completion mode is set
 to automatic.  See its more comprehensive replacement
 {@link #completionMode}.

*/
	public native boolean autoCompletion();

/** 
 Enable or disable the popup (context) menu.

 This method only works if this widget is editable, i.e.
 read-write and allows you to enable/disable the context
 menu.  It does nothing if invoked for a none-editable
 combo-box.  Note that by default the mode changer item
 is made visiable whenever the context menu is enabled.
 Use {@link #hideModechanger} if you want to hide this
 item.    Also by default, the context menu is created if
 this widget is editable. Call this function with the
 argument set to false to disable the popup menu.

*/
	public native void setContextMenuEnabled( boolean showMenu);

/** 
 Returns <code>true</code> when the context menu is enabled.

*/
	public native boolean isContextMenuEnabled();

/** 
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QComboBox is used, which inserts the encoded URL.

*/
	public native void setURLDropsEnabled( boolean enable);

/** 
 Returns <code>true</code> when decoded URL drops are enabled

*/
	public native boolean isURLDropsEnabled();

/** 
 Returns <code>true</code> if the combo-box is editable.

*/
	public native boolean isEditable();

/** 
 Convenience method which iterates over all items and checks if
 any of them is equal to <code>text.</code>

 If <code>text</code> is an empty string, <code>false</code>
 is returned.

*/
	public native boolean contains( String text);

/** 
 By default, {@link KComboBox} recognizes Key_Return and Key_Enter
 and emits
 the {@link #returnPressed} signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with <code>trap</code> equal to <code>true</code> to make {@link KComboBox}
 stop these
 events. The signals will still be emitted of course.

 Only affects read-writable comboboxes.

*/
	public native void setTrapReturnKey( boolean trap);

/** 

*/
	public native boolean trapReturnKey();

/** 
 Re-implemented from {@link KCompletionBase} for internal reasons.
    
*/
	public native void setCompletionMode( int mode);

/** 

*/
//	public native KCompletionBox* completionBox();

/** 

*/
//	public native KCompletionBox* completionBox( boolean create);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	public native void setCompletionObject( KCompletion arg1, boolean hsig);
	public native void setCompletionObject( KCompletion arg1);

/** 
 Iterate through all possible matches of the completed text
 or the history list.

 Depending on the value of the argument, this function either
 iterates through the history list of this widget or the all
 possible matches in whenever multiple matches result from a
 text completion request.  Note that the all-possible-match
 iteration will not work if there are no previous matches, i.e.
 no text has been completed and the nix shell history list
 rotation is only available if the insertion policy for this
 widget is set either <code>QComobBox.AtTop</code> or <code>QComboBox.AtBottom.</code>
 For other insertion modes whatever has been typed by the user
 when the rotation event was initiated will be lost.

*/
//	public native void rotateText( KCompletionBase_KeyBindingType arg1);

/** 
 Sets the completed text in the line-edit appropriately.

 This function is an implementation for
 {@link KCompletionBase#setCompletedText}.
     
*/
	public native void setCompletedText( String arg1);

/** 
 Sets <code>items</code> into the completion-box if {@link #completionMode} is
 CompletionPopup. The popup will be shown immediately.
     
*/
	public native void setCompletedItems( String[] items);
	protected native void setCompletedText( String arg1, boolean arg2);

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
	protected native void create( int arg1, boolean initializeWindow, boolean destroyOldWindow);
	protected native void create();

/** 

    
*/
	protected native void itemSelected( QListBoxItem arg1);

/** 
 Completes text according to the completion mode.

 Note: this method is <code>not</code> invoked if the completion mode is
 set to CompletionNone.  Also if the mode is set to <code>CompletionShell</code>
 and multiple matches are found, this method will complete the
 text to the first match with a beep to inidicate that there are
 more matches.  Then any successive completion key event iterates
 through the remaining matches.  This way the rotation functionality
 is left to iterate through the list as usual.
    
*/
	protected native void makeCompletion( String arg1);

/** 

     
*/
	protected native void slotAboutToShow();

/** 

     
*/
	protected native void slotCancelled();

	// From KCompletionBaseInterface
	
/**
 Returns a pointer to the current completion object.

 If the object does not exist, it is automatically
 created.  Note that the completion object created
 here is used by default to handle the signals
 internally.  It is also deleted when this object's
 destructor is invoked.  If you do not want these
 default settings, use {@link setAutoDeleteCompletionObject}
 and {@link setHandleSignals} to change the behavior.
 Alternatively, you can set the boolean parameter to
 false to disable the automatic handling of the signals
 by this object.  Note that the boolean argument will be
 ignored if there already exists a completion object since
 no new object needs to be created. You need to use either
 {@link setHandleSignals} or {@link setCompletionObject} for
 such cases depending on your requirement.

*/
	public native KCompletion completionObject( boolean hsig);
	public native KCompletion completionObject();
/**
 Overloaded method to specify whether a completion-object should be
 created or not. If <code>create</code> is set to false and there is no
 completion-object yet, 0L will be returned.

*/
	public native KCompletion completionObject( boolean create, boolean hsig);
/**
 Sets up the completion object to be used.

 This method assigns the completion object and sets it
 up to automatically handle the completion and rotation
 signals internally.  You should use this function if
 you want to share one completion object among you widgets
 or need to use a customized completion object.

 The object assigned through this method is not deleted
 when this object's destructor is invoked unless you
 explicitly call {@link setAutoDeleteCompletionObject} after
 calling this method.  Also if you do not want the signals
 to be handled by an internal implementation, be sure to
 set the boolean argument to false.

*/
//	public native void setCompletionObject( KCompletion arg1, boolean hsig);
//	public native void setCompletionObject( KCompletion arg1);

/**
 Enables this object to handle completion and rotation
 events internally.

 This function simply assigns a boolean value that
 indicates whether it should handle rotation and
 completion events or not.  Note that this does not
 stop the object from emitting signals when these
 events occur.

*/
	public native void setHandleSignals( boolean arg1);

/**
 Returns true if the completion object is deleted
 upon this widget's destruction.

 See {@link #setCompletionObject} and {@link #enableCompletion}
 for details.

*/
	public native boolean isCompletionObjectAutoDeleted();

/**
 Sets the completion object when this widget's destructor
 is called.

 If the argument is set to true, the completion object
 is deleted when this widget's destructor is called.

*/
	public native void setAutoDeleteCompletionObject( boolean autoDelete);

/**
 Sets the widget's ability to emit text completion and
 rotation signals.

 Invoking this function with <code>enable</code> set to <code>false</code> will
 cause the completion & rotation signals not to be emitted.
 However, unlike setting the completion object to <code>NULL</code>
 using {@link setCompletionObject}, disabling the emition of
 the signals through this method does not affect the current
 completion object.

 There is no need to invoke this function by default.  When a
 completion object is created through {@link completionObject} or
 {@link setCompletionObject}, these signals are set to emit
 automatically.  Also note that disabling this signals will not
 necessarily interfere with the objects ability to handle these
 events internally.  See {@link setHandleSignals}.

*/
	public native void setEnableSignals( boolean enable);

/**
 Returns true if the object handles the signals

*/
	public native boolean handleSignals();

/**
 Returns true if the object emits the signals

*/
	public native boolean emitSignals();

/**
 Retrieves the current completion mode.

 The return values are of type {@link KGlobalSettings#Completion}.
 See {@link #setCompletionMode} for details.

*/
	public native int completionMode();

/**
 Sets the key-binding to be used for manual text
 completion, text rotation in a history list as
 well as a completion list.

 When the keys set by this function are pressed, a
 signal defined by the inherting widget will be activated.
 If the default value or 0 is specified by the second
 parameter, then the key-binding as defined in the global
 setting should be used.  This method returns false value
 for <code>key</code> is negative or the supplied key-binding conflicts
 with the ones set for one of the other features.

 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
 the key-binding simply simply <code>sum</code> up the values of the
 modifier and the actual key.  For example, to use CTRL+E as
 a key binding for one of the items, you would simply supply
 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
 function.

*/
	public native boolean setKeyBinding( int arg1, int key);
	public native boolean setKeyBinding( int arg1);

/**
 Returns the key-binding used for the specified item.

 This methods returns the key-binding used to activate
 the feature feature given by <code>item.</code>  If the binding
 contains modifier key(s), the SUM of the modifier key
 and the actual key code are returned.

*/
	public native int getKeyBinding( int item);

/**
 Sets this object to use global values for key-bindings.

 This method changes the values of the key bindings for
 rotation and completion features to the default values
 provided in KGlobalSettings.

 NOTE: By default inheriting widgets should uses the
 global key-bindings so that there will be no need to
 call this method.

*/
	public native void useGlobalKeyBindings();
}
