/***************************************************************************
                            DOMDocument.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The <code> Document </code> interface represents the entire HTML or
 XML document. Conceptually, it is the root of the document tree,
 and provides the primary access to the document's data.

  Since elements, text nodes, comments, processing instructions,
 etc. cannot exist outside the context of a <code> Document </code>
 , the <code> Document </code> interface also contains the factory
 methods needed to create these objects. The <code> Node </code>
 objects created have a <code> ownerDocument </code> attribute which
 associates them with the <code> Document </code> within whose
 context they were created.

 
 @short 
 The <code> Document </code> interface represents the entire HTML or
 XML document.
*/
public class DOMDocument extends DOMNode  {
	protected DOMDocument(Class dummy){super((Class) null);}

	private native void newDOMDocument();
	public DOMDocument() {
		super((Class) null);
		newDOMDocument();
	}

/** 
 don't create an implementation if false
 use at own risk
     
*/
	private native void newDOMDocument( boolean arg1);
	public DOMDocument( boolean arg1) {
		super((Class) null);
		newDOMDocument( arg1);
	}
	private native void newDOMDocument( DOMDocument other);
	public DOMDocument( DOMDocument other) {
		super((Class) null);
		newDOMDocument( other);
	}
	private native void newDOMDocument( DOMNode other);
	public DOMDocument( DOMNode other) {
		super((Class) null);
		newDOMDocument( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The Document Type Declaration (see <code> DocumentType </code>
 ) associated with this document. For HTML documents as well as
 XML documents without a document type declaration this returns
 <code> null </code> . The DOM Level 1 does not support editing
 the Document Type Declaration, therefore <code> docType </code>
 cannot be altered in any way.

     
*/
	public native DocumentType doctype();

/** 
 The <code> DOMImplementation </code> object that handles this
 document. A DOM application may use objects from multiple
 implementations.

     
*/
//	public native DOMImplementation implementation();

/** 
 This is a convenience attribute that allows direct access to
 the child node that is the root element of the document. For
 HTML documents, this is the element with the tagName "HTML".

     
*/
	public native Element documentElement();

/** 
 Creates an element of the type specified. Note that the
 instance returned implements the Element interface, so
 attributes can be specified directly on the returned object.

     
*/
	public native Element createElement( String tagName);

/** 
 Introduced in DOM Level 2
 Creates an element of the given qualified name and namespace URI.

*/
	public native Element createElementNS( String namespaceURI, String qualifiedName);

/** 
 Creates an empty <code> DocumentFragment </code> object.

     
*/
	public native DocumentFragment createDocumentFragment();

/** 
 Creates a <code> Text </code> node given the specified string.

     
*/
	public native Text createTextNode( String data);

/** 
 Creates a <code> Comment </code> node given the specified
 string.

     
*/
	public native Comment createComment( String data);

/** 
 Creates a <code> CDATASection </code> node whose value is the
 specified string.

     
*/
	public native CDATASection createCDATASection( String data);

/** 
 Creates a <code> ProcessingInstruction </code> node given the
 specified name and data strings.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
	public native ProcessingInstruction createProcessingInstruction( String target, String data);

/** 
 Creates an <code> Attr </code> of the given name. Note that the
 <code> Attr </code> instance can then be set on an <code>
 Element </code> using the <code> setAttribute </code> method.

     
*/
	public native Attr createAttribute( String name);

/** 
 Introduced in DOM Level 2
 Creates an attribute of the given qualified name and namespace URI.
 HTML-only DOM implementations do not need to implement this method.

*/
	public native Attr createAttributeNS( String namespaceURI, String qualifiedName);

/** 
 Creates an EntityReference object.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
	public native EntityReference createEntityReference( String name);

/** 
 Returns a <code> NodeList </code> of all the <code> Element
 </code> s with a given tag name in the order in which they
 would be encountered in a preorder traversal of the <code>
 Document </code> tree.

     
*/
	public native ArrayList getElementsByTagName( String tagname);

/** 

 not part of the DOM
     
*/
	public native boolean isHTMLDocument();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentRange interface

*/
	public native Range createRange();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new NodeIterator over the subtree rooted at the specified node.

*/
	public native NodeIterator createNodeIterator( DOMNode root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new TreeWalker over the subtree rooted at the specified node.

*/
	public native TreeWalker createTreeWalker( DOMNode root, long whatToShow, NodeFilter filter, boolean entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentEvent interface

 The createEvent method is used in creating Events when it is either
 inconvenient or unnecessary for the user to create an Event themselves.
 In cases where the implementation provided Event is insufficient, users
 may supply their own Event implementations for use with the dispatchEvent method.

*/
	public native Event createEvent( String eventType);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentView interface

 The default AbstractView for this Document, or null if none available.
     
*/
//	public native AbstractView defaultView();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentStyle interface

 A list containing all the style sheets explicitly linked into or
 embedded in a document. For HTML documents, this includes external style
 sheets, included via the HTML LINK element, and inline STYLE elements.
 In XML, this includes external style sheets, included via style sheet
 processing instructions (see [XML-StyleSheet]).
     
*/
//	public native StyleSheetList styleSheets();

/** 

*/
	public native KHTMLView view();

/** 
 Introduced in DOM Level 2
 This method is from the DocumentCSS interface

 This method is used to retrieve the override style declaration for a
 specified element and a specified pseudo-element.

*/
	public native CSSStyleDeclaration getOverrideStyle( Element elt, String pseudoElt);
//	private native void newDocument( DocumentImpl i);
//	public Document( DocumentImpl i) {
//		super((Class) null);
//		newDocument( i);
//	}
}
