/***************************************************************************
                          led.cpp  -  description
                             -------------------
    begin                : do okt 9 2003
    copyright            : (C) 2003 by Roeland Merks
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "led.h"

#ifdef HAVE_MLED
#include <fstream>
#include <string>
#include <fstream>

const char *ASUS_ACPI="/proc/acpi/asus/";

Led::Led()
{
  Led("wled");
}

Led::Led(const char *ledname)
{
  string fname(string(ASUS_ACPI)+string(ledname));

  led=new ofstream(fname.c_str());

  // If there is no LED, just give a one time warning on cerr
  if (!(*led)) {
    static bool error_given=false;
    if (!error_given) {
      cerr << "Warning: trying to use Asus LED, but no ACPI-entry found.\n";
      error_given=true;
    }
  }
}

Led::~Led()
{
  Off();
  delete led;
}


void Led::On()
{
  if (*led) {
    *led << 1;
    led->flush();
  }
}

void Led::Off()
{
  if (*led) {
    *led << 0;
    led->flush();
  }
}
#else
Led::Led() {}
Led::Led(const char *) {}
Led::~Led() {}
void Led::On() {}
void Led::Off() {}
#endif
