/***************************************************************************
                          krusaderimportfilterplugin.h  -  description
                             -------------------
    begin                : fre aug 09 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qdom.h>
#include <qdir.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "krusaderimportfilterplugin.h"

typedef KGenericFactory<KrusaderImportFilterPlugin> KrusaderImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearkrusaderimportfilter, KrusaderImportFilterPluginFactory( "KrusaderImportFilterPlugin" ) );
//-----------------------------------------------
KrusaderImportFilterPlugin::KrusaderImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
//	setXMLFile("krusaderimportfilterui.rc");
	KGlobal::locale()->insertCatalogue("kbear");
	m_domDocument.setContent( QString("<group label=\"%1\"/>").arg(i18n("Krusader import")) );
}
//-----------------------------------------------
KrusaderImportFilterPlugin::~KrusaderImportFilterPlugin(){
}
//-----------------------------------------------
QString KrusaderImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void KrusaderImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	KConfig tmpConfig( "krusaderrc", true, false );
	tmpConfig.setGroup("RemoteMan");
	QStringList groupList = tmpConfig.readListEntry("Connections");
	float size = (float)groupList.count();
	if( size == 0 ) {
		invalidFileError( fileName );
		m_hasError = true;
		emit progress( 100 );
		return;
	}	
	int counter = 0;
	for( QStringList::Iterator it = groupList.begin(); it != groupList.end(); ++it ) {
		QString groupName = *it; // found groupname from Krusader, can have subgroups ( group1`group2`group3 )
		if( groupName == "expanded" || groupName == "collapsed" ) // ignore these - no group names
          	continue;

		QStringList groupNames = QStringList::split( '`', groupName ); //split group name into subgroups if any

		QDomNode groupNode;
		QDomElement parentElement = m_domDocument.documentElement();
		QStringList siteInfoList = tmpConfig.readListEntry( groupName );  // we ignore the site if it hasn't any host
		if( ! (siteInfoList.count() > 1) || siteInfoList[ 1 ].left( 5 ) == "GROUP" ) // we ignore group names 
			continue;
		QString tmp = QString::null;
		if( siteInfoList.count() > 2 ) {
			tmp = siteInfoList[ 2 ];
		}
		for( unsigned int i = 0; ! tmp.isEmpty() && i < groupNames.count() - 1; i++ ) {
			// first see if parenElement has any sub group named *it2
			groupNode = findSubGroup( parentElement, groupNames[ i ] );

			if( groupNode.isNull() ) {
 				// no it had no sub group with the given name
				// so we have to build the sub group tree
				while( i < groupNames.count() -1 ) {
					QDomElement tmpElement = m_domDocument.createElement( "group" );
					tmpElement.setAttribute( "label", groupNames[ i ] );
					parentElement.appendChild( tmpElement );	
					parentElement = tmpElement;
					++i;				
				}
			}
			else { // sub group found, lets check next level
				parentElement = groupNode.toElement();
			}
		} // for
		// now group tree is updated so lets create the site
		// first  check so the site has a host, if not ignore it
		if( tmp != QString::null ) {  // had host
			// set site
			QDomElement siteElement = m_domDocument.createElement( "site" );
			siteElement.setAttribute( "label", groupNames.last() );			
			parentElement.appendChild( siteElement );	
			// set host
			tmp = siteInfoList[ 2 ];
			QDomElement tmpElement = m_domDocument.createElement( "host" );
			QDomText txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set port
			if( siteInfoList.count() < 4 )
				continue;
			int p = siteInfoList[ 3 ].toInt();
			tmpElement = m_domDocument.createElement( "port" );
			txtNode = m_domDocument.createTextNode( QString::number( p ) );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set username
			if( siteInfoList.count() < 5 )
				continue;
			tmp = siteInfoList[ 4 ];
			tmpElement = m_domDocument.createElement( "user" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );
			// set password
			if( siteInfoList.count() < 6 )
				continue;
			tmp = siteInfoList[ 5 ];
			tmpElement = m_domDocument.createElement( "pass" );
			 // We have to decode the password
			tmp = encodePassword( tmp );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );
			// set remote directory
			if( siteInfoList.count() < 7 )
				continue;
			tmp = siteInfoList[ 6 ];
			tmpElement = m_domDocument.createElement( "remote_path" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );
			// set local directory
			tmp = QDir::homeDirPath();
			tmpElement = m_domDocument.createElement( "local_path" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );
			// set description
			if( siteInfoList.count() < 8 )
				continue;
			tmp = siteInfoList[ 7 ];
			tmpElement = m_domDocument.createElement( "description" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );
			// set protocol
			if( siteInfoList.count() < 9 )
				continue;
			tmp = siteInfoList[ 8 ];
			p = tmp.find( "://" );
			tmp = tmp.left( p );
			tmpElement = m_domDocument.createElement( "protocol" );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
		} // for
		emit progress( int(float(counter) / size * 100) );	
		counter++;	
	}	
	emit progress( 100 );
}
//-----------------------------------------------
QDomNode KrusaderImportFilterPlugin::findSubGroup( QDomElement parent, const QString& name ) {
	QDomNodeList nodeList = parent.childNodes();
	for( unsigned int i = 0; i < nodeList.count(); i++ ) {
		if( nodeList.item( i ).toElement().attribute("label") == name )
			return nodeList.item( i );
	}
	return QDomNode();
}
//-----------------------------------------------
QString KrusaderImportFilterPlugin::encodePassword( const QString& password ) {
	QString pass = password;
	QTextStream sStream( &pass, IO_ReadOnly );
	QCString bArray;
	sStream >> bArray;
	QCString result = KCodecs::base64Encode( bArray );	
	QString encodedPass = result.data();
	return encodedPass;
}
//-----------------------------------------------
void KrusaderImportFilterPlugin::invalidFileError(const QString& fileName){
	KMessageBox::sorry( 0, i18n("The file: %1\nis either empty or it's not a valid Krusader bookmarks file.").arg(fileName), i18n("Invalid import file") );
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "krusaderimportfilterplugin.moc"
#endif
