/***************************************************************************
                          commands.cpp  -  description
                             -------------------
    begin                : Don Dez 19 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "commands.h"
#include "mycanvasview.h"

// KDE includes
#include <kapplication.h>

QPoint getFreePos( QCanvas* c )
{
    MyCanvas* canvas = (MyCanvas*)c;
    
    if( !c->width() && !c->height() )
        return QPoint( canvas->rect().x(), canvas->rect().y() );

    // TODO: fix for positions on label        
    int x = KApplication::random() % canvas->rect().width() - 20;
    int y = KApplication::random() % canvas->rect().height() - 20;

    if( x > 0 && y > 0 )
        return QPoint( canvas->rect().x() + x, canvas->rect().y() + y );
    else
        return QPoint( canvas->rect().x(), canvas->rect().y() );
}


NewItemCommand::NewItemCommand( MyCanvasView* view, const QString & name )
    : KCommand()
{
    cv = view;
    m_name = name;
    m_point = getFreePos( cv->canvas() );
    item = 0;
}

NewItemCommand::~NewItemCommand()
{
    if( item->canvas() == 0 )
        delete item;
}

void NewItemCommand::execute()
{
    if( !item )
        create();
        
    item->setCanvas( cv->canvas() );
    item->move( m_point.x(), m_point.y() );
    item->show();
    cv->setCurrent( item );
}

void NewItemCommand::unexecute()
{
    if( item ) {
        item->setCanvas( 0 );
        item->hide();
    }
}

        
bool CommandUtils::canvasHasItem( QCanvasItem* item )
{
    if( item )
        return true;
        
    return false;
}

void ResizeCommand::setRect( int cx, int cy, int cw, int ch )
{
    rect = QRect( cx, cy, cw, ch );
}

void ResizeCommand::execute()
{
    if( canvasHasItem( item ) ) {
        if( m_shift && rect.width() ) {
            double r = (double)orect.height() / (double)orect.width();
            rect.setWidth( int(rect.height() / r) );
        }

        item->move( rect.x(), rect.y() );
        item->setSize( rect.width(), rect.height() );
        item->redraw();
    }
}

void ResizeCommand::unexecute()
{
    if( canvasHasItem( item ) ) {
        item->move( orect.x(), orect.y() );
        item->setSize( orect.width(), orect.height() );
        item->redraw();        
    }
}

void MoveCommand::execute()
{
    if( canvasHasItem( item ) )
        item->moveBy( x, y );
}

void MoveCommand::unexecute()
{
    if( canvasHasItem( item ) ) 
        item->moveBy( -x, -y );
}

void LineMoveCommand::execute()
{
    if( canvasHasItem( line ) ) {
        a2 = line->startPoint();
        b2 = line->endPoint();
        line->setPoints( a.x(), a.y(), b.x(), b.y() );
    }
}

void LineMoveCommand::unexecute()
{
    if( canvasHasItem( line ) )
        line->setPoints( a2.x(), a2.y(), b2.x(), b2.y() );    
}

void PictureCommand::execute()
{
    if( canvasHasItem( item ) ) {
        item->setRot( rotate );
        item->redraw();
    }
}

void PictureCommand::unexecute()
{
    if( canvasHasItem( item ) ) {
        item->setRot( orotate );
        item->redraw();
    }
}

void TextChangeCommand::execute()
{
    if( canvasHasItem( item ) )
        item->setText( text );
}

void TextChangeCommand::unexecute()
{
    if( canvasHasItem( item ) )
        item->setText( oldtext );
}

void BarcodeCommand::execute()
{
    if( canvasHasItem( item ) ) {
        item->setData( data );
        item->updateBarcode();
    }
}

void BarcodeCommand::unexecute()
{
    if( canvasHasItem( item ) ) {
        item->setData( &olddata );
        item->updateBarcode();
    }
}

NewPictureCommand::NewPictureCommand( QImage* img, MyCanvasView* v )
    : NewItemCommand( v, i18n("New Picture") )
{
    image = img;
}

void NewPictureCommand::create()
{
    PictureRectangle* r = new PictureRectangle( 0 );
    r->setImage( image );
    item = r;
}

NewRectCommand::NewRectCommand( MyCanvasView* v, bool circle )
    : NewItemCommand( v, i18n("New Rectangle") )
{
    m_circle = circle;
}

void NewRectCommand::create()
{
    DrawingRect* r = new DrawingRect( 0 );
    r->setCircle( m_circle );
    item = r;
}

NewLineCommand::NewLineCommand( MyCanvasView* v )
    : NewItemCommand( v, i18n("New Line") )
{
}

void NewLineCommand::create()
{
    item = new MyCanvasLine( 0 );
    ((MyCanvasLine*)item)->setPoints( m_point.x(), m_point.y(), m_point.x() + 40, m_point.y() + 40 );
}

NewTextCommand::NewTextCommand( QString t, MyCanvasView* v, LabelEditor* editor )
    : NewItemCommand( v, i18n("New Text") ),
      m_editor( editor )
{
    text = t;
}

void NewTextCommand::create()
{
    item = new CanvasText( text, cv->canvas(), m_editor );
}

NewBarcodeCommand::NewBarcodeCommand( MyCanvasView* v )
    : NewItemCommand( v, i18n("New Barcode") )
{
}

void NewBarcodeCommand::create()
{
    item = new CanvasBarcode( cv->canvas() );
}

void DeleteCommand::execute()
{
    if( canvasHasItem( item ) ) {
        item->setCanvas( 0 );
        item->hide();
    }
}

void DeleteCommand::unexecute()
{
    if( canvasHasItem( item ) ) {
        item->setCanvas( c );
        item->show();
    }
}

void RectCommand::execute()
{
    if( canvasHasItem( rect ) ) {
        fill2 = rect->color();
        border2 = rect->borderColor();
        borderwidth2 = rect->borderWidth();
        penstyle2 = rect->borderStyle();
        rect->setBorderColor( border );
        rect->setColor( fill );
        rect->setBorderWidth( borderwidth );
        rect->setBorderStyle( (Qt::PenStyle)penstyle );
    }
}

void RectCommand::unexecute()
{
    if( canvasHasItem( rect ) ) {
        rect->setBorderColor( border2 );
        rect->setColor( fill2 );
        rect->setBorderWidth( borderwidth2 );
        rect->setBorderStyle( (Qt::PenStyle)penstyle2 );
    }
}

void LineCommand::execute()
{
    if( canvasHasItem( line ) ) {
        pen2 = line->pen();
        line->setPen( pen );
    }
}

void LineCommand::unexecute()
{
    if( canvasHasItem( line ) )
        line->setPen( pen2 );
}

