#include "category.h"
#include "currents.h"
#include "tracing.h"
#include "globals.h"
#include "navigation.h"

// back/forward tracing functions

void addTrace( Currents c )
{
    	if( backlast != backptr )
        	backTracev.erase( backTracev.begin()+backptr+1, backTracev.end() );

       	backTracev.push_back( c );
       	backptr++;
	backlast = backptr;	
}

void clearTrace()
{
    	backTracev.clear();
    	backptr = -1;
    	backlast = -1;
}

int backTrace()
{
    	if( backptr != -1 )
    	{
		Currents c; c.save();

		if( !clear_goto( backTracev[ backptr ].fullpath ) )
			return FALSE;

		if( backptr == backlast )
		{
            		addTrace( c );
	    		backptr--;
		}

       		backTracev[ backptr ].load_nocat();

        	backptr--;
		return TRUE;
    	}

    	return FALSE;
}

int fwdTrace()
{
    	if( backlast > backptr + 1 )
    	{
		if( !clear_goto( backTracev[ backptr + 2 ].fullpath ) )
			return FALSE;
        	backTracev[ backptr + 2 ].load_nocat();

        	backptr++;
        	return TRUE;
    	}

    	return FALSE;
}

