#include <fstream>
using namespace std;

#include <qinputdialog.h>

#include "mailinglists.h"
#include "preferences.h"
#include "globals.h"
#include "smtp.h"

MailingLists::MailingLists() : QDialog()
{
	setCaption( "Kascade Mailing Lists" );
	resize( 410, 250 );
	setMinimumSize( 410, 250 );

	highlight = -1;

	Bexit = new QPushButton( this );
	Bexit->setText( "Exit" );
	Bremove = new QPushButton( this );
	Bremove->setText( "Remove" );
	Bsubscribe = new QPushButton( this );
	Bsubscribe->setText( "Subscribe" );
	Bunsubscribe = new QPushButton( this );
	Bunsubscribe->setText( "Unsubscribe" );

	LBmlists = new QListBox( this ); 

	QObject::connect( Bexit, SIGNAL( clicked() ), this, SLOT( hide() ) );
	QObject::connect( Bremove, SIGNAL( clicked() ), this, SLOT( removeItem() ) );
	QObject::connect( Bsubscribe, SIGNAL( clicked() ), this, SLOT( subscribe() ) );
	QObject::connect( Bunsubscribe, SIGNAL( clicked() ), this, SLOT( unsubscribe() ) );
}

void MailingLists::subscribe()
{
	int index = LBmlists->currentItem();
	if( index == -1 )
		return;
	
	string mlist = mlistv[2*index+1];

	Smtp smtp;
	smtp.sendMail( config->emailAddress(), 
		       mlist, 
		       "subscribe",
		       "" );

	if( !smtp.success )
		return;

	string text = (const char *)(LBmlists->text( index ));
	text[text.length()-1] = '+';
	LBmlists->changeItem( text.c_str(), index );

	save();
}

void MailingLists::unsubscribe()
{
	int index = LBmlists->currentItem();
	if( index == -1 )
		return;

	string mlist = mlistv[2*index+1];

	Smtp smtp;
	smtp.sendMail( config->emailAddress(),
		       mlist,
		       "unsubscribe",
		       "" );

	if( !smtp.success )
		return;

	string text = (const char *)(LBmlists->text( index ));
	text[text.length()-1] = '-';
	LBmlists->changeItem( text.c_str(), index );

	save();
}

void MailingLists::removeItem()
{
	int index = LBmlists->currentItem();
	if( index == -1 )
		return;

	LBmlists->removeItem( index );
	mlistv.erase( mlistv.begin()+2*index, mlistv.begin()+2*index+2 );

	save();
}

void MailingLists::addMlist( string name, string address )
{
	mlistv.push_back( name + " -" );
	mlistv.push_back( address );

	update();
	save();
}

void MailingLists::resizeEvent( QResizeEvent * )
{
	int w = this->width(), h = this->height();
	
	Bsubscribe->setGeometry( w-110, 10, 100, 25 );
	Bunsubscribe->setGeometry( w-110, 40, 100, 25 );
	Bremove->setGeometry( w-110, 80, 100, 25 );
	
	Bexit->setGeometry( w-110, h-35, 100, 25 );  

	LBmlists->setGeometry( 10, 10, w-130, h-20 ); 
}

void MailingLists::update()
{
	LBmlists->clear();

	for( unsigned int n = 0; n < mlistv.size(); n += 2 )
		LBmlists->insertItem( mlistv[n].c_str() );

	show();
}

void MailingLists::load()
{
	ifstream ifs;
	string file = getenv( "HOME" );
	file += "/.kascade/mailinglists";
	ifs.open( file.c_str() );

	if( !ifs.good() )
		return;

    	ifs.unsetf( ios::skipws );

	string mlist;

	while( !ifs.eof() )
	{
        	getline( ifs, mlist, '\n' );

		if( mlist != "" )
			mlistv.push_back( mlist );
	}

	ifs.close();
}

void MailingLists::save()
{
	ofstream ofs;
	string file = getenv( "HOME" );
	file += "/.kascade/mailinglists";
	ofs.open( file.c_str() );

	for( unsigned int n = 0; n < mlistv.size(); )
		ofs << mlistv[n++] << endl;

	ofs.close();
}
