#include <string>
#include <vector>
#include <fstream>
#include <sys/types.h>
#include <iostream>
using namespace std;

#include "category.h"
#include "currents.h"
#include "files.h"
#include "globals.h"
#include "utility.h"
#include "errors.h"
#include "navigation.h"
#include "parser.h"


#ifdef GUI
#include <qstatusbar.h>
#include <qmessagebox.h>

#include "http.h"
#include "preferences.h"
#include "browser.h"
#endif

// load a dii file, or one of its mirrors and go to the root of it. first check to see 
// if this file, or one of its mirrors is contained in the dii file cache.

int loadDIIFile( string path, string file )
{
        Currents c; c.save();
        
//	cout << "LOAD FILE " + path + "|" + file << endl;

        vector<string> mirrors;
        dirToVec( path, mirrors, ',', TRUE );

        if( mirrors.empty() )
                mirrors.push_back( "" );

	aPath = mirrors[ mirrors.size()-1 ];

        // have we cached one of the mirrors ?

        int entry;
        for( unsigned int n = 0; n < mirrors.size(); n++ )
                if( cached( mirrors[n], file, entry ) )
                {
#ifndef GUI		
                        if( !checkingstructure )
                                cout << "( " << slashConcat( mirrors[n], file ) << " already parsed )" << endl;
#endif				

                        cCategory = cacheCatv[ entry ];
			aPath = cacheAddressv[ 3*entry ];
			cPath = cacheAddressv[ 3*entry+1 ];
			cFile = cacheAddressv[ 3*entry+2 ];

                        return TRUE;
                }

	// when checking structure, we don't load new files

        if( checkingstructure )
                return FALSE;

        // try if we can open the file, or one of the mirrors

        int n;
        string extdir;
        for( n = mirrors.size()-1; n >= 0; n-- )
        {
                extdir = slashConcat( mirrors[n], file );

                if( readFile( extdir ) )
                        break;

		if( aborted )
			BACKTRACK
        }

	// if that fails, try the cache server
	
	if( n == -1 )
	{
		string cacheaddress;
		string path = mirrors[ mirrors.size()-1 ];

	 	if( path.find( "http://" ) == 0 )
			cacheaddress = "http://cache:" + path.substr( 7, path.length()-7 );
	
		aborted = FALSE;
		if( ( cacheaddress == "" ) ||
#ifdef GUI		    
		    ( config->cacheServer() == "" ) ||
#endif    					   
		    ( !readFile( slashConcat( cacheaddress, file ) ) ) ) 				
		{		
			if( aborted )
				BACKTRACK

			string msg = "could not open:";
	        	for( unsigned int n = 0; n < mirrors.size(); n++ )
				msg += "\n" + slashConcat( mirrors[n], file );
			showNavigationError( msg );
	
			browser->statusBar()->message( "Ready.." );

			BACKTRACK
		}	

		cPath = cacheaddress;	
	}
	else
		cPath = mirrors[n];

        cFile = file;

        if( !( cCategory = processDIIFile( extdir ) ) )
		BACKTRACK 

        cacheCatv.push_back( cCategory );
	cacheAddressv.push_back( aPath );
	cacheAddressv.push_back( cPath );
	cacheAddressv.push_back( cFile );
        cacheSourcev.push_back( sourcev );

        return TRUE;
}

// given the address of a file, try to read its contents in vector<string> *sourcev.

int readFile( string address )
{
//	cout << "read " << address << endl;

    	if( address.find( "http://" ) == 0 )
    	{
#ifdef GUI
		if ( address.find( "cache:" ) == 7 )
			address = slashConcat( config->cacheServer(), "requestfile.php?url=http://" +
				  address.substr( 13, address.length()-13 ) ); 	
		
		Http http;
		return http.getFile( address );
#else		
		if( address.find( "cache:" ) == 7 )
			address = "c:/cache/" + address.substr( 13, address.length()-13 );
		else
	    		address = "c:/" + address.substr( 7, address.length()-7 );
#endif
	}

    	ifstream ifs;

    	ifs.open( address.c_str() );
    	if( !ifs.good() )
        	return FALSE;

    	ifs.unsetf( ios::skipws );

    	string line;
    	sourcev = new vector<string>;

    	while( !ifs.eof() )
    	{
        	getline( ifs, line, '\n' );
        	sourcev->push_back( line );
    	}

    	ifs.close();
    	return TRUE;
}

// destroy everything that is cached ( categories, source files, .. )

void clearCache()
{
	Currents c; c.save();

	for( unsigned int n = 0; n < cacheCatv.size(); n++ )
	{
		delete cacheCatv[n];
		delete cacheSourcev[n];
	}	
		
	cacheCatv.clear();
	cacheAddressv.clear();
	cacheSourcev.clear();

	cCategory = 0;

	for( unsigned int n = 0; n < backTracev.size(); n++ )
		backTracev[n].c_selectionentered = FALSE;

	if( clear_goto( c.fullpath ) )
		c.load_nosel();
}

// check cache for occurrence of file

int cached( string path, string file, int &entry )
{
    for( entry = 0; entry < cacheCatv.size(); entry++ )
        if( ( cacheAddressv[3*entry+1] == path ) && ( cacheAddressv[3*entry+2] == file ) )
  	    return TRUE;
    return FALSE;
}

void launchExtension( string address )
{
#ifdef GUI
	launchExtension( config->webBrowser(), address );
#else
	cout << "launch extension on:" << endl << address << endl;
#endif	
}

void launchExtension( string application, string address )
{
#ifdef DEBUGOUTPUT
	cout << "exec " + application + " " + address << endl;
#endif	
#ifdef GUI
	if( application == "" )
	{
		QMessageBox::warning( browser, "Error", "Please enter an application for this purpose" );

		config->show();
		return;
	}
	
	browser->timedMessage( "Launching..", 2000 );

/*	if( vfork() == 0 )
	{
		if( execlp( application.c_str(), application.c_str(), address.c_str(), (char *) 0 ) < 0 ) 
			cout << "could not launch application" << endl;
		exit(0);
	} 
*/

	system( string( application + " " + address + "&" ).c_str() );
#endif	
}

