/*
 * Copyright (C) 2003 Hans Karlsson <karlsson.h@home.se>
 */

#ifndef _KARAMBA_H_
#define _KARAMBA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <kapplication.h>

#include <kwinmodule.h>
#include <kwin.h>

#include <qfile.h>
#include <kfile.h>
#include <qfileinfo.h>
#include <kaction.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qpainter.h>
//#include <krootpixmap.h>
#include <qregexp.h>
#include <qlabel.h>
#include <qobjectlist.h>
#include <qstring.h>
#include <qstringlist.h>
#include <ksharedpixmap.h>
#include <qvaluestack.h>
#include <dcopclient.h>
#include <kpopupmenu.h>
#include <qcursor.h>
#include <netwm.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <qmap.h>
#include <kurl.h>
#include <krun.h>
#include <qdatetime.h>

#include "karambarootpixmap.h"

#include "bar.h"
#include "textlabel.h"
#include "imagelabel.h"
#include "graph.h"

#include "clickarea.h"

#include "sensorparams.h"
#include "memsensor.h"
#include "datesensor.h"
#include "uptimesensor.h"
#include "memsensor.h"
#include "cpusensor.h"
#include "networksensor.h"
#include "xmmssensor.h"
#include "noatunsensor.h"
#include "programsensor.h"
#include "disksensor.h"
#include "sensorsensor.h"
#include "textfilesensor.h"

/**
 * @short Application Main Window
 * @author Hans Karlsson <karlsson.h@home.se>
 * @version 0.17
 */
class karamba :  public QWidget
{
    Q_OBJECT

public:
    karamba(QString fn);

    virtual ~karamba();

protected:
    void mousePressEvent( QMouseEvent *);
    void mouseReleaseEvent( QMouseEvent *);
    void mouseDoubleClickEvent( QMouseEvent *);
    void mouseMoveEvent( QMouseEvent *);
    void closeEvent ( QCloseEvent *);
    void paintEvent ( QPaintEvent *);



private:
    KWinModule*    kWinModule;
    NETWinInfo* info;
    bool onTop;
    bool fixedPosition;

    bool parseConfig();
    int getInt( QString, QString & );
    int getInt( QString, QString &, bool & );
    // get3Int reads an int triplet, e.g. COLOR:0,50,100
    void get3Int(QString w, QString &line, int&, int&, int& );
    void get3Int(QString w, QString &line, int&, int&, int&, bool& );
    QString getString( QString, QString & );
    QString getString( QString, QString &, bool& );
    bool getBoolean( QString, QString & );
    bool getBoolean( QString, QString &, bool& );

    void setSensor( QString &line , Meter* meter);
    void passClick( QMouseEvent* );

    QMap<QString, Sensor*> sensorMap;
    QObjectList *meterList;
    QObjectList *sensorList;
    QObjectList *clickList;

    QTime lowerTimer;
    // use only the first occurance of KARAMBA in a config file
    bool foundKaramba;

    DCOPClient *client;
    QCString appId;

    QPixmap pm;
    QPixmap background;
    QPainter p;
    KarambaRootPixmap *kroot;
    QString themeFile;
    QString themePath;


    QPoint clickPos;
    KPopupMenu *kpop;
    KActionCollection *accColl;
    KToggleAction *toggleLocked;
    bool locked;

public slots:
    void step();
    void updateSensors();
    void currentDesktopChanged(int);

    void updateBackground(KSharedPixmap*);

private slots:
    void startNewKaramba();
    void reloadConfig();
    void editConfig();
    void slotToggleLocked();
};

#endif // _KARAMBA_H_
