/***************************************************************************
    copyright            : (C) 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KALLERYGLOBALS_H
#define KALLERYGLOBALS_H

#include "kallery_def.h"

#include <qstring.h>

/**
 * @short
 * Singleton object for storing global variables.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
*/
class KalleryGlobals{
public:
  /**
   *  since this class is a singleton you must use this function to access it
   *  @return the class pointer
   */
  static KalleryGlobals* ref()
  {
    static KalleryGlobals *m_ref;
    if (!m_ref) m_ref = new KalleryGlobals();
    return m_ref;
  }

  ~KalleryGlobals();

  /**
   * Get the base directory for Kallery resources.
   * @return the base directory (usually $KDEDIR/share/apps/kallery)
   */
  const QString baseDir() {return m_baseDir;}
  
  /**
   * Set the base resource directory.
   * @param dir the base resource directory.
   */
  void setBaseDir(const QString& dir) {m_baseDir = dir;}

  /**
   * Get the base project directory.
   * @return the base project directory.
   */
  const QString projectBaseDir() {return m_projectBaseDir;}
  /**
   * Set the base project directory
   * @param dir the base project directory
   */
  void setProjectBaseDir(const QString& dir) 
  {
    m_projectBaseDir = dir;
    options.fileName = dir;
  }

    /**
   * Get the project file name.
   * @return the project file name.
     */
  const QString projectFile() {return m_projectFile;}
  /**
   * Set the project file name
   * @param file the project file name
   */
  void setProjectFile(const QString& file) 
  {
    m_projectFile = file;
  }

  /**
   * Get the list of supported file types.
   * @return the list of supported file types.
   */
  const QString imageFilter() {return m_imageFilter;}
  /**
   * Set the list of supported file types.
   * @param filter the list of supported file types.
   */
  void setImageFilter(const QString& filter) {m_imageFilter = filter;}

  /**
   * Reset options to their default value.
   */
  void setDefaultOptions();

  struct OptionType options; ///< stores all the options

private:
    /** Private constructor as it is a singleton. */
    KalleryGlobals();

    QString m_baseDir; ///< The base directory for application data.
    QString m_projectFile; ///< The name with full path of the project file.
    QString m_projectBaseDir; ///< The base directory for the project.
    QString m_imageFilter; ///< List with supported images
};

#endif
