########################################################
# K3D_WITH_SH

AC_DEFUN([K3D_WITH_SH], [
AC_SUBST(K3D_SH_SUBDIR)
AC_SUBST(K3D_SH_CFLAGS)
AC_SUBST(K3D_SH_LIBS)
AC_ARG_WITH(sh, [  --with-sh               build plugins based on libsh  [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_MSG_CHECKING([for libsh])
	if [test -f $withval/include/sh/sh.hpp && test -f $withval/lib/libsh.a]; then
		K3D_SH_SUBDIR="sh"
		K3D_SH_CFLAGS="-I$withval/include"
		K3D_SH_LIBS="-L$withval/lib -lsh -lshutil -L$withval/lib/sh -lsharb -lshcc -lshgl -lshglsl"
		AC_MSG_RESULT([found libsh])
	else
		AC_MSG_ERROR([couldn't find libsh ... if you don't require plugins based on libsh, re-run configure using the --without-sh option])
	fi
fi
])

