#ifndef RUBYMACROS_H
#define RUBYMACROS_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Define macros usefull when extending the ruby scripting engine
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include <ruby.h>

#include <string>

/// Common conversions
#define RBVAL_TO_INT(i)		(NUM2INT(i))
#define RBVAL_TO_LONG(i)	(NUM2LONG(i))
#define RBVAL_TO_ULONG(i)	(NUM2ULONG(i))
#define RBVAL_TO_DOUBLE(dp)	(NUM2DBL(dp))

#define INT_TO_RBVAL(i)		(INT2NUM(i))               // from integer to ruby integer
#define DOUBLE_TO_RBVAL(dp)	(rb_float_new(dp))         // from double to ruby double

// From std::string to Ruby string
inline VALUE String_To_Ruby(const std::string& s)
{
	return rb_str_new2(s.c_str());
}
// From Ruby string to std::string
inline std::string Ruby_To_String(VALUE s)
{
	return std::string(STR2CSTR(rb_funcall(s, rb_intern("to_s"), 0)));
}

/// Well known Ruby values
#define RBVAL_NULL		Qnil
#define RBVAL_NONE		Qnil
#define RBVAL_VOID		Qnil
#define RBVAL_TRUE		Qtrue
#define RBVAL_FALSE		Qfalse
#define RBVAL_ONE		INT2NUM(1)
#define RBVAL_ZERO		INT2NUM(0)

#endif // RUBYMACROS_H

