// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the most basic transform object
		\author Ed Millard (emillard@direcway.com)
*/

#include <k3dsdk/classes.h>
#include <k3dsdk/object.h>
#include <k3dsdk/persistence.h>
#include <k3dsdk/module.h>
#include <k3dsdk/transformable.h>

namespace
{

/////////////////////////////////////////////////////////////////////////////
// transform_implementation

class transform_implementation :
	public k3d::transformable<k3d::persistent<k3d::object> >
{
	typedef k3d::transformable<k3d::persistent<k3d::object> > base;

public:
	transform_implementation(k3d::idocument& Document) :
		base(Document)
	{
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<transform_implementation>,
			k3d::interface_list<k3d::itransform_source,
			k3d::interface_list<k3d::itransform_sink > > > factory(
			k3d::classes::Transform(),
			"Transform",
			"Standard position / orientation / scale transformation",
			"Objects",
			k3d::iplugin_factory::STABLE);

		return factory;
	}

private:
};

} // namespace

namespace libk3dcore
{

/////////////////////////////////////////////////////////////////////////////
// transform_factory

k3d::iplugin_factory& transform_factory()
{
	return transform_implementation::get_factory();
}

} // namespace libk3dcore
