// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
          \author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/module.h>
#include <k3dsdk/plugins.h>

#include "bitmap_composite_simple.h"

namespace libk3dbitmap
{

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_div_implementation

class bitmap_image_div_implementation :
	public bitmap_composite_simple
{
	typedef bitmap_composite_simple base;
public:
	bitmap_image_div_implementation(k3d::idocument& Document) :
		base(Document)
	{
	}

	void on_value_change() {}

	void on_composite(const k3d::pixel& A, const k3d::pixel& B, k3d::pixel& O)
	{
		if (B.red != 0)
			O.red = A.red / B.red;
		else
			O.red = A.red;

		if (B.green != 0)
			O.green = A.green / B.green;
		else
			O.green = A.green;

		if (B.blue != 0)
			O.blue = A.blue / B.blue;
		else
			O.blue = A.blue;

		if (B.alpha != 0)
			O.alpha = A.alpha / B.alpha;
		else
			O.alpha = A.alpha;
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<bitmap_image_div_implementation>,
			k3d::interface_list<k3d::ibitmap_source,
			k3d::interface_list<k3d::ibitmap_sink> > > factory(
				k3d::uuid(0x88f38816, 0x86ff40a5, 0xb3e3f012, 0x5c6b8dc1),
				"BitmapImageDivide",
				"Divide one image by another",
				"Objects",
				k3d::iplugin_factory::STABLE);

		return factory;
	}
};

/////////////////////////////////////////////////////////////////////////////
// bitmap_image_div_factory

k3d::iplugin_factory& bitmap_image_div_factory()
{
	return bitmap_image_div_implementation::get_factory();
}

} // namespace libk3dbitmap

