// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the CApplicationFrame class, which implements the per-application UI
		\author Tim Shead (tshead@k-3d.com)
*/

#include "about_box.h"
#include "button.h"

#include <k3dsdk/application.h>
#include <k3dsdk/paths.h>
#include <k3dsdk/result.h>

#include <sdpgtk/sdpgtkevent.h>

#ifdef RootWindow
#undef RootWindow
#endif // RootWindow

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// about_box

about_box::about_box() :
	base(dynamic_cast<k3d::icommand_node*>(&k3d::application()), "about_box", 0)
{
	return_if_fail(LoadGTKMLTemplate("about.gtkml"));

	// Set our version and copyright notices ...
	Label("version").SetText(("K-3D Version " + k3d::version_string()).c_str());

	if(get_button("ok"))
		get_button("ok")->signal_activate().connect(SigC::slot(*this, &about_box::on_ok));

	// Center it ...
	gtk_window_set_position(RootWindow(), GTK_WIN_POS_CENTER);

	Show();
	DoModal();
	delete this;
}

void about_box::on_ok()
{
	CancelModal();
}

} // namespace k3d


