#ifndef K3DSDK_STATE_CHANGE_SET_H
#define K3DSDK_STATE_CHANGE_SET_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
	\author Tim Shead (tshead@k-3d.com)
*/

#include <memory>

namespace k3d
{

// Forward declarations
class idocument;
class istate_change_set;

/// Factory function for creating standard state change set objects
std::auto_ptr<istate_change_set> create_state_change_set();

/// Convenience function that starts recording a state change set for undo/redo purposes
void start_state_change_set(idocument& Document);
/// Convenience function that cancels recording the current state change set
void cancel_state_change_set(idocument& Document);
/// Convenience function that finishes recording a state change set for undo/redo purposes
void finish_state_change_set(idocument& Document, const std::string& Label);

/** \brief RAII helper class that provides  a return- and exception-safe way to record state changes for UNDO purposes
	\note You should prefer to use this class whenever possible, instead of start_state_change_set() / finish_state_change_set()
*/
class record_state_change_set
{
public:
	record_state_change_set(idocument& Document, const std::string& Label);
	~record_state_change_set();

private:
	idocument& m_document;
	const std::string m_label;
};
} // namespace k3d

#endif // !K3DSDK_STATE_CHANGE_SET_H

