#ifndef K3DSDK_OBJECT_H
#define K3DSDK_OBJECT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares k3d::object, a default implementation of the k3d::iobject interface, for use as a base class for document plugins
		\author Tim Shead (tshead@k-3d.com)
*/

#include "command_node.h"
#include "data.h"
#include "ideletable.h"
#include "idocument.h"
#include "iobject.h"
#include "object_data.h"
#include "property_collection.h"
#include "result.h"
#include "selectable.h"

namespace k3d
{

// Forward declarations
class iplugin_factory;

/// A default implementation of the k3d::iobject interface, for use as a base class for document plugins
class object :
	public iobject,
	public ideletable,
	public selectable,
	public command_node,
	public property_collection,
	public SigC::Object
{
public:
	object(idocument& Document);
	virtual ~object();

	// iobject implementation ...
	const id_type id();
	void set_id(const id_type ID);
	void set_name(const std::string Name);
	const std::string name();
	idocument& document();

	deleted_signal_t& deleted_signal();
	name_changed_signal_t& name_changed_signal();
	visibility_changed_signal_t& visibility_changed_signal();

private:
	void on_deleted();
	void on_name_changed();
	void on_deselect_all();

	/// Stores the Document that owns this object
	idocument& m_document;
	/// Stores the ID for this object
	id_type m_id;
	/// Stores the name for this object
	k3d_data_property(std::string, immutable_name, change_signal, with_undo, local_storage, no_constraint) m_name;
	/// Used to signal observers when this object is deleted
	deleted_signal_t m_deleted_signal;
	/// Used to signal observers when the visibility state changes
	visibility_changed_signal_t m_visibility_changed_signal;
};

} // namespace k3d

#endif // !K3DSDK_OBJECT_H



