#ifndef K3DSDK_NAMESPACE_DOCUMENTATION_H
#define K3DSDK_NAMESPACE_DOCUMENTATION_H

/** \file
	\brief This do-nothing file is used to provide a central point for documenting the K-3D library namespaces for use with Doxygen
	\author Timothy M. Shead <tshead@k-3d.com>
*/

/// Namespace reserved for the boost library, see http://www.boost.org
namespace boost
{
	/// Namespace reserved for the boost filesystem library, see http://www.boost.org/libs/filesystem
	namespace filesystem {}
	/// Namespace reserved for the spirit parser framework, see http://spirit.sourceforge.net
	namespace spirit {}
}

/// Namespace reserved for all public symbols in the K-3D libraries (K3DSDK, K3DUI, and K3DEMBED)
namespace k3d
{

/// Contains the standard K-3D bitmap preview widget plus helper objects
namespace bitmap_preview
{
	/// Contains private implementation details of the standard K-3D bitmap preview widget
	namespace detail {}
}

/// Contains the standard K-3D button widget plus helper objects
namespace button
{
	/// Contains private implementation details of the standard K-3D button widget
	namespace detail {}
}

/// Contains functions and classes used to make working with k3d::ichannel objects easier
namespace channel {}

/// Contains the standard K-3D check button widget plus helper objects
namespace check_button
{
	/// Contains private implementation details of the standard K-3D check button widget
	namespace detail {}
}

/// Contains the standard K-3D chooser widget plus helper objects
namespace chooser {}

/// Contains commonly-used plugin object class identifiers, so specific plugin objects can be instantiated
namespace classes {}

/// Contains the standard K-3D color-chooser widget plus helper objects
namespace color_chooser {}

/// Contains the standard K-3D combo-box widget plus helper objects
namespace combo_box {}

/// Contains constraint objects used with k3d::data and related objects
namespace constraint {}

/// Contains the K-3D DAG control plus helper objects for visualizing document objects and their DAG connections
namespace dag_control
{
	/// Contains private implementation details for the K-3D DAG control
	namespace detail {}
}

/// Contains private implementation details for the K-3D SDK
namespace detail {}

/// Contains the standard K-3D text edit widget plus helper objects
namespace edit_control {}

/// Contains a boost::spirit grammar and related objects for parsing numeric expressions
namespace expression {}

/// Contains private implementation objects not considered part of the public API
namespace implementation_private {}

/// Contains marshalling objects for use with libsigc++ signals
namespace marshaller {}

/// Contains objects for storing and converting real-world units-of-measure
namespace measurement
{
	/// Contains policy objects for converting between real-world units-of-measure
	namespace conversion {}
} // namespace measurement

/// Contains the standard K-3D menu item widget plus helper objects
namespace menu_item {}

/// Contains the standard K-3D object selection widget plus helper objects
namespace object_chooser {}

/// Contains functions that return operating system filepaths configured by the user at compile-time
namespace path {}

/// Contains the standard K-3D filesystem path chooser widget plus helper objects
namespace path_chooser {}

/// Contains functions and classes used to make object serialization & persistence easier
namespace persistence {}

/// Contains functions and classes used to export easily-modifiable "properties" from objects
namespace property {}

/// Contains functions and classes used to generate RenderMan compatible descriptions of a document
namespace ri {}

/// Contains the standard K-3D shader arguments widget plus helper objects
namespace shader_arguments {}

/// Contains the standard K-3D shader information widget plus helper objects
namespace shader_info {}

/// Contains the standard K-3D shader selection widget plus helper objects
namespace shader_selector {}

/// Contains the standard K-3D spin button widget plus helper objects
namespace spin_button {}

/// Contains functions and classes used to generate realtime OpenGL views of a document
namespace viewport {}

} // namespace k3d


#endif // !K3DSDK_NAMESPACE_DOCUMENTATION_H

