#ifndef K3DSDK_IOBJECT_COLLECTION_H
#define K3DSDK_IOBJECT_COLLECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares iobject_collection, a container of iobject objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iobject.h"
#include "signal_system.h"

#include <set>

namespace sdpxml
{

class Document;
class Element;

} // namespace sdpxml

namespace k3d
{

// Forward declarations
class iplugin_factory;

/// Abstract interface for a collection of K-3D objects
class iobject_collection :
	public virtual iunknown
{
public:
	/// Defines a collection of objects
	typedef std::set<iobject*> objects_t;

	/// Adds new objects to the collection
	virtual void add_objects(const objects_t& Objects) = 0;
	/// Returns the set of all objects in the collection
	virtual const objects_t& collection() = 0;
	/// Removes objects from the collection
	virtual void remove_objects(const objects_t& Objects) = 0;
	/// Returns the next-available unique object ID
	virtual iobject::id_type next_available_id() = 0;

	/// Defines a signal that will be emitted whenever objects are added to the collection
	typedef SigC::Signal1<void, const objects_t&> add_objects_signal_t;
	virtual add_objects_signal_t& add_objects_signal() = 0;
	/// Defines a signal that will be emitted whenever objects are removed from the collection
	typedef SigC::Signal1<void, const objects_t&> remove_objects_signal_t;
	virtual remove_objects_signal_t& remove_objects_signal() = 0;
	/// Defines a signal that will be emitted whenever an object is renamed
	typedef SigC::Signal1<void, iobject*> rename_object_signal_t;
	virtual rename_object_signal_t& rename_object_signal() = 0;

protected:
	iobject_collection() {}
	iobject_collection(const iobject_collection& RHS) {}
	iobject_collection& operator = (const iobject_collection& RHS) { return *this; }
	virtual ~iobject_collection() {}
};

} // namespace

#endif // !K3DSDK_IOBJECT_COLLECTION_H


