// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements k3d::channel functions
		\author Tim Shead (tshead@k-3d.com)
*/

#include "basic_math.h"
#include "channel.h"
#include "ibezier_channel.h"
#include "result.h"

namespace k3d
{

namespace channel
{

bool set_constant_value(iunknown& Channel, const boost::any Value)
{
	if(Value.type() == typeid(double))
		{
			typedef ibezier_channel<void> channel_t;
			channel_t* const channel = dynamic_cast<channel_t*>(&Channel);
			return_val_if_fail(channel, false);

			channel_t::control_points_t control_points(1, k3d::vector2(0, boost::any_cast<double>(Value)));
			channel->set_curve(control_points);

			return true;
		}
	else if(Value.type() == typeid(vector3))
		{
			typedef ibezier_channel<vector3> channel_t;
			channel_t* const channel = dynamic_cast<channel_t*>(&Channel);
			return_val_if_fail(channel, false);

			channel_t::control_points_t control_points(1, k3d::vector2(0.0, 0.0));
			channel_t::values_t values(1, boost::any_cast<vector3>(Value));
			channel->set_curve(control_points, values);

			return true;
		}

	return false;
}

} // namespace channel

} // namespace k3d


